#!/usr/bin/python
from gi.repository import Gio

PREINSTALLED_LAUNCHER_DESKTOP_FILES = ["application://ubuntu-amazon-default.desktop", "application://UbuntuOneMusiconeubuntucom.desktop"]

UNITY_LAUNCHER_SETTINGS = "com.canonical.Unity.Launcher"
UNITY_LAUNCHER_FAVORITE_KEY = "favorites"

def install_default_webapps_in_launcher():
    new_desktop_files = PREINSTALLED_LAUNCHER_DESKTOP_FILES

    if len(new_desktop_files) != 0:
        try:
            settings = Gio.Settings.new (UNITY_LAUNCHER_SETTINGS)
            if not settings.is_writable(UNITY_LAUNCHER_FAVORITE_KEY):
                print "Unity Webapps migration process (preinstallation): 'favorites' key not writable"
                return
            favorites = settings.get_strv(UNITY_LAUNCHER_FAVORITE_KEY)

            # only append the desktop icons that are not already present in the favorites list if any
            favorites.extend([desktop_file for desktop_file in new_desktop_files if not desktop_file in favorites])

            settings.set_strv(UNITY_LAUNCHER_FAVORITE_KEY, favorites)
            settings.sync()
        except:
            pass

if __name__ == "__main__":
    install_default_webapps_in_launcher()

