// ==UserScript==
// @include       http://grooveshark.com/#!/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['player_play_pause', 'player_next'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function getTrackInfo() {
    var artist = null;
    var title = document.title;
    var artLocation = null;
    var album = null;
    try {
        artist = document.evaluate('//*[@id="playerDetails_current_song"]/a[@class="artist"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.title;
        title = document.getElementsByClassName('currentSongLink song')[0].title;
        album = document.evaluate('//*[@id="playerDetails_current_song"]/a[@class="album"]', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.title;
        artLocation = document.evaluate('//*[@class="queue-item queue-item-active"]/div/div/div/img', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue.src;
    } catch (x) {}

    if (!artLocation) {
        return null;
    }

    return {
        title: title,
        album: album,
        artist: artist,
        artLocation: artLocation
    };
}

function musicPlayerSetup() {
    Unity.MediaPlayer.init("Grooveshark");

    setInterval(wrapCallback(function retry() {
        var trackInfo = getTrackInfo();

        if (!trackInfo) {
            return;
        }

        var notpaused = document.getElementById('player_play_pause').className.match(/pause$/);
        if (null !== notpaused) {
            Unity.MediaPlayer.setPlaybackState(Unity.MediaPlayer.PlaybackState.PLAYING);
        } else {
            Unity.MediaPlayer.setPlaybackState(Unity.MediaPlayer.PlaybackState.PAUSED);
        }
        Unity.MediaPlayer.setTrack(trackInfo);
    }), 1000);

    Unity.MediaPlayer.onPlayPause(wrapCallback(function () {
        launchClickEvent(document.getElementById('player_play_pause'));
    }));

    Unity.MediaPlayer.onNext(wrapCallback(function () {
        launchClickEvent(document.getElementById('player_next'));
    }));

    Unity.MediaPlayer.onPrevious(wrapCallback(function () {
        launchClickEvent(document.getElementById('player_previous'));
    }));
}

if (isCorrectPage()) {
    Unity.init({ name: "Grooveshark",
		 domain: 'grooveshark.com',
		 homepage: 'http://grooveshark.com',
                 iconUrl: "icon://unity-webapps-grooveshark",
                 onInit: wrapCallback(musicPlayerSetup) });
}
