// ==UserScript==
// @include       http://www.hulu.com/watch/*
// @require       utils.js
// ==/UserScript==

evalInPageContext(function () {
     // player don't have playVideo/pauseVideo/getCurrentTime methods
     // in greasemonkey context.

    window.Unity = external.getUnityObject(1);

    function isCorrectPage() {
        var i, ids = [];

        for (i = 0; i < ids.length; i++) {
            if (!document.getElementById(ids[i])) {
                return false;
            }
        }

        return true;
    }

    function extractText(element) {
        var i, result = '';

        for (i = 0; i < element.childElementCount; i++) {
            var child = element.children[i];
            if (child.textContent) {
                result += child.textContent;
            } else {
                result += extractText(child);
            }
        }
        return result;
    }

    function getTrackInfo() {
        var album = document.evaluate('//div[@id="show-name-watch-div"]/span/h2/a', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
        var title = extractText(document.evaluate('//div[@id="show-name-watch-div"]/span/h2', document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue);
        if (album) {
            album = extractText(album);
            title = title.substr(album.length);
        }
        return {
            title: title,
            album: album,
            artist: null,
            artLocation: 'http://static.huluim.com/images/logo.jpg'
        };
    }

    function getPlayerState(callback) {
        var player = document.getElementById('player');
        var time = player.getCurrentTime();
        setTimeout(function () {
            callback(player.getCurrentTime() === time);
        }, 100);
    }

    function playOrPause() {
        getPlayerState(function (isPaused) {
            var player = document.getElementById('player');
            if (isPaused) {
                player.resumeVideo();
            } else {
                player.pauseVideo();
            }
        });
    }

    function musicPlayerSetup() {
        Unity.MediaPlayer.init("Hulu");
        Unity.MediaPlayer.setCanGoPrevious(false);

        Unity.MediaPlayer.onPlayPause(function () {
            playOrPause();
        });

        Unity.MediaPlayer.onNext(function () {
            var player = document.getElementById('player');
            player.nextVideo();
        });

        setInterval(function () {
            Unity.MediaPlayer.setTrack(getTrackInfo());

            getPlayerState(function (isPaused) {
                if (!isPaused) {
                    Unity.MediaPlayer.setPlaybackState(Unity.MediaPlayer.PlaybackState.PLAYING);
                } else {
                    Unity.MediaPlayer.setPlaybackState(Unity.MediaPlayer.PlaybackState.PAUSED);
                }
            });
        }, 1000);

        Unity.MediaPlayer.setTrack(getTrackInfo());
    }

    if (isCorrectPage()) {
        Unity.init({ name: "Hulu",
		     domain: 'hulu.com',
		     homepage: 'http://www.hulu.com/profile/queue', //TODO: include it
		     iconUrl: "icon://unity-webapps-hulu",
                     onInit: musicPlayerSetup });
    }
});
