function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function (uri) {
        //TODO: work with multiply pages.
        //we should support creating lunchers more than once per page
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._browser.injectScript(makeAuthorizer('Email', 'Passwd', this._login, this._password));
        } else if (uri === 'https://plus.google.com/games/498289062763') {
            setTimeout(this._browser.finish.bind(this._browser), 10000);
        } else if (uri.match(/^https:\/\/plus.google.com/)) {
            this._browser.open('https://plus.google.com/games/498289062763');
        }
        this._state++;
    },

    validateCallLog: function (log, out) {
        assertEquals('Unity.init', log[1].func, 'Unity.init');
        assertEquals('Zynga Poker', log[1].args[0].name, 'Zynga Poker');
        assertEquals('https://plus.google.com/games/498289062763', log[1].args[0].homepage, 'https://plus.google.com/games/498289062763');
    },

    scriptName: 'GooglePlusGames/GooglePlusGames.user.js'
};
