#!/usr/bin/perl

use strict;
use warnings;
use diagnostics;

my $max_print = 1000;

my @files = ();

my $ARBHOME = $ENV{'ARBHOME'};
if (not defined $ARBHOME) { $ARBHOME = 'swhudd9a6sd23g'; }

sub scan_tree_recursive($);
sub scan_tree_recursive($) {
  my ($dir) = @_;
  # print "scan_tree_recursive '$dir'\n";
  opendir(DIR,$dir) || die "can't read directory '$dir'";
  my @subdirs = ();
  foreach (readdir(DIR)) {
    if (not /^[.]+$/) { # ignore curr- and up-dir
      my $fullname = $dir.'/'.$_;
      if (not -l $fullname) { # ignore links
        if (-d $fullname) {
          if (not (/^CVS$/ or
		   /\.arch-ids/ or
		   /^,,/ or 
		   /^\{arch\}/ or 
                   $fullname =~ /^$ARBHOME\/PROBE_SERVER\/bin$/ or
                   $fullname =~ /^$ARBHOME\/PROBE_SET\/bin$/ or
                   $fullname =~ /^$ARBHOME\/ARB_SOURCE_DOC$/ or
                   $fullname =~ /^$ARBHOME\/HELP_SOURCE\/(Xml|genhelp)$/ or
                   $fullname =~ /^$ARBHOME\/GDEHELP\/(HELP_GEN|HELP_DOC_GEN)$/ or
                   $fullname =~ /^$ARBHOME\/lib\/(help|help_html)$/ or
                   $fullname =~ /^$ARBHOME\/bin$/))
              {
                push @subdirs, $fullname;
              }
        }
        else {
          if (not (/\.o$/ or
                   /\.a$/ or
                   /\.so$/ or
                   /\.arb$/ or
                   /\.gz$/ or
                   /\.tgz$/ or
                   /\.class$/ or
                   /\.jar$/ or
                   /\.genmenu$/ or
                   /\.stamp$/ or
                   /\.depends$/ or
                   /\.cvsignore$/ or
                   /\.last_gcc$/ or
                   $fullname =~ /^$ARBHOME\/HELP_SOURCE\/(date\.xsl|html\.list|_index\.html)$/ or
                   $fullname =~ /^$ARBHOME\/GDEHELP\/(helpfiles\.lst|ARB_GDEmenus)$/ or
                   $fullname =~ /^$ARBHOME\/PERL2ARB\/.*ARB\.(bs|xs|c|3pm)$/ or
                   $fullname =~ /^$ARBHOME\/PERL2ARB\/(debug|proto)\.h$/ or
                   $fullname =~ /^$ARBHOME\/PERL2ARB\/Makefile$/ or
                   $fullname =~ /^$ARBHOME\/NTREE\/nt_date\.h$/ or
                   $fullname =~ /^$ARBHOME\/lib\/ARB\.pm$/ or
                   $fullname =~ /^$ARBHOME\/AISC\/aisc$/ or
                   $fullname =~ /^$ARBHOME\/AISC_MKPTPS\/aisc_mkpt$/ or
                   $fullname =~ /\/GEN[CH]\// or
                   /^TAGS$/))
            {
              push @files, $fullname;
            }
        }
      }
    }
  }
  closedir(DIR);
  foreach (@subdirs) {
    scan_tree_recursive($_);
  }
}

my $diff2last_last;
my $diff2last_last_len;

sub diff2last($) {
  my ($str) = @_;
  my $result = '';
  if (not defined $diff2last_last) {
    $result = $diff2last_last = $str;
    $diff2last_last_len = length($diff2last_last);
  }
  else {
    my $len = length($str);
    my $i;
    my $is_diff = 0;
    for ($i=0; $i<$len and $i<$diff2last_last_len;++$i) {
      my $character = substr($str,$i,1);
      if ($is_diff==0 and substr($diff2last_last,$i,1) eq $character) {
        if ($character eq ' ') {
          $is_diff = 0;
          $result .= ' ';
        }
        else {
          $result .= '=';
        }
      }
      else {
        $result .= $character;
        $is_diff = 1;
      }
    }
    print substr($str,$i);
    $diff2last_last     = $str;
    $diff2last_last_len = $len;
  }
  return $result;
}

sub max($$) {
  my ($a,$b) = @_;
  return $a if $a>$b;
  return $b;
}

sub perform_search() {
  my $root = `pwd`;
  chomp($root);

  scan_tree_recursive($root);
  my %filedate = ();
  foreach (@files) {
    my $modtime = (stat($_))[9];
    $filedate{$_} = $modtime;
    # print scalar(localtime($modtime))." $_\n";
  }

  my @sorted = sort {
    $filedate{$b} <=> $filedate{$a};
  } @files;

  if (scalar(@sorted)<$max_print) { $max_print=scalar(@sorted); }

  my $maxlen = 0;
  foreach (my $i=0; $i<$max_print; ++$i) {
    my $len = length($sorted[$i]);
    if ($len > $maxlen) {
      $maxlen = $len;
      # print "debug: new maxlen=$maxlen ($sorted[$i])\n";
    }
  }
  my $spacer = "-------------";
  while (length($spacer) < $maxlen) { $spacer .= $spacer; }

  foreach (my $i=0; $i<$max_print; ++$i) {
    $_ = $sorted[$i];
    my $len = length($_);
    print "$_:1: ".substr($spacer,0,max($maxlen-$len,0)).
      "last mod: ".diff2last(scalar(localtime($filedate{$_})))."\n";
  }
}

perform_search();
