/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef _PICTURE_H_
#define _PICTURE_H_

struct env {
	WORD left,top;
	WORD h,w;
};
typedef struct env envelope;

#define pic_underkill		1 // if total underlay kill him
#define pic_overkill		2 // if total overlay kill him
#define pic_interlace_merge	4 // if interlaced merge

BOOL  shutdown_pictures(void);
BOOL  del_picture(INT handle);
INT   new_picture(INT top,INT left,INT h,INT w,WORD mod);
DWORD update_pictures(BYTE ** pool);
PBYTE get_picture(INT handle);
INT   merge_pictures(INT ha1,INT ha2);
INT   undo_pictures(PBYTE pool,DWORD size);

extern BYTE pic_state;
#define  pic_non_exist	0
#define  pic_in_core	1
#define  pic_flushed	2
#define  pic_any_fail	128
#define  pic_hard_fail 	(pic_any_fail+1)
#define  pic_write_fail	(pic_any_fail+2)
#define  pic_core_fail 	(pic_any_fail+3)

#endif // _PICTURE_H_
