/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>


#include "nt_types.h"
#include "struct.h"
#include "lang_def.h"
#include "func.h"
#include "discrim.h"
#include "ligas.h"
#include "linutil.h"
#include "tuner.h"
extern Word8 *EVN_GetSegmentPool (void);
//#include "Autofont.H"
#include "tm.h"  //NB 4.4.95
#include "diffrb.h"
//#include "sfont.h"
#include "p2libr.h"
#include "status.h"

#include "compat_defs.h"

extern BYTE digital_string_penalty;
//AK for debug
static LONG * AK_deb;
/*============ Import functions ==================*/
BOOL test_alphabet_elem(BYTE let);

INT  Diskrim(BYTE let,PBYTE raster,INT dw,INT x,INT y,INT dx,INT dy,BYTE cg,INT inc);
INT  discr_angles(BYTE let, INT dy, INT type);
void init_diskrim(PBYTE r,INT h,INT w);
void calc_angles(struct rst *rast,PBYTE p,BYTE ang[],BYTE cflgl,BYTE cflgr);
BOOL snap_show_raster(PBYTE raster, INT height, INT width);

INT  SumIntervalBits( BYTE *r, INT bx, INT ex);
INT  NumHorizInterval( BYTE *r, INT );
INT  corner_type(BYTE crn);
INT  cut_by_pos_ii(s_glue * gl,BYTE let);

/*============ Export functions ==================*/

segment * go_line(segment * seg_pool,WORD ln);
void proc_bI(INT pass); // glue ''
INT  chkquocks2(cell * c,PBYTE r,INT h,INT w,INT d);
void c_add_raster(PBYTE target,INT wb,INT y,INT col,PBYTE source,
        INT sh,INT swb);
struct rst create_raster(cell * c, const s_glue * gl);
/*========== Local functions ===================*/


static INT  RE_rus_Ge(INT hist[], INT histd[], INT hei, INT wid);
static void RE_final_descr(cell *c);
static BOOL similar_S( INT hist_n[],INT hist_d[], INT w,INT h);
static BOOL similar_R( INT hist_n[],INT h);
static INT  check_kk(INT h);
static INT  short_lines2(cell * c);
static BOOL check_dnri_hook( s_glue *s, cell * c );
static BOOL check_dnri_hook_cell( cell * c , INT w);
static BOOL check_upri_hook_cell( cell * c );
static BOOL check_uple_hook_cell( cell * c );
static BOOL dust_in_glue( cell *s,s_glue *GL,INT c1,INT r1,INT c2, INT r2);
static BOOL dust_near_rusG(cell *cc);
static void adjust_left(PBYTE pint,INT height);
static void calc_data(PBYTE pint,INT height,INT width );
static INT  discr_iot(cell * c,BYTE let,INT upper);
static void _init_(void);
static INT  sym_italic( cell * c,BYTE let );
static BOOL valid_inc( WORD inc );
static WORD check_inc_foots(cell * c,INT nums);
static INT  calc_dest_foot(INT h,INT w,INT *dest_foot,INT wid_foot);
static WORD check_num_foots(INT nums,INT h);
static INT  check_cursiv_inp(BYTE *rast,INT w,INT h,INT foot_wid,INT dest,BYTE let);
static BOOL check_bend_up( cell * c );
static BOOL check_bend_dn( cell * c );
static INT  multicell_hist(cell *base_c, const s_glue *GL,
			    INT hist_n[], INT hist_d[]);
static void add_cell_to_hist(cell *c,INT off_str,INT hist_n[],INT hist_d[]);
static void make_white_hist(PBYTE pint,INT height);
static void calc_abris(PBYTE pint,INT height );
static BOOL valid_line(segment * segm);
static INT  triangle_bottom(BYTE *raster,INT dx, INT dy, INT wid);
static INT  triangle_top(BYTE *raster,INT dx, INT dy, INT wid);
static WORD internal_filling(segment * segm,INT h,INT w);
static BOOL stick_online(cell * c);
static BOOL suspect_italic_iee(void);
static BOOL suspect_italic_tche(void);
static BOOL suspect_italic_ii(void);
static BOOL suspect_italic_III(cell*);
static BOOL suspect_italic_kk(void);
static BOOL suspect_italic_ce(cell *c);
static BOOL suspect_italic_III_bend(cell * c);
static INT  o_symmetric(INT h,INT w);
/*----*/
static WORD check_III(cell *c,INT foot_wid,INT dest[]);
static WORD check_III_bend(cell *c,INT dest[]);
static WORD check_futuris_aa(struct rst * const rst);
static WORD check_EK(BYTE let,cell * c);
static WORD check_tg( cell * c, BYTE let, PBYTE RASTR, INT dx, INT dy );
static WORD check_ya( cell * c);
static WORD check_zz( cell * c);
static WORD check_xX( cell * c);
static WORD check_xk(INT h,BYTE let) ;
static WORD check_pl( cell * cc, cell * ci,BYTE let,struct rst * const rst);
static WORD check_iee( cell * c,BYTE let);
static WORD check_oa( cell * c,BYTE let,struct rst * const rst);
static WORD check_ee( cell * c);
static WORD check_uu( cell * c,INT h);
//static WORD check_ss(cell * c,PBYTE pint,INT height);
static WORD check_veza(cell * c,segment * segm,INT h,INT w,BYTE let);
static WORD check_nn(cell * c);
static WORD check_m( cell * c);
static WORD check_AL(cell * c,BYTE let);
static WORD check_stick( cell * c,BYTE let );
static WORD check_cursiv( cell * c,BYTE let,INT old_diskr,BYTE *rast);
static WORD stick_bI(cell * cl);
static INT  check_italic_ch(INT h);
static WORD check_I_dot(cell * c,BYTE let);    // !
static WORD check_bb(void);

/*========== Import global data ===================*/

extern BYTE db_status    ;    // snap presence byte
extern BYTE db_trace_flag;    // snap-detail presence byte
extern BYTE db_pass      ;    // snap-pass indicator

extern BYTE broken_flag  ;    // broken raster discrim safety
extern BYTE broken_ii    ;    // two sticks flag for rus discr

extern BYTE work_raster[];
extern BYTE work_raster_1[];
extern INT iFont;
/*extern*/ BYTE *segment_pool;

/*========= Global data ===================*/

/*========= Local data ===================*/
static BYTE Rus_similar_Eng[]="rn$痐";//"rNn$痐";
static BYTE abris_online;
static BYTE corners[4];
static INT hist_n[128],hist_d[128];/* ᫮ ࢠ  ப  ⭮ */
static INT hist_white[128]; /* ﭨ  1-  ன  */
static INT hist_black[128]; /*  1-                       */
static BYTE rus_like[]=""; // ""
static BYTE emu_like[]="x"; // "oOx"
static STICK *stick; // pointer to array of stick if NULL no calculated stick
static STICK stic[30];
static INT   nstick;       // number of sticks in letter
static WORD dens;
static s_glue glc;
//AK!
static INT l_abris[80],r_abris[80];

INT dnri_hook, top_dnri_hook;// bootom right hook samll russian italic letters III,II
INT upri_hook, bot_upri_hook;
INT uple_hook, bot_uple_hook;
INT up_jack;
/*
 number of foots < 16 +
 iclineness :
 0  - about no incline
 16 - like italic
 32 - strong incl
 64 - any incline
 128 - must match number of foots and his incline
 */
static BYTE let_stick[256] = {
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
//   ! " # $ % & ' ( ) . + , - . /
   0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
// 0 1 2 3 4 5 6 7 8 9 : ; < = > ?
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
// @ A B C D E F G H I J K L M N O
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
// P Q R S T U V W X Y Z [ \ ] ^ _
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
// ` a b c d e f g h i j k l m n o
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
// p q r s t u v w x y z { | } ~
   0,0,0,1,0,1,1,0,2,1,1,0,0,2,0,2,
//                
   1,0,1,0,1,1,0,1,3,0,1,0,1,0,1,1,
//                
   0,0,0,1,0,0,1,0,2,0,1,0,0,2,0,2,
//                
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   1,0,1,0,1,1,0,1,1,0,1,0,1,0,1,1,
//                
   0,0,0,0,0,3,0,2,0,0,0,0,0,0,0,0,
//  g       m   u z         a
   };

 /*============= Source codes ===================*/

/*********************************************************start r_criteria*/
void r_criteria(cell *c, const s_glue * gl)              //10.02.97
{
 extern BOOL TM_check_active;
 version *v0;
 LONG    d,d_ang,d_cun,d_abris,i,dd;                       //change from INT
 CHAR    snap[380],*s=snap;
 struct rst _rst;
 MN *    mn;
 cell *  cc=NULL;
 BYTE    pen_m=0,flag_m=0,maxprob;
 LONG     inc=0 ;                                          //change from INT
 version    save[VERS_IN_CELL];
 INT    snvers;

 // Nick 20.02.2001 - add *sizeof(version) !!!
if( c->nvers>0 )
    memcpy(save,c->vers,c->nvers*sizeof(version));
snvers=c->nvers;

 *s = 0;
 if( c->vers[0].let == bad_char )
    return;

 if(  erection_enable && (c->pos_inc&erect_rot)   &&
      c->stick_inc!=NO_INCLINE && c->stick_inc>200 )
        inc = c->stick_inc;

 _rst = create_raster(c,gl);
 if(_rst.raster == NULL)
    return; // Can't make raster

 if((_rst.w < 4 && !memchr("|!1\0xbc",c->vers[0].let,4)) || _rst.h < 8)
    return;

 if( (gl != NULL && gl->ncell > 1) )
    broken_flag = 1;
  else
    broken_flag = 0;
 memset(&glc,0,sizeof(glc));
 if( gl )
   glc = *gl;
  else
   {
    glc.celist[0]=c;
    glc.celist[1]=NULL;
    glc.ncell=1;
   }

 // init zone
 multicell_hist(c,gl,hist_n, hist_d);
 dnri_hook = check_dnri_hook( &glc, c );
 upri_hook = check_upri_hook_cell( c );
 uple_hook = check_uple_hook_cell( c );
 up_jack   = RE_rus_Ge(hist_n, hist_d, (INT)(c->h<30?4:6),c->w);

 init_diskrim(_rst.raster,_rst.h,_rst.w);
 _init_();

 if( gl == NULL )
    cc = c;
  else
    {
     cell * cp;
     INT h;
     for(i=0,h=0;i < gl->ncell ;i++)
       if( gl->celist[i]->flg & (c_f_let | c_f_bad)
           && gl->celist[i]->env != NULL
           && !(gl->celist[i]->cg_flag & c_cg_noenv))
         if( h <  gl->celist[i]->h)
          {
           h = gl->celist[i]->h;
	   cp = gl->celist[i];
          }
     if( h && _rst.h <= cp->h+2)
     cc = cp; // set main comp
    }
 abris_reset();
 mn = c_locomp(_rst.raster,(INT)((_rst.w + 7)>>3),_rst.h,0,0);
 segment_pool = EVN_GetSegmentPool();
 make_white_hist(segment_pool,_rst.h);
 dens = internal_filling((segment*)segment_pool,_rst.h,_rst.w);

//#pragma warning	( disable : 4047 4024 )				   //AK 11.03.97

 calc_angles(&_rst,segment_pool,/*&*/corners,              //AK 04.03.97 ? for address
              (BYTE)(c->cg_flag&c_cg_cutl),(BYTE)(c->cg_flag&c_cg_cutr));
 abris_online = TRUE;
 calc_abris(segment_pool,_rst.h);

 for (maxprob=0,v0=c->vers,i=0; v0->let != 0; v0++)
   {
    if( v0->prob>maxprob )
       maxprob=v0->prob; /* Oleg : 30-05-1994 */
    if( v0->let == r_cu_m && (!broken_flag || !inc) )
      { // Analize m
       cell C=*c;
       BYTE p=v0->prob;

       flag_m=TRUE;
       C.vers[0].let='m';
       C.vers[0].prob=p;
       C.vers[1].let=0;
       C.vers[1].prob=0;
       C.nvers=1;
       atlant(&C,&glc,1,1);      // study legs
       pen_m = p - C.vers[0].prob;
      }
   }
 if( !c->broken_II  )
   {
    if( !broken_ii && broken_flag ) // Oleg : 1-07-1994 : set signum two sticks
      {
       INT num;
       for(num=0,i=0;i < gl->ncell ;i++)
         if(   gl->celist[i]->flg & (c_f_let | c_f_bad) &&
               gl->celist[i]->env != NULL  &&
               !(gl->celist[i]->cg_flag & c_cg_noenv))
           if(   _rst.h-2 <= gl->celist[i]->h &&
                 gl->celist[i]->stick_inc!=NO_INCLINE &&
                 gl->celist[i]->stick_inc!=0 ) // rotate
             num++; // count big comp
       if( num==2 )
         broken_ii=1;
      }

    if( broken_ii && c )
      c->broken_II=1;
   }

 for (v0=c->vers,i=0; v0->let != 0; v0++)
   {                              // init zone
    d = 0;
    i++;
    d_cun = 0;
    d_abris = 0;
    if(v0->prob < 50)
      {
       v0->prob=0;
       continue;
      } // reject weak letters

    dd = 1;
    if( enable_table_recog )
      dd = test_alphabet_elem( v0->let ) ;

    if( dd )
      switch(v0->let)
       {
        case  (BYTE)'$':
            if( i == 1 )
	            {                        /*c->vers[0].let == '$' ){*/
                INT  i,dl=0,dr=0;
                if( c->prevl->flg & c_f_let )
	                {
                    for(i=0;i<c->prevl->nvers;i++)
                        if( is_digit(c->prevl->vers[i].let)
		                    && c->prevl->vers[i].prob > 100 )
		                    {
                            dl = 1;
                            break;
                            }
                    }
                if( c->nextl->flg & c_f_let )
	                {
                    for(i=0;i<c->nextl->nvers;i++)
                        if( is_digit(c->nextl->vers[i].let)
		                    && c->nextl->vers[i].prob > 100 )
		                    {
                            dr = 1;
                            break;
                            }
                    }
                if( dr == 0 && dl == 0 )
     	            {
                    if( (c->recsource&c_rs_ev) &&
                        (c->vers[0].prob == 254 || c->vers[0].prob == 234) )
                        c->vers[0].prob -= 20;
                    else if( c->vers[0].prob > 150 )
                        c->vers[0].prob -= 150;
                    else
                        c->vers[0].prob = 2;
                    }
                }/* if unique $ */
            break;
        case  (BYTE)'':
        case  (BYTE)'':
        case  (BYTE)'':
        case  (BYTE)'':
            if(cc && !broken_flag)
                d_cun += check_tg( cc, v0->let,_rst.raster,_rst.w,_rst.h);
            if( cc && dust_near_rusG(cc) )
                d += 80;
            break;
        case  (BYTE)'':
        case  (BYTE)'':
            if(cc)
	            d_cun += check_EK(v0->let,cc);
            break;
        case  (BYTE)'':
            d_cun += check_veza(cc,(segment*)segment_pool,_rst.h,_rst.w,v0->let);
            break;
        case  (BYTE)'':
        case  (BYTE) UKR_e:
            if(cc && (cc->recsource & c_rs_ev))
                break;
            d_cun += check_veza(cc,(segment*)segment_pool,_rst.h,_rst.w,'');
            break;
        case  (BYTE)'':
            if(cc)
	            d_cun += check_nn(cc);
            break;
        case  (BYTE)'':
            if(cc)
                d_cun += check_AL(cc,v0->let);
            break;
        case  (BYTE)'':
            if(cc)
                d_cun += check_AL(cc,v0->let);
        case  (BYTE)'':
        case  (BYTE)'':
        case  (BYTE)'':
            if(cc)
	            d_cun += check_pl( cc,c, v0->let,&_rst);
	        if( broken_flag && glc.ncell==2 &&
		        dust_in_glue(cc,&glc,33,33,66,66) )
    	     d_cun += 80;
             break;
        case  (BYTE)'':
            if( cc )
                if(  !(erection_enable && (cc->pos_inc&erect_rot))  )
                    d_cun = check_oa( cc,'',&_rst);
            break;
        case  (BYTE)'':
            d_cun += check_veza(cc,(segment*)segment_pool,_rst.h,_rst.w,v0->let);
            break;
        case  (BYTE)'':
						//    . 08.09.2000 E.P.
			if (language==LANG_RUSSIAN && langBul)
				{d_cun = 200;break;}

            d_cun += check_veza(cc,(segment*)segment_pool,_rst.h,_rst.w,v0->let);
            if( cc )
                d_cun += check_ee(cc);
            break;
        case  (BYTE)'':
            d_cun += check_veza(cc,(segment*)segment_pool,_rst.h,_rst.w,v0->let);
            if(cc) d_cun += check_zz(cc);
                if( cc )
                    d_cun += check_ee(cc);
            break;
        case  (BYTE)'':
            if(cc)
	            d_cun = check_ya( cc );
            break;
        case  (BYTE)'':
        case  (BYTE)'':
            if(cc && !broken_flag)
	            d_cun = check_iee( cc,v0->let );
            break;
        case  (BYTE)'':
            if(cc)
	            d_cun += check_xX( cc );
	        d_cun += check_xk(_rst.h,v0->let);
            break;
        case  (BYTE)'':
            if(cc) d_cun = check_xX( cc );
         break;
        case  (BYTE)'':
            d_cun += check_xk(_rst.h,v0->let);
            if( inc && !(corners[0]==128 && corners[2]==128) )
                if( dnri_hook && !upri_hook )
                    d_cun+=40;
            break;
        case  (BYTE)'':
            d_cun = check_bb();
        case  (BYTE)'':
            if( dust_in_glue(cc,&glc,60,0,100,33) )
	            d += 80;
            break;
        case  (BYTE)'':
        case  (BYTE)'':
            d_cun = cut_by_pos_ii(&glc,v0->let);
            break;
        case  (BYTE)'':
        case  (BYTE)'':
            if( dust_in_glue(cc,&glc,0-20,66-20,33,100) )
	            d += 80;
            break;
        case  (BYTE)'':
        case  (BYTE)'' :
            if( cc && dust_in_glue(cc,NULL,25,33,75,66) )
                d += 80;
            break;
        case (BYTE)r_cu_a:
            if(cc)
	            d_cun += check_oa( cc,'',&_rst);
            break;
        case (BYTE)r_cu_u:
            d_cun = check_uu( cc,_rst.h );
            break;
        case (BYTE)r_cu_m:
            d_abris = pen_m;
            if(cc&&!(c->pos_inc&(erect_rot|erect_zero)))
	            d_cun = check_m(cc);
            if(cc&&(c->pos_inc&erect_zero))
	            d_cun += 80;
            break;
        case (BYTE)'|':
            d_cun = stick_bI(c);
            break;
        case (BYTE)'!':
        case (BYTE)'>':
        case (BYTE)'<':
			            d_cun = check_I_dot(c,v0->let);
		 break;

		// 31.08.2000 E.P.
        case (BYTE)liga_exm_usual:
		 if (liga_exm_usual == liga_exm)
            d_cun = check_I_dot(c,v0->let);
		 break;

        case (BYTE)liga_exm_latin:
		 if (liga_exm_latin == liga_exm)
            d_cun = check_I_dot(c,v0->let);
		 break;

        case (BYTE)'1':
           d_cun = check_I_dot(c,v0->let);
         break;
       }

    dd=-1;
    if( enable_table_recog )
      if( !test_alphabet_elem(v0->let) )
        dd=digital_string_penalty;
    if( dd<0 )
      dd = Diskrim(v0->let,_rst.raster,_rst.w,0,0,_rst.w,_rst.h,c->cg_flag,(INT)inc);

    if( dd<0 )
      {       // Bonus  2-  
       switch( dd )
        {
         case -254 :
            v0->prob = MIN(254,maxprob+4);
	  break;
         case -250 :
            v0->prob = MIN(254,maxprob+2);
	  break;
        }
      }
     else
       d += dd;
    d_ang = discr_angles(v0->let,_rst.h,(INT)(cc?(cc->pos_inc&erect_rot):0)); // rotation
    if( flag_m && pen_m == 0 && (d != 0 || v0->prob < 232) &&
        memchr("",v0->let,3))
      d_cun += 60;
    if(memchr(rus_like,v0->let,sizeof rus_like))
      {      // Here abris discrim for rus letters that looks like english
       BYTE ch,ds;
       ch = emu_like[(PBYTE)memchr(rus_like,v0->let,sizeof rus_like) - rus_like];
       ds=(BYTE)abris(&glc,c,ch,v0->prob);
       d_abris = v0->prob - ds;
      }

        /* if cursiv turn TIGER discrimination off */
    if( //iFont!=FONT_MASH &&               // TypeWriter
        !(cc&&(cc->pos_inc&erect_rot)) && // rotation
        !(cc&&(cc->pos_inc&erect_zero)) ) // zero incline
      if( (d > 0 || memchr("",v0->let,6)) && cc != NULL )
        if( sym_italic(cc,v0->let) ||
	    (memchr("",v0->let,2) && suspect_italic_III_bend(cc)==0) ||
	    (memchr("",v0->let,2) && suspect_italic_ce(cc)==0))
          {
           d_cun += check_cursiv( cc,v0->let,(INT)d ,_rst.raster);
           d_ang =  discr_angles(v0->let,_rst.h,1);
           d = 0;
          }

    if(db_status & snap_activity(db_pass))
      {
       if( d_abris )
         s+=sprintf(s,"%c %d(%d,%d,%d,%d) ",v0->let,v0->prob,d,d_ang,d_cun,d_abris);
        else
         s+=sprintf(s,"%c %d(%d,%d,%d) ",v0->let,v0->prob,d,d_ang,d_cun);
       if(i % 4 == 0)
         {
          *s++ = '\n';
          *s = 0;
         }
      }
    d += d_ang;
if( v0->let=='|'                ||
    (c->env && !c->env->scale)  ||
    (c->cg_flag&c_cg_cut) )
    d += d_cun;
    d += d_abris; // sum penalty
    if ( TM_check_active &&
         (v0->let=='T' || v0->let=='t' || v0->let==(BYTE)'' || v0->let==(BYTE)''
         || v0->let=='M' || v0->let=='m' || v0->let==(BYTE)'' || v0->let==(BYTE)''))
       v0->prob=MAX_TM_PROB;
     else
      {
       if(v0->prob < d)
         v0->prob = 0;
        else
         v0->prob-= (BYTE)d;
      }
   }        // for by vers
 sort_vers(c);
 c->vers[c->nvers].let = 0; /* Set correct tail */
 c->vers[c->nvers].prob= 0;
 if (dens)
    s+=sprintf(s," dens:%d",dens);
 broken_ii=0;   /* Oleg : 24-05-1994 : clear two sticks flag    */
 if(db_status & snap_activity(db_pass))
   {
    snap_newcell(c);
    snap_show_text(snap);
    snap_monitor();
   }
if( comp_versions(c->vers,save,c->nvers,snvers) )
     {
     c->recsource |= c_rs_deskr;
     c->history   |= c_rs_deskr;
     }
 return;
}
/************************************************end r_criteria**/
/*=============== Discriminators for letters =====================*/

WORD check_xX(cell * c)
{
lnhead *line;
INT l;
WORD nl=0,pen=0;

 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
			(l=line->lth)>0; line=(lnhead *)((PCHAR)line+l))
  if (line->h > 2 || !(line->flg & (l_fbeg | l_fend)) ) nl++;
  if( nl == 1 ) pen+=220;
   return pen;
}
///////////////////////////////////////////////////////////////////
// check 'k','x' abris
WORD check_xk(INT h,BYTE let)
{
 WORD max,index,pen_lx,pen_lk,pen_rk,pen_rx;
 BYTE hist[128];
 INT jump[128]={0};
 INT i,smooth,mono;
	// only stright 'k','x'
	// calc histgramm
 if( ! abris_online )
    {
	 abris_online = TRUE;
     calc_abris(segment_pool,h);
    }
  pen_lx=pen_lk=pen_rk=pen_rx=0;
   // check right side
  memset(hist,0,sizeof hist);
  //AK! temporary 'zatychka' not solved problem of l_abris[..]<0!
  for(i=h/5,max=0,index=0;i < h*4/5 ;i++)
     {
	  if (r_abris[i] < 0 || r_abris[i] > 127)
		  continue;
	  hist[r_abris[i]]++;
     }
 /* check hist peak */
  for(i=0,max=0,index=0;i < sizeof(hist)/sizeof(hist[0]);i++)
     if( max < hist[i])
       {
	    max = hist[i];
		index = i;
       }
  if(index > 0 && hist[index-1]==1)
	  max++; // add one dot throw
  if(hist[index+1]==1)
	  max++;
  if( max*6 > h*5*3/5 )
     {
	  pen_rx += 60;
	  pen_rk += 60;
     }// stick in right side

  memset(hist,0,sizeof hist);
  //AK! temporary 'zatychka' not solved problem of l_abris[..]<0!
  for(i=h/5,max=0,index=0;i < h*4/5 ;i++)
	 {
	  if (l_abris[i] < 0 || l_abris[i] > 127)
		  continue;
	  hist[l_abris[i]]++;
     }
 /* check hist peak */
  for(i=0,max=0,index=0;i < sizeof(hist)/sizeof(hist[0]);i++)
     if( max < hist[i])
        {
	     max = hist[i];
		 index = i;
        }
  if(index > 0 && hist[index-1]==1)
	  max++; // add one dot throw
  if(hist[index+1]==1)
	  max++;
  if( max*6 > h*5*3/5 )
	  pen_lx += 60; // stick in left side
  // check italic
  for(i=h/5,smooth=0,mono=0;i < h*4/5-1 ;i++)
     { // skip serif
      if(abs (l_abris[i]-l_abris[i+1]) < 2)
		  smooth++;
      if( l_abris[i]-l_abris[i+1] < 0)
		  mono--;
        else
		  mono++;
     }
  i = h*4/5-1 - h/5; // total iterations
  if( i == smooth && i == abs(mono) && pen_lx == 0)
	  pen_lx += 80; // italic k
  smooth = i == smooth ? 1 : 0; // make var logical

  if( pen_rk == 0 )
     { // try to find meandr in right
      INT min,max,j,pos,neg;
      for(i=h/5+1,j=0,min=max=r_abris[h/5];i < h*4/5 ;i++,j++)
	     {
          min = MIN(min,r_abris[i]);
          max = MAX(max,r_abris[i]);
          jump[j] = r_abris[i] - r_abris[i-1];
         }
      if( max-min < 2 )
	     { //  may be meandr
          for(i=0,pos=0,neg=0; i < j;i++)
		     {  // how many peaks
              if(jump[i] > 0 )
				  pos++;
              if(jump[i] < 0 )
				  neg++;
             }
          if( pos + neg == 1 )
		    {
			 pen_rk += 30;
			 pen_rx += 80;
		    }
           else
			if( pos > 1 && neg > 1 )
		      {
			   pen_rk += 40;
			   pen_rx += 80;
		      }
         }
     }

 return let == (BYTE)'' ? pen_rx + pen_lx : pen_rk + pen_lk;
}
/////////////////////////////////////////////////////////////////////
// '' refuse with 'a' that have no upper bend
WORD check_bb(void)
{
if( dens > 210 ) return 80;
else if( dens >= BOLD ) return 60;
return 0;
}

/* Analize '<<' and '>>' abris */
static BYTE dh1[8]={ 0,0,0,1,1,2,2,3 };
static BYTE dh2[8]={ 0,0,1,1,1,2,2,3 };
INT chkquocks2(cell * c,PBYTE rstr,INT h,INT w,INT d)
{
INT i,i1,i2,extr1,ln,ln1,h1,h2;
INT tanx,tany,sum1,sum2;
MN *mn;
CHAR buf[200],tmp[200];
  mn = c_locomp(rstr,(INT)((w + 7)>>3),h,0,0);
  if(mn){
  segment_pool = EVN_GetSegmentPool();
  abris_online = TRUE;
  calc_abris(segment_pool,h);
  }
  else return 0;
    // d < 0 -- <<
    // d > 0 -- >>

     strcpy(buf,d<0? "<< ":">> "); // snap
   i1 = ( r_abris[0] - l_abris[0] < 2) ? 1 : 0;
  i2 = ( r_abris[h-1] - l_abris[h-1] < 2) ? h-2 : h-1;
  for(i=i1,ln=ln1=0,extr1=d<0 ? 20000 : 0;i <=i2 ;i++)
  if( d<0 ){
  if(l_abris[i] <  extr1 ){ extr1=l_abris[i]; ln = i; }
  if(l_abris[i] <= extr1 ) ln1 = i;
  }
  else{
  if(r_abris[i] >  extr1 ){ extr1=r_abris[i]; ln = i; }
  if(r_abris[i] >= extr1 ) ln1 = i;
  }
  if(abs((ln+ln1)/2 -  h/2) >  h/3 ) goto err;

  if( d<0? r_abris[(ln+ln1)/2] == w : l_abris[(ln+ln1)/2] == 0 ) goto err;

  h1 = ln-i1;
  tanx =((d<0)? l_abris[i1] : w-r_abris[i1]) ;
  tany =h1;
  if(tany==0) goto err;
  if((ln1-ln)*4 > h) goto err;   // may be curve

  for(i=i1,sum1=0;i < ln ;i++)

   sum1 += ((ln-i)*tanx/tany) - ((d<0)? l_abris[i] : w-r_abris[i]);

   sprintf(tmp,"upper part h %d dis %d ",h1,sum1);
   strcat(buf,tmp);

// down part

   for(i=ln;i <= i2;i++)
  if( d<0 ){
  if(l_abris[i] <= extr1 ){ extr1=l_abris[i]; ln = i; }
  if(l_abris[i] >  extr1 ) ln1 = i;
  }
  else{
  if(r_abris[i] >= extr1 ){ extr1=r_abris[i]; ln = i; }
  if(r_abris[i] >  extr1 ) ln1 = i;
  }
  if(abs((ln+ln1)/2 -  h/2) >  h/3 ) goto err;
   h2 = i2-ln;
  tanx =((d<0)? l_abris[i2] : w-r_abris[i2]) ;
  tany =h2;
  if(tany==0) goto err;
  if((ln-ln1)*4 > h) goto err; //  may be curve

  for(i=ln,sum2=0;i <= i2 ;i++)
   sum2 += ((i-ln)*tanx/tany) - ((d<0)? l_abris[i] : w-r_abris[i]);

     sprintf(tmp,"down part h %d dis %d ",h2,sum2);
   strcat(buf,tmp);
   sum2 = h2 < sizeof(dh2)/sizeof(dh2[0]) ? abs(sum2) <= dh2[h2] : abs(sum2*3) < h2;
   sum1 = h1 < sizeof(dh1)/sizeof(dh1[0]) ? abs(sum1) <= dh1[h1] : abs(sum1*3) < h1; // make var sum logical
   strcat(buf,"\n Quockets2 ");
   strcat(buf,sum1&&sum2 ? " Yes" : " No");
   if( abs(h1-h2) > MIN(h1,h2)/2) goto err;
   goto snp;
   err:
   strcpy(buf,"Error or no quockets");
   sum1=0;sum2=0;
   snp:
     if (snap_activity('e'))
     {
     snap_newcell(c);
     snap_show_text(buf);
     snap_monitor();
     }

return (sum1 && sum2);
}

// Addition to atlant
WORD check_m( cell * c)
{
WORD pen=0;
INT i;
    stick_online(c);
   if( nstick < 0 ) return 0;
   if( nstick == 1 )
    if( dens < BOLD ) pen += 100;
    else              pen += 40;
   if( nstick == 2 ){
    if( dens < BOLD ) pen += 40;
    else              pen += 20;
    if(abs(stick[0].incl - stick[1].incl) > 400 ) pen+=120;
    else if(abs(stick[0].incl - stick[1].incl) > 200 ) pen+=20;

   }
  if( nstick > 2 )
  for(i=0;i < nstick;i++){
   if( stick[i].l*4 < c->h*3 ) pen += 40;
   else if(stick[i].incl > 800 )      pen += 160;
        else if(stick[i].incl == 0 )  pen += 40;
  }
 return pen;
}
/*
WORD check_ss(cell * c,PBYTE pint,INT height)
{
segment * segm;
INT i,j,col,prev_col;
WORD d=0,gaps=0;

  if( c ) // 'c' mustn't have a hole
  gaps = ((c_comp*)c->env)->nl - ((c_comp*)c->env)->begs - ((c_comp*)c->env)->ends + 1;
  if( gaps == 1 ) d += 40;
  if( gaps > 1  ) d += 100;

for(j=0,col=0,prev_col=0;j < height/3;j++){
 // from middle to upright
for(i=0,segm = (segment*)pint,segm++;i < height/2 - j;i++) // set active line
 while((segm++)->segwhite != 0x9000); // skip lines
 prev_col = col; col = 0;
//do
 // skip dot or dust
// if(segm->segblack < 2){ col +=segm->segblack + segm->segwhite; continue; }
// else            { col +=segm->segblack;// break; }
// while((segm++)->segwhite != 0x9000);
 if(prev_col > 0 && col > 0)
  if(prev_col - col > 1) { d += 80; break; }
 }
 return d;
}
*/
WORD check_AL(cell * c,BYTE let)
{
INT gaps;
lnhead *line;
INT l;
  gaps = ((c_comp*)c->env)->nl - ((c_comp*)c->env)->begs - ((c_comp*)c->env)->ends + 1;
 if( gaps > 0)
 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
			(l=line->lth)>0; line=(lnhead *)((PCHAR)line+l))
  if(!(line->flg & (l_fend | l_fbeg)) )
   if(line->h == 1) gaps--; // skip non valueble lines
   else if(line->row > c->h/2 && line->h < 3) gaps--;

  if( let == (BYTE)'' && gaps != 1 ) return 40;
  if( let == (BYTE)'' && gaps > 0  ) return 40;
  return 0;
}

WORD check_EK(BYTE let,cell * c)
{
 lnhead *line;
 INT l;
 WORD pen_E=0,pen_K=0;

 if(((c_comp*)c->env)->nl == 1) pen_K = 200;

 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
			(l=line->lth)>0; line=(lnhead *)((PCHAR)line+l))
  if (line->row < c->h/3 && !(line->flg&l_fend) && line->h > c->h/4 )
     pen_E += 100;

 switch( let ){
 case (BYTE)'' :  return (pen_K + ( pen_E == 0 ? 100 : 0 )); break;
 case (BYTE)'' :  return pen_E; break;
 }

  return 0;
}
// 
WORD check_iee(cell * c,BYTE let)
{
 lnhead *line;
 INT l;
 WORD pen=0,gaps;

  gaps = ((c_comp*)c->env)->nl - ((c_comp*)c->env)->begs - ((c_comp*)c->env)->ends + 1;
  if( gaps == 0 && let == (BYTE)'') return 10;
  else if ( gaps == 0 && let == (BYTE)'' ) return 60;
     // hole in top right square
 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
			(l=line->lth)>0; line=(lnhead *)((PCHAR)line+l))
  if (line->row < c->h/2 &&  line->h < c->h/4 &&
  (!(line->flg&l_fend) && !(line->flg&l_fbeg))  )
     pen += 60;

  return pen;
}

WORD check_ya( cell * c)
{
 lnhead *line;
 INT l,suspect=0,strong=0;
 WORD pen=0,gaps;
   gaps = ((c_comp*)c->env)->nl - ((c_comp*)c->env)->begs - ((c_comp*)c->env)->ends + 1;
 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
			(l=line->lth)>0; line=(lnhead *)((PCHAR)line+l))
  if ( (line->flg & (l_fbeg | l_fend)) == 0 )
   if (line->row > c->h/3) suspect++;
   else                    strong++;
   if( suspect > 0 && strong == 0)   pen=100;
   if( suspect > 0 && strong > 0 )   pen=50;
   if( gaps == 0 && dens > THIN ) pen += 10;
   if( gaps == 0 && dens > BOLD ) pen += 60;
    return pen;
}

// Andrew zone
static STICK st[30],*stickLP;
static INT nstickLP;

WORD check_pl( cell * c, cell * ci,BYTE let,struct rst * const rst )
{
CHAR  maxL=0,maxR=0;
INT i,j1,j2,j,sym,nInvest;
WORD penL=0,penP=0,pen=0,top=0,meanLetter,meanLetter0;
WORD left=0,right=0,mean=0,D_X;
INT begin0,begin;
BYTE  *RAST,*RASTR,saveR[5];
MN *mn;
cell * cc=NULL;
INT dx,dy;
INT pen_serif = 0;

dx = rst->w;   dy = rst->h;   RASTR=rst->raster;
D_X = (dx+7)>>3;

//for    if  stick  with  serif
stick_online(c);
if( nstick != 2) return 0;
if( !(c->pos_inc&erect_rot) )
  if( (stick[0].incl >= 400) && (stick[1].incl <= 100) )
    {
    penP = 80;
    goto  retPL;
    }
//for    if  ...
if( (stick[0].w >= 5) && (stick[0].incl <= 0 ) && (stick[0].bot >= 0) )
  {
  penL = 80;
  goto  retPL;
  }

if( stick[0].incl <= stick[1].incl )
  {
  //calculate  number  of  lines  to  be  investigate
  if( stick[0].w <= 3 )
    nInvest = 3;
  if( stick[0].w > 3 )
    nInvest = stick[0].w-1;
  if( nInvest > dy/4 )
    nInvest = dy/4;
  for(RAST=RASTR+(dy-1)*D_X,i=0;i<dy/4;i++,RAST-=D_X)
    {
    if( SumIntervalBits(RAST,0,(INT)(dx/3)) < 3*stick[0].w/2 )
      {
      nInvest++;
			}
    }
  //calculate  begin  first  stick  in  the  bottom
  meanLetter0 = (stick[0].x+stick[1].x)/2;
  //   if( stick[0].w <= stick[0].x )
  //     meanLetter0 = (2*stick[0].x+stick[1].x)/3;
  begin0 = stick[0].x - ( 500 +(stick[0].y)*stick[0].incl)/2048
			 - stick[0].w/2;

  //calculate  number  of  black  point  in  the  left  top
  for(RAST=RASTR,i=dy;i>(dy-nInvest);i--,RAST+=D_X)
    {
    begin = begin0  + i*stick[0].incl/2048;
    j = SumIntervalBits(RAST,0,begin);
    top += j;
    }

  //calculate  number  of  black  point  on  the  left  and  on  the  right
  //from  left  stick  in  the  bottom
  for(RAST=RASTR+(dy-1)*D_X,i=0;i<nInvest;i++,RAST-=D_X)
    {
    meanLetter = meanLetter0 + i*stick[0].incl/2048;
    begin = begin0  + (i*stick[0].incl+1024)/2048;
    j1 = SumIntervalBits(RAST,0,begin);
    if( begin <= 0 )
      j1 = 0;
    left += j1;
    j2 = SumIntervalBits(RAST,(INT)(begin+stick[0].w),meanLetter);
    if( ! SumIntervalBits(RAST,(INT)(begin+stick[0].w),(INT)(begin+stick[0].w+1)) )
      j2 = 0;
    if( ! SumIntervalBits(RAST,(INT)(begin+stick[0].w-1),(INT)(begin+stick[0].w)) )
      j2 = 0;
    right += j2;
    j = 3*stick[0].w-SumIntervalBits(RAST,begin,(INT)(begin+stick[0].w));
    if( SumIntervalBits(RAST,0,(INT)(begin+stick[0].w)) < 3*stick[0].w/2 )
      {
      j = 0;
      mean = 0;
      left = 0;
      right= 0;
			}
    mean += j;
    if( maxL < j1 )
      maxL = (BYTE)j1;
    if( maxR < j2 )
      maxR = (BYTE)j2;
    }

   if( (c->cg_flag_fine&c_cg_cut_bl) && stick[0].bot<0 ||
     (c->cg_flag_fine==0)&&(c->cg_flag&c_cg_cutl) && stick[0].bot<0 )
    {
    INT n=dy/4, num, old, e;
    INT r0=VertSum(RASTR,D_X,dy,(INT)(dx-1));
    INT r1=VertSum(RASTR,D_X,dy,(INT)(dx-2));
    INT r2=VertSum(RASTR,D_X,dy,(INT)(dx-3));
    if( r0<dy && r1<=dy-2 && r1>dy-4 && r2>dy-2 )
      r1=r2;
    old=EndBlackInterval(RASTR+(dy-1)*D_X, D_X);
    for(num=0,RAST=RASTR+(dy-2)*D_X,i=1;i<n;i++,RAST-=D_X)
      {
      e=EndBlackInterval(RAST, D_X);
      num += (e>old);
      if( e<old ) break;
      old = e;
      }
    if( num>2 )
      pen_serif  = num*10;
    if( r0>dy-2 || r1>dy-2 )
      pen_serif <<= 1;
    }

   if( !left && !right )
    {
    penL = 80;
    goto  retPL;
    }

   if( !left )
    {
    penL = 80;
    goto  retPL;
    }

   if( !right )
    {
    if( (mean >= 3*nInvest) && (top < left) )
      {
      if( (stick[0].w > 3) && (left > 3*nInvest) )
        {
        penP = !(c->pos_inc&erect_rot) ? 80 : 20;
        goto  retPL;
        }
      if( (stick[0].w <= 3) && (left > 2*nInvest) )
        {
        // Oleg : ERECTION conditions : 09-08-95 08:33pm
        if( !(c->pos_inc&erect_rot) ) // 3 left vertical points ? ࠧ
          penP = !(c->pos_inc&erect_rot) ? 80 : 20;
        goto  retPL;
        }
      }

    if( !((c->pos_inc&erect_rot) && maxL<4 && maxR<3) )
      {
      if( left >= 3*nInvest )
        {
        penP += (!(c->pos_inc&erect_rot)) ? 20*(1+left - 3*nInvest) : 20;
        }
      else
        { // left  is  musor
        penL = 60;
        }
      }
    goto  retPL;
    }

  if( (left - right) < 3*nInvest )
    {// left  is  musor
    penL = 40;
    goto  retPL;
    }

  if( (right >= 3*nInvest/2) && (3*top >= 2*left) )
    {// right is  serif
    penL = 60;
    goto  retPL;
    }

  sym = 256*left/right;
  if( sym > 500 )
    {
    penP = sym-460;
    }
  else
    {
    penL = 500-sym;
    }

  goto  retPL;
  } // end of sample stick[0].incl <= stick[1].incl : ||, //

// stick[0].incl > stick[1].incl : /|
//for  not  cut  left  black  rectangle
for(i=0;( (i<D_X) && (i<5) );i++)
  {
  saveR[i] = rst->raster[i+D_X];
  rst->raster[i+D_X] = 0xFF;
  }

//cut  1/4  down  part  to  calculate   sticks  for    without  errors
mn = c_locomp(rst->raster,D_X,(INT)(dy-dy/4),0,0);
if(mn) cc=create_cell(mn,ci,0,0);
//recover  after  for  not  cut  left  black  rectangle
for(i=0;( (i<D_X) && (i<5) );i++)
  {
  rst->raster[i+D_X] = saveR[i];
  }

//calculate  sticks
if(!stickLP)
  {
  nstickLP = sticks_in_letter(cc?cc:c,0,&stickLP);
  if( nstickLP == 2 )
    {
    memcpy(st,stickLP,nstickLP*sizeof(STICK));
    stickLP = st;
    }
  }
if(cc) del_cell(cc);
if( nstickLP != 2 )
  {
  if( nstick == 2)
    {
    if(  stick[0].bot <= -2 )
      {
      penP = 20;
      goto  retPL;
      }
    }
   return 0;  // error or  inproper number of sticks
   }

//calculate  number  of  lines  to  be  investigate
if( stickLP[0].w <= 3 )
  nInvest = 3;
if( stickLP[0].w > 3 )
  nInvest = stickLP[0].w-1;
if( nInvest > dy/4 )
  nInvest = dy/4;
for(RAST=RASTR+(dy-1)*D_X,i=0;i<dy/4;i++,RAST-=D_X)
  {
  if( SumIntervalBits(RAST,0,(INT)(dx/3)) < 3*stickLP[0].w/2 )
    {
    nInvest++;
    }
	 }
//calculate  begin  first  stick  in  the  bottom
meanLetter0 = (stickLP[0].x+stickLP[1].x)/2;
//   if( stickLP[0].w <= stickLP[0].x )
//     meanLetter0 = (2*stickLP[0].x+stickLP[1].x)/3;
begin0 = stickLP[0].x - ( 500 +(dy/4+stickLP[0].y)*stickLP[0].incl)/2048
			 - stickLP[0].w/2;

//calculate  number  of  black  point  in  the  left  top
for(RAST=RASTR,i=dy;i>(dy-nInvest);i--,RAST+=D_X)
  {
  begin = begin0  + i*stickLP[0].incl/2048;
  j = SumIntervalBits(RAST,0,begin);
  top += j;
  }

//calculate  number  of  black  point  on  the  left  and  on  the  right
//from  left  stick  in  the  bottom
for(RAST=RASTR+(dy-1)*D_X,i=0;i<nInvest;i++,RAST-=D_X)
  {
  meanLetter = meanLetter0 + i*stickLP[0].incl/2048;
  begin = begin0  + (i*stickLP[0].incl+1024)/2048;
  j1 = SumIntervalBits(RAST,0,begin);
  if( begin <= 0 )
    j1 = 0;
  left += j1;
  j2 = SumIntervalBits(RAST,(INT)(begin+stickLP[0].w),meanLetter);
  if( ! SumIntervalBits(RAST,(INT)(begin+stickLP[0].w),(INT)(begin+stickLP[0].w+1)) )
    j2 = 0;
  if( ! SumIntervalBits(RAST,(INT)(begin+stickLP[0].w-1),(INT)(begin+stickLP[0].w)) )
    j2 = 0;
      right += j2;
  j = 3*stickLP[0].w-SumIntervalBits(RAST,begin,(INT)(begin+stickLP[0].w));
  if( SumIntervalBits(RAST,0,(INT)(begin+stickLP[0].w)) < 3*stickLP[0].w/2 )
    {
    j = 0;
    mean = 0;
    left = 0;
    right= 0;
    }
  mean += j;
  if( maxL < j1 )
    maxL = (BYTE)j1;
  if( maxR < j2 )
    maxR = (BYTE)j2;
  }

if( !left && !right )
  {
  penL = 80;
  goto  retPL;
  }

if( !left )
  {
  penL = 80;
  goto  retPL;
  }

if( !right )
  {
  if( (mean >= 3*nInvest) && (top < left) )
    {
    if( (stickLP[0].w > 3) && (left > 3*nInvest) )
      {
      penP = (!(c->pos_inc&erect_rot)) ? 80 : 20;
      goto  retPL;
      }
    if( (stickLP[0].w <= 3) && (left > 2*nInvest) )
      {
      penP = (!(c->pos_inc&erect_rot)) ? 80 : 20;
      goto  retPL;
      }
    }
  if( !((c->pos_inc&erect_rot) && maxL<4 && maxR<3) )
    {
    if( left >= 3*nInvest )
      {
      penP += (!(c->pos_inc&erect_rot)) ? 20*(1+left - 3*nInvest) : 20;
      }
    else
      { // left  is  musor
      penL = 60;
      }
    }
   goto  retPL;
   }

if( (left - right) < 3*nInvest )
  {// left  is  musor
  penL = 40;
  goto  retPL;
  }

if( (right >= 3*nInvest/2) && (3*top >= 2*left) )
  {// right is  serif
  penL = 60;
  goto  retPL;
  }

sym = 256*left/right;
if( sym > 500 )
  {
  penP = sym-460;
  }
else
  {
  penL = 500-sym;
  }

retPL:
if( penP > 80 )
  penP = 80;
if( penL > 80 )
  penL = 80;
if( maxR > 0 )
  {
  if( 2*(maxL-maxR) < 3*(nInvest+1) )
    {
    penP = 0;
    }
  else if( 2*(maxL-maxR) == 3*(nInvest+1) )
    {
    if( penP > 20 )
      penP = 20;
    if( penL > 40 )
      penL = 40;
    }
   }

switch( let )
  {
  case (BYTE)'':  case (BYTE)'':
    return  penP+pen_serif;
  case (BYTE)'':  case (BYTE)'':
    return  penL;
  }/* switch let */

return pen;
}/*check_pl*/

WORD check_tg( cell * c, BYTE let, PBYTE RASTR, INT dx, INT dy )
{
BYTE  j,n4=dy>>2,D_X=(dx+7)/8;
CHAR  beg,end;
INT   i,k,piece2=0,piece3=0;
INT   left=0,right=0,sum=0,tg=0;
BYTE  *RAST;

stick_online(c);
if( nstick < 0 ) return 0;
if( nstick != 1) return 100;

beg = stick[0].x+(dy-stick[0].y)*stick[0].incl/2048-stick[0].w/2;
if( beg < 0 )   beg = 0;
end = beg+stick[0].w;
if( beg > dx )  beg = (BYTE)dx;
if( end > dx )  end = (BYTE)dx;

/* calculate  symmetric  of  top */
for (RAST=RASTR,i=0;i<2*n4;i++,RAST+=D_X)
  {
  j=SumIntervalBits(RAST,1,beg)/3;
  left+=j;  sum=j;
  j=SumIntervalBits(RAST,end,dx)/3;
  right+=j; sum+=j;
  if( (sum < 2*stick[0].w) && (i>1) )
    break;
  }

for (RAST=RASTR,i=0;i<n4;i++,RAST+=D_X)
  {
  j=SumIntervalBits(RAST,1,dx/*-1*/)/3;
  if( (j < 4*(dx-1)/5) && (i>1) )
    break;
  }

for (RAST=RASTR+i*D_X,k=i;k<(i+2*n4);k++,RAST+=D_X)
  {
  j=(BYTE)NumHorizInterval( RAST, D_X );
  if( j == 2 )
    piece2++;
  if( j == 3 )
    piece3++;
  }

if(left==0)
  tg = 10;
else
  tg = piece2 - piece3 + 3*(right - left)/(left)-3;

//retTG:
switch( let )
  {
  case '7':
    if( left < 3*right )
      tg = 40+20*(3*right-left);
    else
      tg = 0;
    break;
  case (BYTE)'':  case (BYTE)'':
    if( !((c->cg_flag_fine&c_cg_cut_tl) && left<right) ||
        !((c->cg_flag_fine==0) && (c->cg_flag&c_cg_cutl) && left<right) )
      {
      if( tg>0 )
         tg = 20*tg;
      else
         tg = 0;
      }
     else
      {
      if( tg<0 )
         tg = 0;
      }
    if( left > 2*right )
      tg += ( 40+5*(left-2*right) );
    break;
   case (BYTE)'':  case (BYTE)'':
      if( tg<0 )
         tg = 20*(2-tg);
      else
         tg = 0;
      if( (c->cg_flag_fine&c_cg_cut_tl) )
        tg += 40;
      break;
   }/* switch let */

return( tg );
}/* check_tg */

// End of Andrew zone

WORD check_zz( cell * c)
{
INT i;
WORD pen=0;
      stick_online(c);
     if( nstick <= 0 ) return 0; // error or no sticks

   for(i=0;i < nstick;i++)
    if( stick[i].x < c->w/2 && stick[i].l >= c->h - 2  &&
    stick[i].incl < 400 ) pen += 120;
  return pen;
}

WORD check_uu( cell * c,INT h)
{
WORD pen;
 lnhead *line;
 INT l,cnt=0;
   pen  = check_num_foots(2,h);
   if( !c ) return pen;
if( !(c->pos_inc&erect_rot) )
   pen += check_inc_foots(c,2);

 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
                        (l=line->lth)>0; line=(lnhead *)((PCHAR)line+l))
  if ( line->h*3 >= c->h*2 && line->row+line->h >= c->h*2/3 ) cnt++;
  switch(cnt){
  case 0        : pen += 100;break;
  case 1        : pen += 40;break;
  case 2        : break;
  }
  return pen;
}

// Oleg zone

BOOL check_uple_hook_cell( cell * c )
{
 lnhead *line;
 INT l,h,ind,wid, av;
 interval *i;
 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
			(l=line->lth)>0; line=(lnhead *)((PCHAR)line+l)){
   i=(interval *)((PCHAR)line+sizeof(lnhead));
   wid = i->l;
   if( line->row<2 && line->h*2<=c->h && (i->e-i->l)*4<c->w && line->h>2 &&
         (line->flg & l_fend)  )
    {
    h=line->h;
    for( av=i->l,ind=line->row; h ;ind++,h--,i++)      /* hook-line        */
      {
      if( i->l>wid )
        wid=i->l;
      av += i->l;
      }
    av /= line->h;
    if( wid<c->w/3 || wid<c->w/2 && av<=c->w/4)
      {
      bot_uple_hook = ind;
      return TRUE;
      }
    }
  }
return FALSE;
}

BOOL check_upri_hook_cell( cell * c )
{
 lnhead *line;
 INT l,h,ind,wid;
 interval *i;
 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
			(l=line->lth)>0; line=(lnhead *)((PCHAR)line+l)){
   i=(interval *)((PCHAR)line+sizeof(lnhead));
   wid = i->l;
   if( line->row<2 && line->h*2<=c->h && (i->e-i->l)*4>c->w*3 && line->h>2 &&
         (line->flg & l_fend)  )
    {
    h=line->h;
    for( ind=line->row; h ;ind++,h--,i++)      /* hook-line        */
      {
      if( i->l>wid )
        wid=i->l;
      }
    if( wid<c->w/3 )
      {
      bot_upri_hook = ind;
      return TRUE;
      }
    }
  }
return FALSE;
}


BOOL check_dnri_hook_cell( cell * c , INT w)
{
 lnhead *line;
 INT l,h,ind, ri;
 interval *i;
 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
      (l=line->lth)>0; line=(lnhead *)((PCHAR)line+l))
  {
  i=(interval *)((PCHAR)line+sizeof(lnhead));
  if( line->row >= c->h/2 && line->h*3 <= c->h &&
      (line->flg & l_fbeg) && i->l <= c->w/3  )
    {
    h=line->h;
    for( ri=0,ind=line->row;  h ;ind++,h--,i++)      /* hook-line        */
      {
      if( i->e>ri )
        ri = i->e;
      if( !erection_enable )
        {
        hist_d[ind] -= i->l;  /* number of bits      in row   */
        hist_n[ind] --;   /* number of intervals in row   */
        }
      }
    if( c->col+ri>=w-2 )
      {
      top_dnri_hook = line->row+1;
      return TRUE;
      }
    }
  }

return FALSE;
}

BOOL check_dnri_hook( s_glue *GL, cell *s)
{
cell *c;
INT ncells=0, maxc=-1;

if( GL == NULL )
	{
	if( s )
    return (check_dnri_hook_cell(s, (INT)(s->col+s->w)));
	else
		return FALSE;
	}

while ((c=GL->celist[ncells++]) != NULL)
	{
  if( c->col+c->w>maxc )
    maxc = c->col+c->w;
  }
ncells=0;
while ((c=GL->celist[ncells++]) != NULL)
	{
  if( check_dnri_hook_cell(c,maxc) )
		return TRUE;
	}

return FALSE;
}


BOOL suspect_italic_kk(void)
{
if( nstick == 2)
 if( stick[0].incl==0 )    return TRUE;
 return FALSE;
}

BOOL suspect_italic_tche(void)
{
if( nstick == 1)
 if( stick[0].incl<=200 )    return TRUE;
 return FALSE;
}

BOOL suspect_italic_nn(void)
{
if(  nstick>3 )                  return TRUE;
if(  nstick==1 && !broken_flag ) return TRUE;
if(  nstick==3 && stick[0].incl+stick[1].incl+stick[2].incl<=200 )
 return TRUE;
if( nstick == 2)
 if( MIN(stick[0].incl,stick[1].incl)==0 &&
     MAX(stick[0].incl,stick[1].incl)==200 &&
     MIN(stick[0].w,stick[1].w) > 2) return TRUE;
 return FALSE;
}
BOOL suspect_italic_ii(void)
{
if( nstick>3 )                  return TRUE;
if( nstick==1 && !broken_flag ) return TRUE;
if( nstick == 3)
 if( stick[0].incl==0 && stick[2].incl==0 ||
     stick[1].incl==0 && stick[2].incl==0 ||
     stick[0].incl==0 && stick[1].incl==0 	) return TRUE;
if( nstick == 2)
 if( stick[0].incl==0 && stick[1].incl<=200 ||
     stick[1].incl==0 && stick[0].incl<=200 ) return TRUE;
 return FALSE;
}
BOOL suspect_italic_III(cell * c)
{
INT s=0;

     stick_online(c);
     if( nstick != 3 ) return TRUE; // error or no sticks

if( nstick == 3)
	s+= ( stick[0].incl==0)+( stick[1].incl==0 )+( stick[2].incl==0 ) ;
 return s>1;
}
BOOL suspect_italic_III_bend(cell * c)
{
INT s=0;

     stick_online(c);
     if( nstick != 3 && nstick!=4 ) return TRUE; // error or no sticks

//if( nstick == 3)
s+= ( stick[0].incl==0)+( stick[1].incl==0 )+( stick[2].incl==0 ) ;
 return s>0;
}
BOOL suspect_italic_ce(cell * c)
{
INT s=0,h=c->h,i;

     stick_online(c);
     if( nstick !=2  && nstick !=3 ) return TRUE; // error or no sticks
if( nstick==3 )
	{	// ᨢ   ஬ 
	for(i=0;i<2;i++)
		if( h-stick[i].y-stick[i].l>2 || stick[i].incl<400 )
                        return TRUE;       //   稭 ᢥ
	if( stick[3].y>0 )
                        return TRUE;       //   
	}

 s+= ( stick[0].incl==0)+( stick[1].incl==0 ) ;
 return s>0;
}

BOOL suspect_italic_iee(void)
{
if( nstick == 3)
 if( stick[0].incl==0 && stick[2].incl==0  ) return TRUE;
 return FALSE;
}

INT check_italic_ch(INT h)
{
INT i,cnt=0;
if( nstick > 1)
for(i=0;i<nstick;i++)
  if( stick[i].l*4 > h*3 ) cnt++;
 return cnt > 1 ? 100 : 0;
}

static int nstick_broken;
BOOL two_stick_online(s_glue *GL,INT *dest_foot, INT *wid_foot)
{
STICK  *s[2],ss[2];
cell *c,*cc[2];
INT ncells=0,i,j,ns,save_flg,save_cg_flag;

nstick_broken=0;
if( GL == NULL )	return FALSE;

while ((c=GL->celist[ncells++]) != NULL);
ncells--; /* ᥣ   ᯨ᪥ */

for(j=i=0;i<ncells;i++)
	{
	if( j<2 && (c=GL->celist[i])->env!=NULL && c->h>4 )
					 cc[j++]=GL->celist[i];
	}
if( j!=2 )
	return FALSE;

/* 2 ᪮ (⪠  ENV) */
for(i=0;i<2;i++)
	{
	save_flg=cc[i]->flg; save_cg_flag=cc[i]->cg_flag;
	cc[i]->flg=cc[i]->cg_flag=0;
	ns = sticks_in_letter(cc[i],0,&s[i]);
	cc[i]->flg=save_flg; cc[i]->cg_flag=(BYTE)save_cg_flag;
	if( ns != 1 )
		return FALSE;	/*  ᪮    ! */
	memcpy(&ss[i],s[i],sizeof(STICK));
	}

nstick_broken=2;
*wid_foot  = (ss[0].w+ss[1].w)/2;
*dest_foot =  (cc[0]->col>cc[1]->col ?
	      (cc[0]->col-cc[1]->col+ss[0].x-ss[1].x) :
	      (cc[1]->col-cc[0]->col+ss[1].x-ss[0].x) );
*dest_foot -= *wid_foot;

return TRUE;
}

BOOL broken_sym_italic(s_glue *GL,BYTE let)
{
STICK  *s[2];
cell *c,*cc[2];
INT ncells=0,i,j,ns,save_flg,save_cg_flag,cs;

if( ! let_stick[let] ) return FALSE;


nstick_broken=0;
if( GL == NULL )	return FALSE;

while ((c=GL->celist[ncells++]) != NULL);
ncells--; /* ᥣ   ᯨ᪥ */

for(j=i=0;i<ncells;i++)
	{
	if( j<2 && (c=GL->celist[i])->env!=NULL && c->h>4 )
					 cc[j++]=GL->celist[i];
	}
if( j!=2 )
	return FALSE;

/* 2 ᪮ (⪠  ENV) */
for(cs=i=0;i<2;i++)
	{
	save_flg=cc[i]->flg; save_cg_flag=cc[i]->cg_flag;
	cc[i]->flg=cc[i]->cg_flag=0;
	ns = sticks_in_letter(cc[i],0,&s[0]);
	cc[i]->flg=save_flg; cc[i]->cg_flag=(BYTE)save_cg_flag;
	if( ns != 1 )
		return FALSE;	/*  ᪮    ! */
	if( s[0]->l*5 >= cc[i]->h*4 )
     cs += valid_inc( s[0]->incl);
	}

return (cs>0);
}

WORD check_cursiv( cell * c,BYTE let,INT old_diskr,BYTE *rast)
{
WORD pen=0;
INT i,j,foot_wid,ind,t;   /* । ਭ  */
INT dest_foot[4]={0};

     stick_online(c);
     if( nstick <= 0 ) return 0; // error or no sticks
     if( nstick >  4 ) return 100; // too many sticks in image

for(i=foot_wid=ind=0;i<nstick;i++){
	foot_wid += stick[i].w; if(stick[i].incl > 800) continue;
        j = i;
        while(++j < nstick){
	if(stick[j].incl > 800) continue;
	  t = abs(stick[i].x - stick[j].x)-(stick[i].w+stick[j].w)/2;
	 if( t>0 )
		 dest_foot[ind++]=t;
	 break;
        }
}
foot_wid /= nstick;

if( nstick==1 )
	two_stick_online(&glc,&dest_foot[0],&foot_wid);
else
  nstick_broken=0;

if( nstick==2 || nstick_broken==2)
	dest_foot[0]=calc_dest_foot(c->h,c->w,dest_foot,foot_wid);

  switch( let ){
  case  (BYTE)''     :
  case  (BYTE)''     :
	  if(suspect_italic_III(c))
	    {
		 pen += old_diskr;
		 break;
	    }
	  pen = check_III(c,foot_wid,dest_foot);
     break;
  case  (BYTE)''     :
  case  (BYTE)''     :
	  if(suspect_italic_III_bend(c))
	    {
		 pen += old_diskr;
		 break;
	    }
		pen = check_III_bend(c,dest_foot);
	   break;
  case  (BYTE)''     :
  case  (BYTE)''     :
	  if(suspect_italic_nn()&&!dnri_hook)
	    {
		 pen += old_diskr;
		 break;
	    }
	  if( !(nstick==2 && stick[1].incl==0) )
		pen += check_inc_foots(c,2);
      pen += check_cursiv_inp(rast,c->w,c->h,foot_wid,dest_foot[0],'');
     break;
  case  (BYTE)''     :
  case  (BYTE)''     : if(suspect_italic_ii()){ pen += old_diskr;break; }
		  pen += check_cursiv_inp(rast,c->w,c->h,foot_wid,dest_foot[0],'');
                   break;
  case  (BYTE)''     :
  case  (BYTE)''     : if(suspect_italic_nn()){ pen += old_diskr;break; }
		  pen += check_cursiv_inp(rast,c->w,c->h,foot_wid,dest_foot[0],let);
		    break;
  case  (BYTE)''     :
  case  '4'     :
  case  (BYTE)''     : if(suspect_italic_tche()){ pen += old_diskr;break; }
			pen = check_italic_ch(c->h);
                        break;
  case  (BYTE)''     :
  case  (BYTE)''     : pen = old_diskr + suspect_italic_iee(); /* ??? */
                  break;
  case  (BYTE)''     :
  case  (BYTE)''     : pen = old_diskr;
                  break;
  case (BYTE)''  :
  case (BYTE)''  :
		if(suspect_italic_kk()){ pen += old_diskr;break; }
		pen = check_kk(c->h);
		if( nstick==2 || nstick_broken==2 )
                  pen += check_cursiv_inp(rast,c->w,c->h,foot_wid,dest_foot[0],let);
		  break;

  default        :  pen = 0;
		     break;
                }
return pen;
}

WORD check_III_bend(cell *c,INT dest_foot[])
{
WORD pen=0;
INT w=c->w,h=c->h,i,j,hh=c->h>>1,num;
if( broken_flag )
	return 0;
   stick_online(c);
   if( nstick != 3 && nstick!=4 ) return 80;
   if( nstick==4 )
	{	// ᨢ   ஬ 
	for(i=0;i<3;i++)
		if( h-stick[i].y-stick[i].l>2 || stick[i].incl<400 )
			return 80;	//   稭 ᢥ
	if( stick[3].y>0 )
			return 80;	//   
	}

if( nstick>2 && abs(dest_foot[0]-dest_foot[1])>1  &&
    MAX(dest_foot[0],dest_foot[1])*2>MIN(dest_foot[0],dest_foot[1])*3 )
	pen += 80;

for(num=i=0;i<MIN(3,nstick);i++)
	num += stick[i].incl;
num /= MIN(3,nstick);
w -= (h*num)/2048;
for(num=j=0,i=h-1;i>hh;i--,j++)
	{
	num += (hist_n[i]==2);
	if( hist_d[i]>w-2 )
		{
		if( num>=j-1 )
			pen += 100;
		break;
		}
	}

  return pen;
}

WORD check_III(cell *c,INT wid_foot,INT dest_foot[])
{
INT dy=c->h;
INT i=dy*3/8;
INT h=dy-dy*3/8,s2,ss,d;
WORD pen=0;

stick_online(c);
if( nstick != 3 && !broken_flag) return 60;

for(i=0;i < nstick;i++)
    if( stick[i].l*4 <= c->h*3 ) pen += 40;

if( nstick>2 && abs(dest_foot[0]-dest_foot[1])*3>
        MAX(dest_foot[0],dest_foot[1])*2 )
        pen += 80;

wid_foot = 3*wid_foot + MIN(dest_foot[0],dest_foot[1]);

for(d=s2=ss=0,i=dy*3/8;i < h;i++)
        {
        if (hist_n[i]==3)       s2++;
        else                       ss++;
        if( hist_d[i]>wid_foot )   d++;
        }

  if( ss*2>s2  )   /* 1/8    ᮢ騬 ᫮ ࢠ */
        pen += MIN(120,20*ss);
  if( d>2 )
        pen += 20*d;

  return pen;
}



/*    㣮  */

INT triangle_bottom(BYTE *raster,INT dx, INT dy, INT wid)
{
INT BD_X = (dx+7)>>3;

BYTE *R = &raster[(dy-1)*BD_X];
INT bx = 0, ex = (dx>>1)-1, H = dy / 3;
INT old,new,s,i;
INT good_inc;

for(good_inc=s=old=i=0;i<H && s<4; i++, R-=BD_X)
	{
	new = SumIntervalBits( R, bx, ex);
	if( new>old )
                {
		s++;
                if( new<old+9 )
                        good_inc++;
                }
	else if( new<old )
		return(0);
	old = new;
	}

return(s>3 && (old<wid+2||good_inc>2) );
}

/* ࠢ   㣮  */
INT triangle_top(BYTE *raster,INT dx, INT dy, INT wid)
{
INT BD_X = (dx+7)>>3;
BYTE *R = &raster[0];
INT bx = (dx>>1), ex = dx-1, H = dy / 3;
INT old,new,s,i;
INT good_inc;


for(good_inc=s=old=i=0;i<H && s<4; i++, R+=BD_X)
	{
	new = SumIntervalBits( R, bx, ex);
	if( new>old )
                {
                s++;
                if( new<old+9 )
                        good_inc++;
                }

	else if( new<old )
		return(0);
	old = new;
	}

return(s>3 && (old<wid+2||good_inc>2)  );
}

INT    calc_dest_foot(INT h,INT w,INT *dest_foot,INT wid_foot)
{
INT i,beg=h>>2,end=h-beg,p;
INT n[256],n_max;
if( w>sizeof(n)/sizeof(n[0]) )
  return *dest_foot;
memset(n,0,2*w);
wid_foot *= 3;
for(n_max=hist_white[beg],i=beg;i<end;i++)
	{
	p = hist_white[i];
  if( p>1 && hist_n[i]<3 && hist_d[i]<wid_foot  )
		{
		if( p>n_max )
			n_max=p;
		n[p]++;
		}
	}
if( n_max>=*dest_foot)
	return *dest_foot;
for(p=n_max=0,i=1;i<w;i++)
	if( n[i]>n_max )
		n_max=n[(p=i)];
return n_max>3 ? p : *dest_foot ;
}

BOOL up_ii_config(INT i)
{
if( hist_white[i]==0 )i--;
return( hist_white[i-2]<5 &&
    hist_white[i-1]<hist_white[i-2] &&
		hist_white[i]<hist_white[i-1] );
}
BOOL down_ii_config(INT i)
{
if( hist_white[i]==0 )i++;
return( hist_white[i+2]<5 &&
    hist_white[i+1]<hist_white[i+2] &&
		hist_white[i]<hist_white[i+1] );
}

INT    check_cursiv_inp(BYTE *raster,INT w,INT h,INT foot_wid,INT dest_foot,
			BYTE let)
{
INT i,j,beg=h>>2,end=h-beg;
INT lim ,n_long,n_3,pen=0,p,n_1,n_long_p;
INT up_n_signum=0,down_n_signum=0,dop=h>22?3:2;
INT stair=0,old,new,similar_n=0,similar_i=0,min_dest;
INT lstairs,rstairs,n_empty;
INT up_stair=0;

if( dest_foot==0 )
	return 0;/*   ﭨ 0 */

if( dest_foot<4 )
        dop=0;
if( dest_foot>6 )
        dop++;
if( dest_foot>8 )
	dop++;


lim = foot_wid*2+dest_foot;
if( broken_flag ) lim--;

for(i=0;i<3;i++,beg++)
        if( hist_d[beg]<lim )
                break;  /* skip  top flood lines */

for(i=0;i<3;i++,end--)
	if( hist_d[end]<lim )
                break;  /* skip  bottom flood lines */
for(n_empty=n_long=0,i=beg;i<end;i++)
	{
	if( hist_white[i-1]>dest_foot-2 && hist_white[i]<3 && !up_ii_config(i))
		up_n_signum=1;	/* 孨 ᪠箪 ⭮   */
	if( hist_white[i-2]>dest_foot-2 && hist_white[i-1]==dest_foot-2 &&
	    hist_white[i]<1 && !up_ii_config(i) )
		up_n_signum=1;	/* 孨 ᪠箪 ⭮   */

	if( hist_white[i+1]>dest_foot-2 && hist_white[i]<3 && !down_ii_config(i) )
		down_n_signum=1;/*  ᪠箪 ⭮   */
	if( hist_white[i+2]>dest_foot-2 && hist_white[i+1]==dest_foot-2 &&
	    hist_white[i]<3 && !down_ii_config(i) )
		down_n_signum=1;/*  ᪠箪 ⭮   */

	if( hist_d[i]>lim-3 )
		n_long++;       /* flood lines          */

        if( hist_white[i]>dest_foot-2 )
                n_empty++;
        }

    p = h - h/3;
for(min_dest=dest_foot,n_long_p=n_1=n_3=j=0,i=h/3;i<p;i++,j++)
        {
        if( hist_n[i]>2 )
                n_3++;          /* 3 intervals in line  */
        if( hist_n[i]==1 )
		n_1++;          /* 1 intervals in line  */
	if( hist_white[i]<2 )
	if( hist_d[i]>lim-2 ||  hist_d[i]>lim-3 && hist_n[i]==2 )
		n_long_p++;       /* flood lines          */
        if( hist_white[i]<min_dest )
		min_dest = hist_white[i];

        }
if( n_3>j-3 )
	{
	up_n_signum=down_n_signum=similar_n=0;
  similar_i=3*30;
	goto calc_prob;
	}

stair=similar_n=similar_i=0;
if( up_n_signum==0 || dest_foot-dop<3 )
{
/*  頤 */

p = h/2;
for(i=h/3;i<p;i++)
	{
        if(     hist_white[i-1]>dest_foot-dop &&
                hist_white[i]<dop    &&
                hist_white[i+1]<dop-1 )
                break;
        if(     hist_n[i]>1 &&
                hist_d[i]<=2*foot_wid+dest_foot-dop    &&
                hist_white[i]<=dop )
                break;
        }

if( hist_white[i]>0  && hist_white[i+1]==0 )
        i++;

if( i<p || hist_n[i]==1 && hist_d[i]>2*foot_wid+dest_foot-dop)
        {
        p = MAX(dest_foot-2,3);
	similar_n += (hist_white[i]>p);
        for(lstairs=stair=0,old=hist_white[i],j=1;j<5;j++)
                {
		new = hist_white[i-j];
		if( old )
		{
                if( new>old && (new-old)<4 ||
		    new==old &&
                    hist_white[i-j]+hist_black[i-j]>   /* ᬥ⨫ 砫 */
                    hist_white[i-j+1]+hist_black[i-j+1]) /* ࠢ     */
                        stair++;
                 if( hist_black[i-j]<hist_black[i-j+1] )
			lstairs++;
		}
		if( stair>3 /*&& hist_white[i-4]<3 */)
			{  /*  㯥쪠 */
			similar_n=0;
			if( lstairs<2 )   similar_i+=80;
			break;
			}
		if(j<3)similar_n += (new>p);
		old = new;
		}
        }
if( lstairs>2 && stair==lstairs )
        stair = 0;
}

if( down_n_signum==0 || dest_foot-dop<3 )
{
up_stair=stair;
/*  頤 */
p = h-h/3;
stair=0;
for(i=p;i>=h/2;i--)
        {
        if(     hist_white[i+1]>dest_foot-dop &&
                hist_white[i]<dop &&
                hist_white[i-1]<dop-1   )
                break;
	if(     hist_n[i]>1 &&
                hist_d[i]<=2*foot_wid+dest_foot-dop    &&
                hist_white[i]<=dop )
                break;
        }
if( hist_white[i]>0  && hist_white[i-1]==0 )
        i--;

if( i>=h/2 || hist_n[i]==1 && hist_d[i]>2*foot_wid+dest_foot-dop)
        {
        p = MAX(dest_foot-2,3);
	similar_n += (hist_white[i]>p);

        for(rstairs=stair=0,old=hist_white[i],j=1;j<5;j++)
                {
		new = hist_white[i+j];
		if( old )
		{
		if( new>old && (new-old)<4 ||
		    new==old &&                       /* ᬥ⨫  */
		    hist_black[i+j]>hist_black[i+j-1])/* ࢮ     */
                        stair++;
                 if( hist_black[i+j]+hist_white[i+j]>
                     hist_black[i+j-1]+hist_white[i+j-1] )
                        rstairs++;
		}
                if( stair>3 /*&& hist_white[i]<3*/)
                        {  /*  㯥쪠 */
			similar_n=0;
                        similar_i+=80;
                        break;
			}
		if(j<3)similar_n += (new>p);
		old = new;
		}
	}
if( stair+up_stair>6 ||
    stair+up_stair>4 && rstairs+lstairs<3 ||
    stair==2 && up_stair==2 && rstairs+lstairs<2 )
	{
	similar_n=0;
        similar_i+=80;
        }
stair += up_stair;
}

calc_prob:;
p = triangle_top(raster,w,h,foot_wid) && triangle_bottom(raster,w,h,foot_wid) ;

switch( let )
        {
        case (BYTE)'': case (BYTE)'':
		if( n_long_p>2 )
                        pen += 80;
                if( n_3>3 )
                        pen += 80;
                if( p )
                        pen += 160;     /* similar to  */
                if( dest_foot>4 && min_dest<dest_foot/2 )
                        pen += 40;

                break;

        case (BYTE)'': case (BYTE)'':
		if( n_long==0 )
			pen += 160;
		if( p )
			pen += 160;     /* similar to  */
    if( similar_n<2 )   pen += /*30**/similar_i;
		break;
  case (BYTE)'': case (BYTE)'':
		if( !p )
		{
		if( n_3==0 && n_long==0 )
			pen += 160;
		if( stair<6 && dnri_hook )
			{
			if( up_n_signum   && dest_foot-dop>2 )
				pen += 80;
			if( down_n_signum && dest_foot-dop>2 )
				pen += 80;
			if( down_n_signum && up_n_signum )
				pen += 80;
			}
		if( stair<4 && dnri_hook )
			{
			if( up_n_signum   && dest_foot-dop>1 )
				pen += 80;
			if( down_n_signum && dest_foot-dop>1 )
				pen += 80;
			if( down_n_signum && up_n_signum )
				pen += 80;
			}
		else if( stair<5 )
			{
			if( up_n_signum   && dest_foot-dop>2 && up_stair<2 )
				pen += 80;
			if( down_n_signum && dest_foot-dop>2 && stair-up_stair<2 )
				pen += 80;
			}
		}
		if( similar_n > 2 && n_1!=0 )
			pen += 80 /*30*similar_n*/;
		else if( similar_n && n_1>3 && stair<3 )
			pen += 60;
		break;
  case (BYTE)'' : case (BYTE)'' :
    if( !(stick[0].incl!=stick[1].incl&&uple_hook&&dnri_hook) )
    if( nstick==2 && stick[1].incl || nstick_broken==2   )
      {
      if( up_n_signum   && dest_foot-dop>=2 )
        pen += 80;
      if( down_n_signum && dest_foot-dop>=2 )
        pen += 80;
      if( let==(BYTE)'' )
        pen >>= 1;
      }
      break;
	default : break;
  }

return pen ;
}

INT    check_kk(INT h)
{
INT i,lim,beg=h>>2,end=h-beg,n_3;

if( nstick==1 )
	return 0;
if( uple_hook ) beg = bot_uple_hook;
if( dnri_hook ) end = top_dnri_hook;
lim = h>18 ? 5 :4;

for(n_3=0,i=beg;i<end;i++)
        {
        if( hist_n[i]>2 )
                n_3++;          /* 3 intervals in line  */
        }

return n_3>=lim ? 120 : 0;
}


// End of Oleg zone
WORD check_inc_foots(cell * c,INT nums)
{
INT i,dis=0;

      stick_online(c);
      if( nstick != nums && !broken_flag ) return 40;
   for(i=0;i < nstick;i++)
    if( stick[i].l*4 >= c->h*3 && stick[i].incl  < 200 ) dis += 40;
  return dis;
}

WORD check_num_foots(INT nums,INT dy)
{
INT i=dy/3,dis=0;
INT h=i+dy/3,s2,ss;

for(s2=ss=0;i < h;i++)
        if (hist_n[i]==nums)       s2++;
        else                       ss++;

  if( ss*3>s2  )   /* 1/3    ᮢ騬 ᫮ ࢠ */
        dis = MIN(120,20*ss);

  return dis;
}


// a, cursiv a and o heuristic

WORD check_oa( cell * c,BYTE let,struct rst * const rst)
{
INT r,gaps;
WORD pen_a=0,pen_o=0,futuris=0;

gaps = ((c_comp*)c->env)->nl - ((c_comp*)c->env)->begs - ((c_comp*)c->env)->ends + 1;
if( gaps > 1 ) return 0;

   futuris = check_futuris_aa( rst );
   pen_o  += futuris;

   if( let == (BYTE)'' && (corner_type(corners[0])==SERIF ||
     corner_type(corners[0])==NON_CURVE) ) pen_a += 80;

 if ((r=short_lines2(c))>0)
 {
  if (r==3)   pen_o += 160;
  else                        // not 3 short lines
   if (!(c->cg_flag&c_cg_cutr))
    {
    if( r == 2  ) pen_o += 80;
    else          pen_o += 10; // 1 short line
    }
  }
   if(let == (BYTE)'' && !check_bend_up(c) && !check_bend_dn(c)
      && corner_type(corners[3]) == CURVE  && futuris < 50 )
     pen_a +=  r>0 ? 80 : 90;// 'a' bend
   else
    if(let == (BYTE)'' && !check_bend_up(c) && !check_bend_dn(c) &&
       futuris < 50 ) pen_a += o_symmetric(c->h,c->w);

 return (let == (BYTE)'') ? pen_a : pen_o ;
 }
INT o_symmetric(INT h,INT w)
{
INT  i,asym=0,center_l,center_r;
 if(w%2==0)center_l=center_r=w/2;
 else{ center_l=w/2; center_r=w/2+1; } // exclude center column
 for(i=h*2/3;i < ((h < 16) ? h : h-1) ; i++)
  asym += abs( abs(center_l-l_abris[i]) - abs(r_abris[i]-center_r));
  return (asym < h/5)*40;
}
/////////////////////////////////////////////////////////////////////
void calc_abris(PBYTE pint,INT height )
{
 INT col,i,ndx;
 segment * segm = (segment*)pint;

 memset(l_abris,0x33,sizeof l_abris );
 memset(r_abris,0x33,sizeof r_abris );
 for(i=0,ndx=0,col=0,segm++;i < height;i++,ndx++,col=0)
    {
	 if((i==0 || i == height-1) && !valid_line(segm))
	    {
		 ndx--;
		 continue;
	    }
	 if(segm->segblack)
		 l_abris[ndx] = 0;
	   else
		 l_abris[ndx] = segm->segwhite;
	 while(TRUE)
	   {
	    col+=segm->segblack;
	    if(segm->segwhite != 0x9000 )
	       col+=segm->segwhite;
	     else
		   {
		    segm++;break;
		   }
	    segm++;
	 }
	 r_abris[ndx] = col;
	}
}
////////////////////////////////////////////////////////////////////
BOOL valid_line(segment * segm)
{
WORD vl=0;

do
 if(segm->segblack > 1) vl++;
 while((segm++)->segwhite != 0x9000 );
return (vl > 0);
}

static BYTE futuris[]={ 30,90,140,210 };

WORD check_futuris_aa(struct rst * const rst)
{
INT i,pen=0,h,max_value;
WORD max,index;
BYTE hist[128]={0};
        if( ! abris_online ){ abris_online = TRUE;
	  calc_abris(segment_pool,rst->h);
        }
	/* calc histgramm */
 for(i=0,max_value=0,max=0,index=0;i < rst->h && r_abris[i] != 0x3333;i++){
 hist[r_abris[i]]++;
 if(max < r_abris[i]){ max_value = i; max = r_abris[i]; }
 }
 h=i; // actual size except dummy one dot lines
 /* check hist peak */
  for(i=0,max=0,index=0;i < sizeof(hist)/sizeof(hist[0]);i++)
if( max < hist[i]){ max = hist[i]; index = i; }
  if(hist[index+1] == 1 ) max++;
  if(index && hist[index-1] == 1 ) max++; // add one dot throw

  if(hist[index+1] + hist[index] >= 6*h/7 )
        return 260; // strongly stick kill 'o'


if( max*4 > (h-2)*3 )
 {
 if( h > 18 ) pen = 12; // not round by right abris
 for(i=0;i < h;i++){ // find big jumps
 if( r_abris[i] < index ) continue;
  if(abs(r_abris[i] - r_abris[i-1]) > 2 )
    if(abs(r_abris[i] - r_abris[i-1]) - 2 < sizeof futuris )
	  pen += futuris[abs(r_abris[i] - r_abris[i-1]) - 2 - 1];
 else pen += 260;
 break;
		   }
 }                   // if not round by histo
 else{  // cursiv futuris 'a' or 'o'
  if(max_value*7 < h ){ // 뢠    
        for(i=max_value;i < h-1;i++)
        if(r_abris[i] - r_abris[i+1] < 0 ||
	   r_abris[i] - r_abris[i+1]  > 2) break;
      if( i >= h*6/7){ // ⮭  뢠 !  ᪮쪮 ࠢ୮ ?
	INT tan,lbound = i,sum=0;
  tan =(i-max_value) / (r_abris[max_value]-r_abris[i]) +
       ((i-max_value) % (r_abris[max_value]-r_abris[i]))/((i-max_value)/2);
         for(i=max_value;i < lbound;i++)
      sum += ((i-max_value)/tan) - (r_abris[max_value] - r_abris[i]);
           //if( r_abris[i] - r_abris[i+step] > 1 ) break;
       if( h < 18 )
       { if( sum < 3 ) pen += 80; }// ࠢ୮ -  ᨢ  
       else if( sum < 5 ) pen+=80;
        }
  }
 }
 return pen;
}

BOOL check_bend_up( cell * c )
{
 lnhead *line;
 INT l;
 interval *i;
 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
                        (l=line->lth)>0; line=(lnhead *)((PCHAR)line+l)){
 i=(interval *)((PCHAR)line+sizeof(lnhead));
  if( line->row > c->h/2 && line->h*4 <= c->h && i->e-i->l > 3*c->w/4 &&
      line->flg & l_fbeg )
        return TRUE;
                        }
   return FALSE;
}
BOOL check_bend_dn( cell * c )
{
 lnhead *line;
 INT l;
 interval *i;
 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
                        (l=line->lth)>0; line=(lnhead *)((PCHAR)line+l)){
 i=(interval *)((PCHAR)line+sizeof(lnhead));
  if( line->row > 2*c->h/3 && line->h*4 <= c->h && (i->e-i->l)*2 > c->w &&
      (line->flg & l_fend || line->flg & l_fbeg) && i->l <= c->w/3 &&
      ( (line->h == 1 && i->l > 3 && line->row != c->h-1) ||
        (line->h > 1 && i->l > 1) )
    )
        return TRUE;
                        }
   return FALSE;
}
 INT short_lines2(cell *c)
 {
 lnhead *line;
 interval *intval;
 INT l,row,col,h,w,a;
 BYTE flg;

 for (a=0,line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
		       (l=line->lth)>0; line=(lnhead *)((PCHAR)line+l)    )
  if ((h=line->h)<=2)
   {
   flg=line->flg;
   row=line->row;
   intval=(interval *)((PCHAR)line+sizeof(lnhead));
   if (h==2 && flg&l_fend) {intval++; row++;}
   w=intval->l;
   col=intval->e-w;
   if (3*(c->w)/4<=col+w/2 && w>=c->h/8)
    {
    if (flg&l_fbeg && 4*row<c->h) a|=1;
    if (flg&l_fend && 4*(c->h-row)<c->h) a|=2;
    }
   }
 return a;
 }

/* return dens = black*256/(black+white) */
/*******************************************************internal_filling*/
static WORD internal_filling(segment * segm,INT h,INT w)
{
 DWORD  fill=0;
 LONG start, end, col;
 LONG row,left,right,upper,lower;

 if (h <= 4 || w <= 4) return 0;

 if(w > 12) left=2;
 else       left=1;
 right=w-left;
 upper=1;     lower=h-upper;

 do   {      segm++;       }
      while(segm->segwhite != 0x9000);

for(row=0,end=0,col=0,start=0,segm++;
    row < lower/* h*/;
    row++,col=0,end=0,start=0)
 {
 while(TRUE)
      {
      end = start + segm->segblack;
      if (end > right)
      	end = right;
      if (start < left)
      	start = left;

      if( start < end)
      	fill += end - start;
      if(segm->segwhite != 0x9000)
      	{
	col += segm->segwhite;
	start = col;
	segm++;
	}
      else
      	{
	segm++;
	break;
	}
     }
 }
 row=(h-2) * (w-left*left);
 if ( fill >= 0x1000 ) return (WORD)(fill/(row >> 8));
 if ( fill >= 0x100) return (WORD)((fill<<4)/(row>>4));
 return (WORD)(( ( (WORD)fill ) << 8)/row); // (WORD)
}
/**********************************************end of internal_filling*/

WORD check_veza(cell * c,segment * segm,INT h,INT w,BYTE let)
{
WORD pen_a,pen_e,pen_z,pen_v,pen_ie;
INT gaps=-1,l;
INT i,tresh,smooth,cnt;
lnhead *line;
interval *in;

     pen_a=pen_e=pen_z=pen_v=pen_ie=0;

     if(c)
 gaps = ((c_comp*)c->env)->nl - ((c_comp*)c->env)->begs - ((c_comp*)c->env)->ends + 1;
 if( let == (BYTE)'' && gaps == 1 && c->recsource & c_rs_ev )
        goto ret; // I trust events
    if(!abris_online){  calc_abris((PBYTE)segm,h); abris_online=TRUE;  }
if(!broken_flag){
if(c && let != (BYTE)'' && check_bend_up(c)){ pen_v+=80; pen_z+=80;pen_ie+=80; }
if(c && let != (BYTE)'' && check_bend_dn(c))
 { pen_v+=80; pen_z+=80; pen_ie+=80; }
}
if( c && !check_bend_dn(c) && corner_type(corners[3]) == CURVE) pen_a += 60;

  if( c && dens < THIN && gaps == 2){ pen_a+=50;pen_z+=30;pen_ie+=30; }

 for(i=h/4;i < h*3/4;i++)
 if(l_abris[i]*12 > w*5 && i*2 < h) // big hole from the left
  if( dens > BOLD ){ pen_v += 100; pen_e += 80; }
  else if( dens > THIN ){ pen_v += 40; pen_e +=30; }

  if( let == (BYTE)'' && dens > BOLD && gaps == 2 &&
      corner_type(corners[3]) != CURVE ) pen_e += 40;

  if(corner_type(corners[0]) == NON_CURVE &&   // refuse  -- 
     corner_type(corners[2]) == CURVE   )
     if(dens > BOLD) { pen_e += 60;pen_v += 40; }
     else            { pen_e += 80;pen_v += 80; }

  // h=i; // real height
 tresh = h/10 + h%10/5;  smooth=0;
 /* find  left pad */
       if( let == (BYTE)'' ){
       CHAR jm1,jm2,jm3,jm4,pn;
            jm1=jm2=jm3=jm4=pn=0;
       for(i=h/4+h%4/2,cnt=0;i< h*3/4-1;i++)
        if(l_abris[i+1] - l_abris[i] > 0 )
         if( i + 4 < h*3/4-1 ){
         jm1 = l_abris[i+1] - l_abris[i];
         jm2 = l_abris[i+2] - l_abris[i+1];
         jm3 = l_abris[i+3] - l_abris[i+2];
         jm4 = l_abris[i+4] - l_abris[i+3];
      if( jm1 == 1 && jm2 == 0 ) continue; // one dot throw
      if( jm1 == 2 && (jm2 == 0 && jm3 == 0 && jm4 == 0)) continue; // serif
             if( jm1 == 2 && (jm2 == 0 )) pn = tresh > 1  ? 60 : 80;
             else if( jm1 + jm2 > 3 )   pn = tresh == 2 ? 120 : 50;
         if( pn ) break; // pad found
	if( jm1 == 1 && jm2 == 1 && (jm3 != 0 && jm4 != 0) )
          pn = tresh > 1 ? 60 : 80;
	if( jm1 + jm2 + jm3 == 3 ) pn = tresh == 2 ? 120 : 60;
        }
       pen_v += pn;
       }
 if(let == (BYTE)'' && c && dens > BOLD   && gaps == 2 &&
    corner_type(corners[0]) == CURVE &&
    corner_type(corners[2]) == CURVE
   ){ // refuse  -- blood  with 2 gaps
 for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
                        (l=line->lth)>0; line=(lnhead *)((PCHAR)line+l)){
 in=(interval *)((PCHAR)line+sizeof(lnhead));
  if( !(line->flg & l_fbeg) && !(line->flg & l_fend) &&
     line->row > h/3 )
   for(i=0;i < line->h;i++,in++)
    if(in->l < 2){ pen_v+= 60; break; }
                        }
   }

for(i=h/5+1,cnt=0;i< 2*h/3;i++)
 if(l_abris[i] - l_abris[i-1] > 2 ) cnt++;
  if(cnt > 0) pen_e += cnt*40;
ret:
 // get out result
    switch(let){
    case (BYTE)''  : return pen_a;
    case (BYTE)''  : return pen_v;
    case (BYTE)''  : return pen_z;
    case (BYTE)''  :
			   //    . 08.09.2000 E.P.
	   if (language==LANG_RUSSIAN && langBul)
			return 200;

		return pen_ie;

    case (BYTE)''  : return pen_e;
     default 	: return 0;
    }
}

static WORD check_ee( cell * c)
{
INT    i, num;

for(num=0,i=0;i<c->h; i++)
  num +=(hist_n[i]==2);

return( (num>(c->h*3)/4)?100:0 );
}



WORD check_nn(cell * c)
{
INT gaps=-1,pen=0;

 if(c) gaps = ((c_comp*)c->env)->nl - ((c_comp*)c->env)->begs - ((c_comp*)c->env)->ends + 1;

 if( (corner_type(corners[0]) == CURVE || corner_type(corners[1]) == CURVE) &&
      gaps == 2) pen+=40;
 if( (corner_type(corners[2]) == CURVE || corner_type(corners[3]) == CURVE) &&
      gaps == 2) pen+=40;
 return pen;
}

/*============== Sources level 2 ========================*/


static BOOL valid_inc( WORD inc )
{
INT ret=0;
 if( inc == 0 || inc > 800) ret = 0;
 else if( inc == 200 ) ret = 1;
      else             ret = 2;
return ret;
}

extern INT nIncline;

INT sym_italic( cell * c ,BYTE let)
{
INT i,cs=0;
   if( ! let_stick[let] ) return FALSE;
   stick_online(c);
  for(i=0;i < nstick;i++)
    if( stick[i].l*5 >= c->h*4 )
     cs += valid_inc( stick[i].incl);
if( broken_flag && cs==0 )
	cs = broken_sym_italic(&glc, let);
   return (cs > 0);
}
// Init Global variables
void _init_(void)
{
nstick = 0; dens=0; abris_online=0;
stick = NULL;nstickLP=0;stickLP=NULL;
}

BOOL stick_online(cell * c)
{
STICK * s;
if( stick || !c)
    return FALSE;
if( c->n_baton==NO_BATONS )
 {
 nstick = sticks_in_letter(c,0,&s);
 if( nstick > 0 )
  {
  memcpy(stic,s,nstick*sizeof(STICK));
  stick = stic;
  if( nstick>0 && nstick<4 )
    {
    c->n_baton = (BYTE)nstick;
    memcpy(c->save_baton,s,nstick*sizeof(STICK));
    }
  else if( nstick==0 )
    c->n_baton = c->n_baton=NO_BATONS;;
  }
   }
  else
    {
    nstick = c->n_baton;
    if( nstick>0 )
      {
      memcpy(stic,c->save_baton,nstick*sizeof(STICK));
      stick = stic;
      }
    }

return stick != NULL;
}

segment * go_line(segment * seg_pool,WORD ln)
{
INT i;
for(i=0,seg_pool++;i < ln;i++) // skip lines
while((seg_pool++)->segwhite != 0x9000);
return seg_pool;
}
/* ------------ Discrimination for russian letters ------------------*/


#define DB_TEXT_ROW 16          // first row for text window
#define DB_TEXT_COL 1		// first column in text window
#define DB_TIF_ROW 3            // first row for tif window
#define DB_TIF_COL 2            // first column in tif window
#define DB_TIF_H 13             // height of tif window
#define DB_TIF_W 40             // width of tif window
void add_raster(PBYTE target,INT wb,INT row,INT col,PBYTE source,INT h,INT w);

struct rst create_raster(cell * c, const s_glue * gl)
{
c_comp * cp;
INT i,right,bottom,left,upper,wb;
struct rst _rst={0};
PBYTE rast;
    if(gl != NULL){
    left=upper=30000U; right=bottom=0; i=0;
    while((cp = gl->complist[i++]) != NULL){
    left  = MIN(left  ,cp->left);
    upper = MIN(upper ,cp->upper);
    right = MAX(right ,cp->left  + cp->w);
    bottom= MAX(bottom,cp->upper + cp->h);
                                            }
    i=0;
    _rst.h = bottom - upper;
    _rst.w = right - left;
    _rst.u = upper;
    wb = (right - left + 7)/8;
    memset(work_raster_1,0,wb*_rst.h);
    while((cp = gl->complist[i++]) != NULL){
    online_comp(cp);
    rast = make_raster();
    c_add_raster(work_raster_1,wb,(INT)(cp->upper - upper),(INT)(cp->left - left),
               rast,cp->h,(INT)((cp->w+7)/8));
    }
     if(db_status && snap_activity(db_pass)){
     snap_show_raster(work_raster_1,_rst.h,_rst.w);
                                  }
   _rst.raster = work_raster_1;
   return _rst;
    }
if(c && !(c->cg_flag & c_cg_noenv)){
     memset(work_raster,0,((c->w+7)/8)*c->h);
     _rst.raster = save_raster(c);
     _rst.h = c->h;
     _rst.w = c->w; // for Diskrim
     _rst.u = c->row;
     if(db_status && snap_activity(db_pass)){
     snap_show_raster(_rst.raster,c->h,c->w);
       }
     return _rst;
                              }
return _rst;
}

#define copy_byte       *t++=0xff

void c_add_raster(PBYTE target,INT wb,INT y,INT col,PBYTE source,INT sh,INT swb)
{
BYTE m0,m1;
PBYTE t;
PBYTE s=source;
INT i;
         if( wb < swb ) return; // wider that target raster
        t=target+wb*y+col/8;   // offset in target raster
        col%=8;
	while(sh--){
 for(i=0;i<swb;i++)
 {
 m0=*s>>col; m1=*s<<(8-col); s++;
 *t++ |= m0; *t |= m1;
 }
         t+=wb-swb;
        }
}


/******************************************************************/
/********** 㭪樨  ਬ樨  ⮣ࠬ *************/
/******************************************************************/

/* multicell_hist : ᫨ ⮣ࠬ ᫠ */
/* 	ࢠ  窠   祪	*/
/* base_c + GL - multicell 			*/
/* hist_n - number of intervals in row 		*/
/* hist_d - number of bits      in row 		*/
/* 	return height of multicell		*/
/*						*/
INT multicell_hist(cell *base_c, const s_glue *GL,INT hist_n[], INT hist_d[])
{
cell *c;
INT i,minrow,maxrow,ncells=0,dy;

if( base_c==NULL && GL==NULL )
	return 0;

if( GL==NULL )
	{	/* base cell information	*/
	dy = base_c->h;
	memset(hist_n, 0, dy<<1 );
	memset(hist_d, 0, dy<<1 );
	add_cell_to_hist(base_c,0,hist_n,hist_d);
	return dy;
	}

/* GL != NULL */
c=GL->celist[ncells++];       /* first cell */
minrow=c->row;
maxrow=c->row+c->h;

while ((c=GL->celist[ncells++]) != NULL)
	{
	if (c->env == NULL)
		continue;       /* no env */

	if (minrow > c->row) minrow=c->row;
	if (maxrow < (c->row+c->h)) maxrow=c->row+c->h;
	}
ncells--;

dy = maxrow-minrow;
memset(hist_n, 0, dy<<1 );
memset(hist_d, 0, dy<<1 );

for(i=0;i<ncells;i++)
	{
	if( (c=GL->celist[i])->env==NULL )
		continue;              /* no enviroment   */
	add_cell_to_hist(c,(INT)(c->row-minrow),hist_n,hist_d);
	}

return dy;
}

/* add_cell_to_hist :  ⮣ࠬ  ࢠ ⪨	*/
/* 	off_str - ᬥ饭 ⪨  			*/
void add_cell_to_hist(cell *c,INT off_str,INT hist_n[],INT hist_d[])
{
 INT ll,ind,h;
 lnhead   *line;
 interval *inter;

for (line=(lnhead *)((PCHAR)(c->env)+c->env->lines+sizeof(INT));
		(ll=line->lth)>0; line=(lnhead *)((PCHAR)line+ll))
	{
	h=line->h;
	for( ind=off_str+line->row,
	     inter=(interval *)((PCHAR)line+sizeof(lnhead));
	     h ;ind++,h--,inter++)     		/* one line     */
		{
		hist_d[ind] += inter->l;/* number of bits      in row */
		hist_n[ind] ++;		/* number of intervals in row */
		}
	}

return;
}
/***************************************** start make_white_hist */
void make_white_hist(PBYTE pint,INT height)
{
 segment * segm;
 LONG i;                                                 //change from INT

 memset(hist_white,0,height<<1);
 for(i=0,segm = (segment*)pint,segm++;i < height;i++)
   {
    if( segm->segblack==0 )
      hist_white[i] = (segm+1)->segwhite!=0x9000?(segm+1)->segwhite:0;
     else
      hist_white[i] = segm->segwhite!=0x9000?segm->segwhite:0;

    if( segm->segblack==0 )
      hist_black[i] = segm->segwhite + (segm+1)->segblack;
     else
      hist_black[i] = segm->segblack;

    while((segm++)->segwhite != 0x9000);
   }
 return ;
}
/**************************************** end of make_white_hist */

// Miscellaneous
WORD stick_bI(cell * cl)
{
cell *  c, sc;
INT     dist;

c = cl->prevl;
if( c )
    dist = cl->col - (c->col + c->w);
else
    goto kill; // stick first in line

if( memchr("윚",c->vers[0].let,4) &&
    c->vers[0].prob > 12 && dist < c->w )
    return 0;
else
goto kill;
kill:
sc = *cl;
stick_center_study(&sc,&glc,1);
if( !(cl->pos_inc&erect_rot) )
    cl->stick_inc = sc.stick_inc;
return 254; // penalize deadly
}

// similar to true stick '|' or not
BOOL    test_I(cell *c)
{
cell    sc;
if( c->nvers<1 || c->vers[0].let!='1' )
    return FALSE;
sc=*c;
sc.nvers=1;
sc.vers[0].let='|';
sc.vers[0].prob=254;
stick_center_study(&sc,&glc,1);
return (sc.vers[0].prob>220);
}

void proc_bI(INT pass)
{
cell * c,*clist[8];
BYTE let;

c = cell_f();
while((c=c->nextl) != NULL )
     {
     if( !(c->flg & (c_f_let+c_f_bad)) )
        continue;
     if(!c->nextl || !(c->nextl->flg & (c_f_let+c_f_bad)) )
        continue;
     let = c->vers[0].let;
     if( memchr("",let,3) && c->nextl->vers[0].let == '|' )
     //(c->nextl->vers[0].let == '|' || p2_active && c->nextl->vers[0].let=='1' && test_I(c->nextl)) )
        {
        if(pass == 0 && !(c->nextl->cg_flag & c_cg_cut))
            continue;
        if(
			langBul || //    ! // 08.09.2000 E.P.

			// heights very different
			abs(c->h - c->nextl->h) > 3 ||
            abs(c->row - c->nextl->row) > 3
		  )
            {
            c->nextl->vers[0].prob = 20; // pen '|' deadly
            sort_vers(c->nextl);
            continue;
            }
        clist[0]=c;
        clist[1]=c->nextl;
        compose_cell(2,clist,c);
        let = is_lower(let) ? (BYTE)'' : (BYTE)'';
        c->vers[0].let = let;
	    c->recsource = 0; // artifact
	    c->dens = 255; // undef
	    c->nvers=1;c->vers[1].let=c->vers[1].prob=0;
        }
     } // while by letters
return;
}

WORD check_I_dot(cell * c,BYTE let)
{
 switch( let ){ // !,1,! with dot :  can't be pasted
 case '1'       : return (c->cg_flag & c_cg_cut) ? 80  : 0;
 case '!'       : return (c->cg_flag & c_cg_cut) ? 120 : 0;

 // 31.08.2000 E.P.
 case liga_exm_usual  :
	 if (liga_exm_usual == liga_exm)
		return (c->cg_flag & c_cg_cut) ? 80 : 0;
	 break;

 case liga_exm_latin  :
	 if (liga_exm_latin == liga_exm)
		return (c->cg_flag & c_cg_cut) ? 80 : 0;
	 break;

 case '>'       : return (c->cg_flag & c_cg_cutr) ? 80 : 0;
 case '<'       : return (c->cg_flag & c_cg_cutl) ? 80 : 0;
 }
return 0;
}

//  Dust study section (Oleg zone)

/* dust_in_glue :     ⬥祭  ?			*/
/*	s -  ⪠ ᪫ GL; [(c1,r1),(c2,r2)] - 	*/
/*	c1,c2,r1,r2 - न ७ אַ㣮쭨		*/
/*		ࠦ  業 ( ࠧ஢ 窨)		*/
BOOL dust_in_glue( cell *s, s_glue *GL,INT c1,INT r1,INT c2, INT r2)
{
cell *c,*ss=NULL;
INT ncells,maxrow,minrow,maxcol,mincol,h,w;

if( GL==NULL && s==NULL )	return FALSE;

if( GL )
{
ncells=0;
maxrow=0; minrow=10000;
maxcol=0; mincol=10000;
while ((c=GL->celist[ncells++]) != NULL)
	{
	if( c->env==NULL ) continue;
	if (minrow > c->row) minrow=c->row;
	if (maxrow < (c->row+c->h)) maxrow=c->row+c->h;
	if (mincol > c->col) mincol=c->col;
	if (maxcol < (c->col+c->w)) maxcol=c->col+c->w;
  if( ss==NULL && (c->flg&(c_f_bad|c_f_let)) )  ss=c;
	}
}
else if( s )
	{
	mincol = s->col;
	maxcol = s->col + s->w;
	minrow = s->row;
	maxrow = s->row + s->h;
  ss=s;
	}

h = maxrow-minrow;
w = maxcol-mincol;
maxcol = mincol + (w*c2)/100+1;
mincol = mincol + (w*c1)/100-1;
maxrow = minrow + (h*r2)/100+1;
minrow = minrow + (h*r1)/100-1;

if( GL )
{	//	饬 ⥫   ᫠ ᪮ ᪫
ncells=0;
while ((c=GL->celist[ncells++]) != NULL)
	{
	if( c->env==NULL || !(c->flg&c_f_dust) ) continue;
	if ( 	c->row>=minrow		&&
		c->row+c->h<=maxrow 	&&
		c->col>=mincol 		&&
		c->col+c->w<=maxcol    )
		return TRUE;
	}
}

if( ss )
{	//	饬 ⥫   ᫠ 㦠 ⮢
cell  *e=ss->nextl,*b=ss->prevl;
if( (e->flg&c_f_bad) && e->col>=maxcol )
  e=e->next;
if( (b->flg&c_f_bad) && b->col+b->w<=maxcol )
  b=b->next;
for( c=ss->next;(c->flg & c_f_dust)&&c!=e; c=c->next)  // left comps
	if( 	c->row>=minrow 		&&
		c->row+c->h<=maxrow 	&&
		c->col>=mincol 		&&
		c->col+c->w<=maxcol 	)
		return TRUE;
for( c=ss->prev;(c->flg&(c_f_dust|c_f_bad))&&c!=b; c=c->prev)  // right comps
	if( 	c->row>=minrow 		&&
		c->row+c->h<=maxrow 	&&
		c->col>=mincol 		&&
		c->col+c->w<=maxcol 	)
		return TRUE;
}

return FALSE;
}

BOOL dust_near_rusG(cell *cc)
{
cell *c;
INT dw,dh;

if( cc==NULL )	return FALSE;
c = cc->prev;
if( !(c->flg & c_f_dust) )	return FALSE;
      stick_online(cc);
      if( nstick != 1 ) return 40;

dw = abs( (cc->col-c->col+stick[0].x)-(cc->w-stick[0].x) );
dh = abs( cc->row - c->row);

return ( dw<2 && dh<2 && c->h<(cc->h+2)/3) ;
}



//  Final Rus_Eng decsriminators (Oleg zone)

void final_descriminate(cell *b, cell *e)
{
cell *c;
for(c=b;c!=e;c=c->next)
  if( c->nvers>0 )
    RE_final_descr(c);
return ;
}

INT RE_rus_Ge(INT hist[], INT histd[], INT hei, INT wid)
{
INT i,num;

wid = (wid >> 1)+(wid >> 2);
for(num=i=0;i<hei;i++)
  {
  if( hist[i]==1 && histd[i]>wid )
    {
    if( num )      break;
    // num=0; i - first one-interval line
    for(;i<hei;i++)
      {
      if( hist[i]!=1 && histd[i]<wid )
        break;
      num++;
      }
    return -num;
    }
  num += (hist[i]>=2);
  }

return num;
}

BOOL similar_S( INT hist_n[],INT hist_d[], INT w,INT h)
{
INT i,ii,p,pp;
for(ii=h-1,p=pp=i=0;i<3;i++,ii--)
  {
  p  += (hist_n[i]==1  && hist_d[i]>w);
  pp += (hist_n[ii]==1 && hist_d[ii]>w);
  }

return( p==3 && pp==3 );
}

BOOL similar_R( INT hist_n[], INT h)
{
INT i,ii,p;
for(ii=h-1,p=i=0;i<h/2;i++,ii--)
  p  += (hist_n[i]==2);

return( p>h/5 );
}

void RE_final_descr(cell *c)
{
INT F;
struct rst _rst;

if( !memchr(Rus_similar_Eng,c->vers[0].let,sizeof(Rus_similar_Eng)) ||
    !c->env )
  return;

multicell_hist(c,NULL,hist_n, hist_d);

switch( c->vers[0].let )
  {
  case (BYTE)'' :
            if( c->nvers==1 && c->vers[0].prob==254
                && similar_R( hist_n, c->h) )
                down_all_versions(c, 40);
             break;
  case (BYTE)'' : case (BYTE)'' :
             if( c->nvers==1 && c->vers[0].prob==254 )
                r_criteria(c,NULL);
             break;
  case (BYTE)'$' :
             if( c->h>15 && similar_S( hist_n, hist_d, (INT)(c->w/4), c->h) )
                down_all_versions(c, 40);
             break;

  case (BYTE)'' :
  case (BYTE)'' :
             if( (F=RE_rus_Ge(hist_n, hist_d,(INT)(c->h<30?4:6),c->w))>0 )
                down_all_versions(c, (INT)(2 + F*20));
             break;
  case (BYTE)'n' :
  case (BYTE)'r' :
             if( (F=RE_rus_Ge(hist_n, hist_d,(INT)(c->h<30?4:6),c->w))<0 )
                down_all_versions(c, (INT)(2-F*20));
             break;
  case (BYTE)'N':
             _rst = create_raster(c,NULL);
             if(_rst.raster )
                {
                INT pen =
             Diskrim((BYTE)'N',_rst.raster,_rst.w,0,0,_rst.w,_rst.h,c->cg_flag,
                   (INT)(c->save_stick_inc!=NO_INCLINE?c->save_stick_inc:0));
             if(  pen )
                down_all_versions(c, (INT)(pen));
                }
             break;
  default :  break;
  }

return;
}



