<?xml version='1.0'?><!-- -*-SGML-*- -->
<!--
This file  is part of  DocBookWiki.  DocBookWiki is a  web application
that  displays  and  edits  DocBook  documents.  

Copyright (C) 2004, 2005 Dashamir Hoxha, dashohoxha@users.sf.net

DocBookWiki is free software; you can redistribute it and/or modify it
under the terms of the GNU  General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

DocBookWiki is  distributed in  the hope that  it will be  useful, but
WITHOUT   ANY  WARRANTY;   without  even   the  implied   warranty  of
MERCHANTABILITY  or FITNESS  FOR A  PARTICULAR PURPOSE.   See  the GNU
General Public License for more details.

You  should have received  a copy  of the  GNU General  Public License
along with DocBookWiki; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
-->

<!-- Used to convert content.xml to text, in text editing mode. -->

<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version='1.0'>

<xsl:output method="xml" version="1.0" encoding="utf-8" 
            omit-xml-declaration="yes" standalone="yes" indent="yes" />

<xsl:include href="xml2text/info.xsl" />
<xsl:include href="xml2text/block.xsl" />
<xsl:include href="xml2text/list.xsl" />
<xsl:include href="xml2text/inline.xsl" />
<xsl:include href="xml2text/menuchoice.xsl" />

<!-- skip the section elements -->
<xsl:template match="book | article | bookinfo | articleinfo | preface
                    | appendix | chapter | section | simplesect">
  <xsl:apply-templates />
</xsl:template>

<!-- skip the titles -->
<xsl:template match="title" />

<xsl:template match="para" xml:space="preserve">
<xsl:apply-templates />
</xsl:template>

<!-- normalize text, but not for screen or programlisting or literallayout -->
<xsl:template match="text()">
  <xsl:value-of select="normalize-space(.)" />
</xsl:template>
<xsl:template match="screen/text() | programlisting/text()
                    | literallayout/text()">
  <xsl:value-of select="." />
</xsl:template>

<!-- copy the rest of elements (and their attributes) unchanged -->
<xsl:template match="*|@*">
  <xsl:copy>
    <xsl:apply-templates select="@*"/>
    <xsl:apply-templates select="node()"/>
  </xsl:copy>
</xsl:template>

</xsl:transform>
