/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DeleteInternetGateway
extends BaseCmd {
    public DeleteInternetGateway(String[] args) {
        super("ec2deligw", "ec2-delete-internet-gateway");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        return new Options();
    }

    public String getOptionString() {
        return "INTERNET_GATEWAY";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Delete an existing Internet Gateway.");
        System.out.println("     INTERNET_GATEWAY is the ID of internet gateway that you wish to delete.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("INTERNET_GATEWAY");
        this.warnIfTooManyNonOptions();
        String gatewayId = this.getNonOptions()[0];
        RequestResultPair result = jec2.deleteInternetGateway(gatewayId);
        out.output(System.out, (Boolean)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new DeleteInternetGateway(args).invoke();
    }
}

