/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.DhcpOptionsDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeDhcpOptions
extends BaseCmd {
    public DescribeDhcpOptions(String[] args) {
        super("ec2ddopt", "ec2-describe-dhcp-options");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "[ DHCP_OPTIONS ... ]";
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)this.joinDescription("Add a filter criterion for the result-set."));
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Gives you information about one or more sets of DHCP options. The");
        System.out.println("     DHCP_OPTIONS parameters, if specified, are the IDs of the DHCP options");
        System.out.println("     to describe.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp = jec2.describeDhcpOptions(this.getFilters(true), this.getNonOptions());
        for (DhcpOptionsDescription dhcpOptions : (List)rsp.getResponse()) {
            out.output(System.out, dhcpOptions);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeDhcpOptions(args).invoke();
    }
}

