/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeLicensesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeLicensesRequestMarshaller
implements Marshaller<Request<DescribeLicensesRequest>, DescribeLicensesRequest> {
    public Request<DescribeLicensesRequest> marshall(DescribeLicensesRequest describeLicensesRequest) {
        if (describeLicensesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeLicensesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeLicenses");
        request.addParameter("Version", "2012-07-20");
        List<String> licenseIdsList = describeLicensesRequest.getLicenseIds();
        int licenseIdsListIndex = 1;
        for (String licenseIdsListValue : licenseIdsList) {
            if (licenseIdsListValue != null) {
                request.addParameter("LicenseId." + licenseIdsListIndex, StringUtils.fromString((String)licenseIdsListValue));
            }
            ++licenseIdsListIndex;
        }
        List<Filter> filtersList = describeLicensesRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        return request;
    }
}

