/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.NetworkInterfaceAttachmentDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DetachNetworkInterface
extends BaseCmd {
    private String attachmentId;
    private static final String[] FORCE_DESC = new String[]{"Forcefully disconnect NETWORKATTACHMENT from INSTANCE."};

    public DetachNetworkInterface(String[] args) {
        super("ec2detnic", "ec2-detach-network-interface");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    protected String getOptionString() {
        return "NETWORKATTACHMENT [-f]";
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(DetachNetworkInterface.createOption("f", "force", FORCE_DESC));
        return result;
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Detaches a network interface from an instance. The NETWORKATTACHMENT");
        System.out.println("     parameter is the ID of the attachment.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("force");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        RequestResultPair rsp = jec2.detachNetworkInterface(this.attachmentId, this.isOptionSet("force"));
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.output(System.out, new NetworkInterfaceAttachmentDescription(null, this.attachmentId, "detaching", null));
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertNonOptionSet("NICATTACHMENTS");
        this.attachmentId = this.getNonOptions()[0];
        this.warnIfTooManyNonOptions();
    }

    public static void main(String[] args) {
        new DetachNetworkInterface(args).invoke();
    }
}

