/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.BlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.EbsSnapshotDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Options;

public class RegisterImage
extends BaseCmd {
    private static final String[] SNAPSHOT_DESC = new String[]{"The ID of the Amazon EBS snapshot to be used as the root device."};
    private static final String[] NAME_DESC = new String[]{"The name of the image, which must be between 3 and 128 characters", "long, and may contain letters, numbers and the following special", "characters: ( ) . - / _"};
    private static final String[] DESCRIPTION_DESC = new String[]{"The description of the image."};
    private static final String[] ARCHITECTURE_DESC = new String[]{"The architecture of the image; either 'i386' or 'x86_64'. If not", "specified, 'i386' will be used."};
    private static final String[] KERNEL_DESC = new String[]{"The ID of the kernel associated with the image."};
    private static final String[] RAMDISK_DESC = new String[]{"The ID of the ramdisk associated with the image."};
    private static final String[] ROOT_DEVICE_DESC = new String[]{"The name of the root device, e.g. '/dev/sda1'."};
    private static final String DEFAULT_ROOT_DEVICE_NAME = "/dev/sda1";
    protected String imageLocation;

    public RegisterImage(String[] args) {
        super("ec2reg", "ec2-register");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(RegisterImage.createOptionWithArgs("a", "architecture", ARCHITECTURE_DESC, "ARCHITECTURE"));
        result.addOption(RegisterImage.createOptionWithArgs("b", "block-device-mapping", BLOCK_DEVICE_MAPPING_DESC, "MAPPING"));
        result.addOption(RegisterImage.createOptionWithArgs("d", "description", DESCRIPTION_DESC, "DESCRIPTION"));
        result.addOption(RegisterImage.createOptionWithArgs("n", "name", NAME_DESC, "NAME"));
        result.addOption(RegisterImage.createOptionWithArgs("s", "snapshot", SNAPSHOT_DESC, "SNAPSHOT"));
        result.addOption(RegisterImage.createOptionWithArgs(null, "kernel", KERNEL_DESC, "KERNEL"));
        result.addOption(RegisterImage.createOptionWithArgs(null, "ramdisk", RAMDISK_DESC, "RAMDISK"));
        result.addOption(RegisterImage.createOptionWithArgs(null, "root-device-name", ROOT_DEVICE_DESC, "ROOTDEVICENAME"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "[MANIFEST] [SPECIFIC OPTIONS]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Register an Amazon Machine Image (AMI) for use within Amazon EC2.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("architecture");
        this.printOption("block-device-mapping");
        this.printOption("description");
        this.printOption("name");
        this.printOption("snapshot");
        this.printOption("kernel");
        this.printOption("ramdisk");
        this.printOption("root-device-name");
    }

    protected void validateParameters() {
        this.warnIfTooManyNonOptions();
        if (this.imageLocation == null || "".equals(this.imageLocation)) {
            this.assertOptionSet("name");
        }
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String snapshotId;
        this.imageLocation = this.getNonOptions().length > 0 ? this.getNonOptions()[0] : null;
        this.validateParameters();
        List<BlockDeviceMappingDescription> blockDeviceMapping = this.getBlockDeviceMapping(this.getOptionValues("block-device-mapping"));
        String rootDeviceName = this.getOptionValue("root-device-name");
        if (rootDeviceName == null) {
            rootDeviceName = DEFAULT_ROOT_DEVICE_NAME;
        }
        if ((snapshotId = this.getOptionValue("snapshot")) != null && blockDeviceMapping != null) {
            for (BlockDeviceMappingDescription mapping : blockDeviceMapping) {
                if (!mapping.getDeviceName().equalsIgnoreCase(rootDeviceName)) continue;
                throw new InvalidArgumentCombination("You may not specify both a 'snapshot' and 'block-device-mapping' for the root device: '" + rootDeviceName + "'.");
            }
        }
        if (snapshotId != null) {
            blockDeviceMapping.add(new BlockDeviceMappingDescription(rootDeviceName, BlockDeviceMappingDescription.Type.EBS, new EbsSnapshotDescription(snapshotId, null, null)));
        }
        if (this.imageLocation == null && (blockDeviceMapping == null || blockDeviceMapping.isEmpty())) {
            throw new InvalidArgumentCombination("Neither a 'manifest' or 'block-device-mapping' have been specified; at least one is required.");
        }
        RequestResultPair rsp = jec2.registerImage(this.imageLocation, this.getOptionValue("name"), this.getOptionValue("description"), this.getOptionValue("architecture"), this.getOptionValue("kernel"), this.getOptionValue("ramdisk"), rootDeviceName, blockDeviceMapping);
        out.outputImageId(System.out, (String)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    private List<BlockDeviceMappingDescription> getBlockDeviceMapping(String[] blockDeviceOptions) {
        ArrayList<BlockDeviceMappingDescription> blockDevices = new ArrayList<BlockDeviceMappingDescription>();
        if (blockDeviceOptions == null || blockDeviceOptions.length == 0) {
            return blockDevices;
        }
        for (String blockDeviceOption : blockDeviceOptions) {
            try {
                blockDevices.add(BlockDeviceMappingDescription.valueOf((String)blockDeviceOption));
            }
            catch (Exception e) {
                throw new InvalidArgument("block-device-mapping", blockDeviceOption);
            }
        }
        return blockDevices;
    }

    public static void main(String[] args) {
        new RegisterImage(args).invoke();
    }
}

