/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.GroupAddPolicyRequest;
import com.amazonaws.services.auth.identity.cli.policy.PolicyBuilder;
import com.amazonaws.services.awsidentitymanagementv20100508.model.PutGroupPolicyRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMGroupAddPolicyDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMGroupAddPolicyDriver.class);

    public void invokeRequestImpl(CLIRequest request) {
        if (request instanceof GroupAddPolicyRequest) {
            GroupAddPolicyRequest req = (GroupAddPolicyRequest)request;
            String doc = null;
            try {
                LOG.debug((Object)("Generating policy doc from request " + request));
                doc = PolicyBuilder.buildPolicy(req.getEffect(), req.getActions(), req.getResources());
            }
            catch (Exception e) {
                Utils.exit(1, "Error generating policy document from parameters. " + e.getMessage(), e);
            }
            PutGroupPolicyRequest policyRequest = new PutGroupPolicyRequest();
            policyRequest.setPolicyDocument(doc);
            policyRequest.setGroupName(req.getGroupName());
            policyRequest.setPolicyName(req.getPolicyName());
            LOG.debug((Object)("Calling putpolicy with request " + request + " and policy document: "));
            LOG.debug((Object)doc);
            this.getClient().putGroupPolicy(policyRequest);
            if (req.isVerbose()) {
                LOG.info((Object)doc);
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

