/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.security;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.security.IAWSCredentialsProvider;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicAWSCredentialsProvider
implements IAWSCredentialsProvider {
    private static final Log LOG = LogFactory.getLog(BasicAWSCredentialsProvider.class);
    private static final String AWS_ACCESS_KEY = "AWSAccessKeyId";
    private static final String AWS_SECRET_KEY = "AWSSecretKey";

    public AWSCredentials getCredentials() {
        return this.getCredentials(System.getenv("AWS_CREDENTIAL_FILE"));
    }

    public AWSCredentials getCredentials(String filepath) {
        String accessKey = null;
        String secretKey = null;
        try {
            BufferedReader file = new BufferedReader(new FileReader(filepath));
            Properties properties = new Properties();
            properties.load(file);
            accessKey = properties.getProperty(AWS_ACCESS_KEY);
            secretKey = properties.getProperty(AWS_SECRET_KEY);
            if (accessKey == null || secretKey == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load AWS Credential file. Make sure that the environment variable AWS_CREDENTIAL_FILE or command line argument --aws-credential-file is set to a file containing AWS Credentials in the following format. Enter the AWS keys without the < or >");
            LOG.error((Object)"AWSAccessKeyId=<Write your AWS access key ID>");
            LOG.error((Object)"AWSSecretKey=<Write your AWS secret key>");
            Utils.exit(1, null, e);
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }
}

