#!/bin/sh

#gnugeo _at_ gnugeo _dot_ de

# i use this script to build the distribution-packages
# from the sourcecode

#precondition:
# 
# the property-files have to be updated and ok
# the paths of the variables have to be ok

#usage
#
# ./mkJFLJar.sh <version>
# example : ./mkJFLJar.sh 837

JAVAV=java-1.6.0_16
JAVAC=/usr/local/bin/jdk1.6.0_16/bin/javac
JAVA=/usr/local/bin/jdk1.6.0_16/bin/java
JAR=/usr/local/bin/jdk1.6.0_16/bin/jar

DESTINATIONDIR=jfractionlab

VERSION="0"
ROOT=`pwd`

setVersionNB(){

	# make some changes in the code
		cd src/jfractionlab/
		#set Version Number
		OLD_VN=`grep JFractionLab_version-number_lab JFractionLab.java`
		NEW_VN="setTitle(\"JFractionLab_"$VERSION"\");"
		sed s/"$OLD_VN"/"$NEW_VN"/g JFractionLab.java > jfl.p
		mv jfl.p JFractionLab.java
		cd "$ROOT"
}

compile(){
	export CLASSPATH="$CLASSPATH":.:`pwd`/libs/*:`pwd`/bin/*:`pwd`/src/*
		cd src/
		"$JAVAC" -client jfractionlab/JFractionLab.java
		"$JAVAC" -client lang/Messages.java
		cd "$ROOT"
}


build(){
	# clean up a little bit
		rm src/jfractionlab/*java
		rm src/jfractionlab/*/*java
		mv src/jfractionlab bin
		rm src/lang/*java
		mv src/lang/ bin
		#make help
			cd doc/help_de
			"$JAR" cf Help_de.jar *
			cp Help_de.jar ../../libs
			cd ../..
		#help is done
		#make english help
			cd doc/help_en
			"$JAR" cf Help_en.jar *
			cp Help_en.jar ../../libs
			cd ../..
		#english help is done
		#make spanish help
			cd doc/help_es
			"$JAR" cf Help_es.jar *
			cp Help_es.jar ../../libs
			cd ../..
		#spanish help is done
		#make french help
			cd doc/help_fr
			"$JAR" cf Help_fr.jar *
			cp Help_fr.jar ../../libs
			cd ../..
		#french help is done
		rm bin/lang/jflTextResource.txt
		rm -rf src doc
		mv libs/*jar bin
		rm -rf libs
		cp -a icons bin
		cd bin
		
	# make a jar-file
		#create the manifest
		echo "Main-Class: jfractionlab/JFractionLab" >> myManifest
		echo "Class-Path: TableLayout-bin-jdk1.5-2009-06-10.jar Help_de.jar Help_en.jar Help_es.jar Help_fr.jar lang" >> myManifest
		# option splash 
		echo "Splashscreen-Image: icons/splash.png" >> myManifest
		echo "Sealed: true" >> myManifest
		#"$JAR" cmvf myManifest JFractionLab.jar *
		"$JAR" cmf myManifest JFractionLab.jar *
	#clean up
		rm -rf icons/ jfractionlab/ lang/ myManifest
	cd "$ROOT"
		rm -rf mkJflJar.sh*
}
pack(){
	mkdir $DESTINATIONDIR
	rm COMPILE*
	mv CHANGELOG* LICENCE* bin/ icons/ $DESTINATIONDIR
	#zip -r $DESTINATIONDIR.zip $DESTINATIONDIR
	#rm -rf $DESTINATIONDIR
	cd "$ROOT"
}

if [ $# -ne 1 ]; then
	echo "Please give me the number of the version, e.g.: 024!"
else
	VERSION="$1"
	#rm -rf bin/*/*class
	setVersionNB
	compile
	build
	pack
cd
fi
