/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import org.jruby.Ruby;
import org.jruby.embed.BiVariable;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.parser.EvalStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class PersistentLocalVariable
extends AbstractVariable {
    public static BiVariable getInstance(Ruby runtime, String name, Object ... javaObject) {
        String pattern = "([a-z]|_)([a-zA-Z]|_|\\d)*";
        if (name.matches(pattern)) {
            return new PersistentLocalVariable(runtime, name, javaObject);
        }
        return null;
    }

    private PersistentLocalVariable(Ruby runtime, String name, Object ... javaObject) {
        super(runtime, name, javaObject);
    }

    PersistentLocalVariable(String name, IRubyObject irubyObject) {
        super(name, irubyObject);
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.LocalVariable;
    }

    public static void retrieve(Ruby runtime, IRubyObject receiver, BiVariableMap vars) {
        ManyVarsDynamicScope scope = (ManyVarsDynamicScope)runtime.getCurrentContext().getCurrentScope();
        if (scope == null) {
            return;
        }
        String[] names = scope.getAllNamesInScope();
        IRubyObject[] values = scope.getValues();
        if (names == null || values == null || names.length == 0 || values.length == 0) {
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            BiVariable v = vars.getVariable(names[i]);
            if (v != null) {
                v.setRubyObject(values[i]);
                continue;
            }
            v = new PersistentLocalVariable(names[i], values[i]);
            vars.update(names[i], v);
        }
    }

    public void inject(Ruby runtime, IRubyObject receiver) {
    }

    public void remove(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        DynamicScope currentScope = context.getCurrentScope();
        ManyVarsDynamicScope scope = (ManyVarsDynamicScope)context.getCurrentScope();
        scope = new ManyVarsDynamicScope((StaticScope)new EvalStaticScope(currentScope.getStaticScope()), currentScope);
    }
}

