/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.NullMemoryIO;
import com.kenai.jaffl.provider.jffi.AllocatedDirectMemoryIO;
import com.kenai.jaffl.provider.jffi.ArrayMemoryIO;
import com.kenai.jaffl.provider.jffi.BoundedDirectMemoryIO;
import com.kenai.jaffl.provider.jffi.ByteBufferMemoryIO;
import com.kenai.jaffl.provider.jffi.DirectMemoryIO;
import com.kenai.jaffl.provider.jffi.JFFIPointer;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class MemoryManager
implements com.kenai.jaffl.provider.MemoryManager {
    public MemoryIO allocate(int size) {
        return new ArrayMemoryIO(size);
    }

    public MemoryIO allocateDirect(int size) {
        return new BoundedDirectMemoryIO(new AllocatedDirectMemoryIO(size, false), 0L, (long)size);
    }

    public MemoryIO allocateDirect(int size, boolean clear) {
        return new BoundedDirectMemoryIO(new AllocatedDirectMemoryIO(size, clear), 0L, (long)size);
    }

    public MemoryIO wrap(Pointer ptr) {
        if (ptr instanceof JFFIPointer) {
            long address = ((JFFIPointer)ptr).address;
            return address != 0L ? new DirectMemoryIO(address) : new NullMemoryIO();
        }
        throw new UnsupportedOperationException("Unsupported Pointer type");
    }

    public MemoryIO wrap(Pointer ptr, int size) {
        if (ptr instanceof JFFIPointer) {
            long address = ((JFFIPointer)ptr).address;
            return address != 0L ? new BoundedDirectMemoryIO(new DirectMemoryIO(address), 0L, (long)size) : new NullMemoryIO();
        }
        throw new UnsupportedOperationException("Unsupported Pointer type");
    }

    public MemoryIO wrap(ByteBuffer buffer) {
        return new ByteBufferMemoryIO(buffer);
    }

    public Pointer getBufferPointer(Buffer buffer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

