/* Rotate3D.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.mouse;

import be.ugent.caagt.swirl.mouse.NullMouseHandler;

import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

import org.grinvin.gred.GraphPanel3D;

/**
 * Mouse handler which can be used to rotate a 3-dimensional model. Consumes all first button
 * pressed events.
 */
public class Rotate3D extends NullMouseHandler {

    // create a singleton
    private Rotate3D () { }
    
    //
    private static final Rotate3D SINGLETON = new Rotate3D();
    
    /**
     * Return the singleton object of this type.
     */
    public static Rotate3D getHandler () {
        return SINGLETON;
    }
    /**
     * Consume the event when pressed.
     */
    @Override public void doMousePressed(JComponent parent, MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton (mouseEvent))
            mouseEvent.consume ();
    }
   
    @Override public void doMouseDragged(JComponent parent, MouseEvent mouseEvent, MouseEvent previousEvent, MouseEvent pressedEvent) {
       int dx = mouseEvent.getX() - previousEvent.getX();
       int dy = mouseEvent.getY() - previousEvent.getY();
       ((GraphPanel3D)parent).rotate (dx, dy);
    }

    @Override public boolean canHandle(JComponent parent) {
        return parent instanceof GraphPanel3D;
    }

    
}
