/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.model.AbstractNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.ConstructorArgumentNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.PropertyNode;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class BeanNode
extends AbstractNode {
    private ConfigNode config;
    private boolean isOverride;
    private List constructorArguments;
    private List properties;
    private Map propertiesMap;
    private List innerBeans;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BeanNode(ConfigNode config, String name) {
        super(config, name);
        this.config = config;
        this.constructorArguments = new ArrayList();
        this.properties = new ArrayList();
        this.innerBeans = new ArrayList();
        this.isOverride = false;
        if (config != null && (config.getFlags() & 1) != 0) {
            this.setFlags(1);
        }
    }

    public BeanNode(BeanNode bean, String name) {
        super(bean, name);
        this.constructorArguments = new ArrayList();
        this.properties = new ArrayList();
        this.innerBeans = new ArrayList();
        this.isOverride = false;
        if (bean != null && (bean.getFlags() & 1) != 0) {
            this.setFlags(1);
        }
    }

    public BeanNode(ConfigSetNode configSet, BeanNode bean) {
        super(configSet, bean.getName());
        this.config = bean.getConfigNode();
        this.setElement(bean.getElement());
        this.setFlags(bean.getFlags());
        this.constructorArguments = new ArrayList();
        ConstructorArgumentNode[] cargs = bean.getConstructorArguments();
        int i = 0;
        while (i < cargs.length) {
            this.constructorArguments.add(new ConstructorArgumentNode(this, cargs[i].getConstructorArgument()));
            ++i;
        }
        this.properties = new ArrayList();
        PropertyNode[] props = bean.getProperties();
        int i2 = 0;
        while (i2 < props.length) {
            this.properties.add(new PropertyNode(this, props[i2].getProperty()));
            ++i2;
        }
        this.innerBeans = new ArrayList();
        BeanNode[] inner = bean.getInnerBeans();
        int i3 = 0;
        while (i3 < inner.length) {
            this.innerBeans.add(new BeanNode(this, inner[i3]));
            ++i3;
        }
        this.isOverride = false;
        if (this.config != null && (this.config.getFlags() & 1) != 0) {
            this.setFlags(1);
        }
    }

    public BeanNode(BeanNode bean, BeanNode innerBean) {
        super(bean, innerBean.getName());
        this.config = innerBean.getConfigNode();
        this.setElement(innerBean.getElement());
        this.setFlags(innerBean.getFlags());
        this.constructorArguments = new ArrayList();
        ConstructorArgumentNode[] cargs = innerBean.getConstructorArguments();
        int i = 0;
        while (i < cargs.length) {
            this.constructorArguments.add(new ConstructorArgumentNode(this, cargs[i].getConstructorArgument()));
            ++i;
        }
        this.properties = new ArrayList();
        PropertyNode[] props = innerBean.getProperties();
        int i2 = 0;
        while (i2 < props.length) {
            this.properties.add(new PropertyNode(this, props[i2].getProperty()));
            ++i2;
        }
        this.innerBeans = new ArrayList();
        BeanNode[] inner = innerBean.getInnerBeans();
        int i3 = 0;
        while (i3 < inner.length) {
            this.innerBeans.add(new BeanNode(this, inner[i3]));
            ++i3;
        }
        this.isOverride = false;
        if (this.config != null && (this.config.getFlags() & 1) != 0) {
            this.setFlags(1);
        }
    }

    public void setBean(IBean bean) {
        this.setElement((IModelElement)bean);
        if (bean != null) {
            if (!bean.isSingleton()) {
                this.setFlags(8);
            }
            if (bean.isLazyInit()) {
                this.setFlags(16);
            }
            if (bean.isAbstract()) {
                this.setFlags(32);
            }
            if (bean.isRootBean() && bean.getClassName() == null && bean.getParentName() == null) {
                this.setFlags(64);
            }
        }
    }

    public IBean getBean() {
        return (IBean)this.getElement();
    }

    public void setIsOverride(boolean isOverridden) {
        this.isOverride = isOverridden;
        this.setFlags(4);
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public void addConstructorArgument(ConstructorArgumentNode carg) {
        this.constructorArguments.add(carg);
    }

    public ConstructorArgumentNode[] getConstructorArguments() {
        return this.constructorArguments.toArray(new ConstructorArgumentNode[this.constructorArguments.size()]);
    }

    public boolean hasConstructorArguments() {
        return !this.constructorArguments.isEmpty();
    }

    public void addProperty(PropertyNode property) {
        this.properties.add(property);
    }

    public PropertyNode getProperty(String name) {
        if (this.propertiesMap == null) {
            this.propertiesMap = new HashMap();
            Iterator iter = this.properties.iterator();
            while (iter.hasNext()) {
                PropertyNode property = (PropertyNode)iter.next();
                this.propertiesMap.put(property.getName(), property);
            }
        }
        return (PropertyNode)this.propertiesMap.get(name);
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public PropertyNode[] getProperties() {
        return this.properties.toArray(new PropertyNode[this.properties.size()]);
    }

    public void addInnerBean(BeanNode bean) {
        this.innerBeans.add(bean);
    }

    public BeanNode[] getInnerBeans() {
        return this.innerBeans.toArray(new BeanNode[this.innerBeans.size()]);
    }

    public String getClassName() {
        return this.getBean() != null ? this.getBean().getClassName() : null;
    }

    public String getParentName() {
        return this.getBean() != null ? this.getBean().getParentName() : null;
    }

    public boolean isRootBean() {
        return this.getBean() != null ? this.getBean().isRootBean() : true;
    }

    public boolean isSingleton() {
        return this.getBean() != null ? this.getBean().isSingleton() : true;
    }

    public boolean isLazyInit() {
        return this.getBean() != null ? this.getBean().isLazyInit() : false;
    }

    public boolean isAbstract() {
        return this.getBean() != null ? this.getBean().isAbstract() : false;
    }

    public ConfigNode getConfigNode() {
        return this.config;
    }

    public void remove(INode node) {
        this.properties.remove(node);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return BeansUIUtils.getPropertySource((IModelElement)this.getBean());
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.springframework.ide.eclipse.core.model.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getBean();
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.getName());
        if (this.getClassName() != null) {
            text.append(" [");
            text.append(this.getClassName());
            text.append(']');
        } else if (this.getParentName() != null) {
            text.append(" <");
            text.append(this.getParentName());
            text.append('>');
        }
        return text.toString();
    }
}

