/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.springframework.ide.eclipse.beans.core.BeanDefinitionException;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.model.AbstractNode;
import org.springframework.ide.eclipse.beans.ui.model.BeanNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.ConstructorArgumentNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.model.PropertyNode;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class ConfigNode
extends AbstractNode {
    private List beans;
    private Map beansMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ConfigNode(ProjectNode project, String name) {
        super(project, name);
        this.setConfig(project);
    }

    public ConfigNode(ConfigSetNode configSet, String name) {
        super(configSet, name);
        this.setConfig(configSet.getProjectNode());
    }

    public ProjectNode getProjectNode() {
        INode parent = this.getParent();
        if (parent instanceof ConfigSetNode) {
            return ((ConfigSetNode)parent).getProjectNode();
        }
        return (ProjectNode)parent;
    }

    public IBeansConfig getConfig() {
        return (IBeansConfig)this.getElement();
    }

    public IFile getConfigFile() {
        return this.getConfig() != null ? this.getConfig().getConfigFile() : null;
    }

    public BeanNode getBean(String name) {
        if (this.beansMap == null) {
            if (this.beans == null) {
                this.createBeans();
                this.refreshViewer();
            }
            this.beansMap = new HashMap();
            Iterator iter = this.beans.iterator();
            while (iter.hasNext()) {
                BeanNode bean = (BeanNode)iter.next();
                this.beansMap.put(bean.getName(), bean);
            }
        }
        return (BeanNode)this.beansMap.get(name);
    }

    public BeanNode[] getBeans(boolean refreshViewer) {
        if (this.beans == null) {
            this.createBeans();
            if (refreshViewer) {
                this.refreshViewer();
            }
        }
        return this.beans.toArray(new BeanNode[this.beans.size()]);
    }

    public void addBean(BeanNode bean) {
        this.beans.add(bean);
    }

    private void setErrorMessage(String errorMessage, int lineNumber) {
        BeanNode bean = new BeanNode(this, errorMessage);
        bean.setStartLine(lineNumber);
        bean.setFlags(2);
        this.addBean(bean);
    }

    public void clear() {
        this.beans.clear();
    }

    public void remove(INode node) {
        this.beans.remove(node);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return BeansUIUtils.getPropertySource((IModelElement)this.getConfig());
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.springframework.ide.eclipse.core.model.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getConfig();
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        StringBuffer text = new StringBuffer(this.getName());
        if (this.getConfig() != null) {
            text.append(": ");
            text.append(this.getConfig().toString());
        }
        return text.toString();
    }

    private void setConfig(ProjectNode project) {
        String configName = this.getName();
        if (configName.charAt(0) == '/') {
            this.setElement((IModelElement)BeansCorePlugin.getModel().getConfig(configName));
            this.setFlags(1);
        } else {
            this.setElement((IModelElement)project.getProject().getConfig(configName));
        }
    }

    private void createBeans() {
        this.beans = new ArrayList();
        if (this.getConfig() == null) {
            this.setErrorMessage("Undefined Spring config '" + this.getName() + "'", -1);
        } else {
            BeanDefinitionException exception = this.getConfig().getException();
            if (exception != null) {
                this.setErrorMessage(exception.getMessage(), exception.getLineNumber());
            } else {
                Iterator iter = this.getConfig().getBeans().iterator();
                while (iter.hasNext()) {
                    IBean bean = (IBean)iter.next();
                    BeanNode beanNode = new BeanNode(this, bean.getElementName());
                    this.initBeanNode(beanNode, bean);
                    this.beans.add(beanNode);
                }
            }
        }
    }

    private void initBeanNode(BeanNode beanNode, IBean bean) {
        beanNode.setBean(bean);
        Iterator cargs = bean.getConstructorArguments().iterator();
        while (cargs.hasNext()) {
            IBeanConstructorArgument carg = (IBeanConstructorArgument)cargs.next();
            beanNode.addConstructorArgument(new ConstructorArgumentNode(beanNode, carg));
        }
        Iterator props = bean.getProperties().iterator();
        while (props.hasNext()) {
            IBeanProperty prop = (IBeanProperty)props.next();
            beanNode.addProperty(new PropertyNode(beanNode, prop));
        }
        Iterator inner = bean.getInnerBeans().iterator();
        while (inner.hasNext()) {
            IBean innerBean = (IBean)inner.next();
            BeanNode innerBeanNode = new BeanNode(beanNode, innerBean.getElementName());
            this.initBeanNode(innerBeanNode, innerBean);
            beanNode.addInnerBean(innerBeanNode);
        }
    }
}

