/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.model.BeanNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;
import org.springframework.ide.eclipse.beans.ui.model.ConfigSetNode;
import org.springframework.ide.eclipse.beans.ui.model.ConstructorArgumentNode;
import org.springframework.ide.eclipse.beans.ui.model.INode;
import org.springframework.ide.eclipse.beans.ui.model.ProjectNode;
import org.springframework.ide.eclipse.beans.ui.model.PropertyNode;

public class ModelLabelProvider
extends LabelProvider {
    public Image getImage(Object obj) {
        if (obj instanceof ProjectNode) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.project_obj.gif");
        }
        if (obj instanceof ConfigSetNode) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.configset_obj.gif");
        }
        if (obj instanceof ConfigNode) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.config_obj.gif");
        }
        if (obj instanceof BeanNode) {
            BeanNode bean = (BeanNode)obj;
            if (bean.getParentName() != null) {
                return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.childbean_obj.gif");
            }
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.rootbean_obj.gif");
        }
        if (obj instanceof ConstructorArgumentNode) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.constructor_obj.gif");
        }
        if (obj instanceof PropertyNode) {
            return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.property_obj.gif");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof INode) {
            StringBuffer label = new StringBuffer();
            label.append(((INode)element).getName());
            if (element instanceof BeanNode) {
                BeanNode bean = (BeanNode)element;
                if (bean.getClassName() != null) {
                    label.append(" [");
                    label.append(bean.getClassName());
                    label.append(']');
                } else if (bean.getParentName() != null) {
                    label.append(" <");
                    label.append(bean.getParentName());
                    label.append('>');
                }
            } else if (element instanceof PropertyNode) {
                Object value = ((PropertyNode)element).getValue();
                if (value instanceof String) {
                    label.append(" \"");
                    label.append(value);
                    label.append('\"');
                } else if (value instanceof BeanDefinitionHolder) {
                    BeanDefinitionHolder bdHolder = (BeanDefinitionHolder)value;
                    BeanDefinition beanDef = bdHolder.getBeanDefinition();
                    label.append(" {");
                    label.append(bdHolder.getBeanName());
                    if (beanDef instanceof RootBeanDefinition) {
                        label.append(" [");
                        label.append(((RootBeanDefinition)beanDef).getBeanClassName());
                        label.append(']');
                    } else {
                        label.append(" <");
                        label.append(((ChildBeanDefinition)beanDef).getParentName());
                        label.append('>');
                    }
                    label.append('}');
                } else {
                    label.append(' ');
                    label.append(value);
                }
            }
            return label.toString();
        }
        return super.getText(element);
    }
}

