/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.views;

import java.util.Iterator;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.springframework.ide.eclipse.beans.ui.model.ConfigNode;

public class BeansViewDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private Viewer viewer;

    public BeansViewDragAdapter(Viewer viewer) {
        this.viewer = viewer;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            event.doit = false;
            return;
        }
        Object previous = null;
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (previous != null && !previous.getClass().equals(next.getClass())) {
                event.doit = false;
                return;
            }
            if (!(next instanceof ConfigNode)) {
                event.doit = false;
                return;
            }
            previous = next;
        }
        LocalSelectionTransfer.getInstance().setSelection((ISelection)selection);
        LocalSelectionTransfer.getInstance().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
        event.doit = true;
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = LocalSelectionTransfer.getInstance().getSelection();
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer.getInstance().setSelection(null);
        LocalSelectionTransfer.getInstance().setSelectionSetTime(0L);
    }
}

