/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigValidator;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.internal.model.resources.BeansResourceChangeListener;
import org.springframework.ide.eclipse.beans.core.internal.model.resources.IBeansResourceChangeEvents;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.model.AbstractModel;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;

public class BeansModel
extends AbstractModel
implements IBeansModel {
    public static final String DEBUG_OPTION = "org.springframework.ide.eclipse.beans.core/model/debug";
    public static boolean DEBUG = BeansCorePlugin.isDebug("org.springframework.ide.eclipse.beans.core/model/debug");
    private Hashtable projects = new Hashtable();
    private IResourceChangeListener workspaceListener = new BeansResourceChangeListener(new ResourceChangeEventHandler());

    public BeansModel() {
        super(null, "BeansModel");
    }

    public IModelElement[] getElementChildren() {
        return this.getProjects().toArray(new IModelElement[this.getProjects().size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(IModelElementVisitor visitor) {
        Hashtable hashtable = this.projects;
        synchronized (hashtable) {
            Iterator iter = this.projects.values().iterator();
            while (iter.hasNext()) {
                IModelElement element = (IModelElement)iter.next();
                element.accept(visitor);
            }
        }
    }

    public void startup() {
        if (DEBUG) {
            System.out.println("Beans Model startup");
        }
        this.initialize();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.workspaceListener, 22);
    }

    public void shutdown() {
        if (DEBUG) {
            System.out.println("Beans Model shutdown");
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.workspaceListener);
        this.workspaceListener = null;
        this.projects.clear();
    }

    public boolean hasProject(IProject project) {
        return project != null && project.isAccessible() && this.projects.containsKey(project);
    }

    public IBeansProject getProject(IProject project) {
        return (IBeansProject)this.projects.get(project);
    }

    public IBeansProject getProject(String name) {
        int configNamePos = name.indexOf(47, name.charAt(0) == '/' ? 1 : 0);
        if (configNamePos > 0) {
            name = name.substring(0, configNamePos);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(name);
        return this.getProject(project);
    }

    public Collection getProjects() {
        return this.projects.values();
    }

    public boolean hasConfig(IFile configFile) {
        IBeansProject project;
        if (configFile != null && (project = this.getProject(configFile.getProject())) != null) {
            return project.hasConfig(configFile);
        }
        return false;
    }

    public IBeansConfig getConfig(IFile configFile) {
        IBeansProject project;
        if (configFile != null && (project = this.getProject(configFile.getProject())) != null) {
            return project.getConfig(configFile);
        }
        return null;
    }

    public IBeansConfig getConfig(String configName) {
        int configNamePos = configName.indexOf(47, configName.charAt(0) == '/' ? 1 : 0);
        if (configNamePos > 0) {
            String projectName = configName.substring(1, configNamePos);
            configName = configName.substring(configNamePos + 1);
            IBeansProject project = BeansCorePlugin.getModel().getProject(projectName);
            if (project != null) {
                return project.getConfig(configName);
            }
        }
        return null;
    }

    public Collection getConfigs(String className) {
        ArrayList<IBeansConfig> configs = new ArrayList<IBeansConfig>();
        Iterator iter = this.getProjects().iterator();
        while (iter.hasNext()) {
            IBeansProject project = (IBeansProject)iter.next();
            Iterator iter2 = project.getConfigs().iterator();
            while (iter2.hasNext()) {
                IBeansConfig config = (IBeansConfig)iter2.next();
                if (!config.isBeanClass(className)) continue;
                configs.add(config);
            }
        }
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer text = new StringBuffer("Beans model:\n");
        Hashtable hashtable = this.projects;
        synchronized (hashtable) {
            Iterator projs = this.projects.values().iterator();
            while (projs.hasNext()) {
                IBeansProject project = (IBeansProject)projs.next();
                text.append(" Configs of project '");
                text.append(project.getElementName());
                text.append("':\n");
                Iterator configs = project.getConfigs().iterator();
                while (configs.hasNext()) {
                    IBeansConfig config = (IBeansConfig)configs.next();
                    text.append("  ");
                    text.append(config);
                    text.append('\n');
                    Iterator beans = config.getBeans().iterator();
                    while (beans.hasNext()) {
                        IBean bean = (IBean)beans.next();
                        text.append("   ");
                        text.append(bean);
                        text.append('\n');
                    }
                }
                text.append(" Config sets of project '");
                text.append(project.getElementName());
                text.append("':\n");
                Iterator configSets = project.getConfigSets().iterator();
                while (configSets.hasNext()) {
                    IBeansConfigSet configSet = (IBeansConfigSet)configSets.next();
                    text.append("  ");
                    text.append(configSet);
                    text.append('\n');
                }
            }
        }
        return text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (DEBUG) {
            System.out.println("Initializing model - loading all projects");
        }
        Hashtable hashtable = this.projects;
        synchronized (hashtable) {
            this.projects.clear();
            List projects = BeansModel.getBeansProjects();
            if (!projects.isEmpty()) {
                Iterator iter = projects.iterator();
                while (iter.hasNext()) {
                    IProject project = (IProject)iter.next();
                    this.projects.put(project, new BeansProject(project));
                }
            }
        }
    }

    private static List getBeansProjects() {
        ArrayList<IProject> springProjects = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (SpringCoreUtils.isSpringProject((IResource)project)) {
                springProjects.add(project);
            }
            ++i;
        }
        return springProjects;
    }

    private class ResourceChangeEventHandler
    implements IBeansResourceChangeEvents {
        ResourceChangeEventHandler() {
        }

        public boolean isSpringProject(IProject project) {
            return BeansModel.this.getProject(project) != null;
        }

        public void springNatureAdded(IProject project) {
            if (DEBUG) {
                System.out.println("Spring beans nature added to project '" + project.getName() + "'");
            }
            BeansProject proj = new BeansProject(project);
            BeansModel.this.projects.put(project, proj);
            BeansModel.this.notifyListeners((IModelElement)proj, 1);
        }

        public void springNatureRemoved(IProject project) {
            if (DEBUG) {
                System.out.println("Spring beans nature removed from project '" + project.getName() + "'");
            }
            IBeansProject proj = (IBeansProject)BeansModel.this.projects.remove(project);
            BeansModel.this.notifyListeners((IModelElement)proj, 2);
        }

        public void projectAdded(IProject project) {
            if (DEBUG) {
                System.out.println("Project '" + project.getName() + "' added");
            }
            BeansProject proj = new BeansProject(project);
            BeansModel.this.projects.put(project, proj);
            BeansModel.this.notifyListeners((IModelElement)proj, 1);
        }

        public void projectOpened(IProject project) {
            if (DEBUG) {
                System.out.println("Project '" + project.getName() + "' opened");
            }
            BeansProject proj = new BeansProject(project);
            BeansModel.this.projects.put(project, proj);
            BeansModel.this.notifyListeners((IModelElement)proj, 1);
        }

        public void projectClosed(IProject project) {
            if (DEBUG) {
                System.out.println("Project '" + project.getName() + "' closed");
            }
            IBeansProject proj = (IBeansProject)BeansModel.this.projects.remove(project);
            BeansModel.this.notifyListeners((IModelElement)proj, 2);
        }

        public void projectDeleted(IProject project) {
            if (DEBUG) {
                System.out.println("Project '" + project.getName() + "' deleted");
            }
            IBeansProject proj = (IBeansProject)BeansModel.this.projects.remove(project);
            BeansModel.this.notifyListeners((IModelElement)proj, 2);
        }

        public void projectDescriptionChanged(IFile file) {
            if (DEBUG) {
                System.out.println("Project description '" + file.getFullPath() + "' changed");
            }
            BeansProject project = (BeansProject)BeansModel.this.projects.get(file.getProject());
            project.reset();
            BeansModel.this.notifyListeners((IModelElement)project, 3);
        }

        public void configAdded(IFile file) {
            if (DEBUG) {
                System.out.println("Config '" + file.getFullPath() + "' added");
            }
            BeansProject project = (BeansProject)BeansModel.this.projects.get(file.getProject());
            project.addConfig(file);
            IBeansConfig config = project.getConfig(file);
            BeansModel.this.notifyListeners((IModelElement)config, 1);
        }

        public void configChanged(IFile file) {
            IBeansProject project;
            BeansConfig config;
            if (DEBUG) {
                System.out.println("Config '" + file.getFullPath() + "' changed");
            }
            if (!(config = (BeansConfig)(project = (IBeansProject)BeansModel.this.projects.get(file.getProject())).getConfig(file)).isReset()) {
                config.reset();
            }
            BeansModel.this.notifyListeners((IModelElement)config, 3);
        }

        public void configRemoved(IFile file) {
            if (DEBUG) {
                System.out.println("Config '" + file.getFullPath() + "' removed");
            }
            BeansProject project = (BeansProject)BeansModel.this.projects.get(file.getProject());
            BeansConfig config = (BeansConfig)project.getConfig(file);
            project.removeConfig(file);
            BeansModel.this.notifyListeners((IModelElement)config, 2);
        }

        public void beanClassChanged(String className, Collection configs) {
            if (DEBUG) {
                System.out.println("Bean class '" + className + "' changed");
            }
            BeansConfigValidator validator = new BeansConfigValidator();
            Iterator iter = configs.iterator();
            while (iter.hasNext()) {
                IBeansConfig config = (IBeansConfig)iter.next();
                BeansCoreUtils.deleteProblemMarkers((IResource)config.getConfigFile());
                validator.validate(config, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

