/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BeansGraphPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.beans.ui.graph";
    private static final String RESOURCE_NAME = "org.springframework.ide.eclipse.beans.ui.graph.messages";
    private static BeansGraphPlugin plugin;
    private ResourceBundle resourceBundle;

    public BeansGraphPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException e) {
            BeansGraphPlugin.log(e);
            this.resourceBundle = null;
        }
    }

    public static BeansGraphPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = BeansGraphPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return BeansGraphPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void log(IStatus status) {
        BeansGraphPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = BeansGraphPlugin.createErrorStatus(message, exception);
        BeansGraphPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        BeansGraphPlugin.getDefault().getLog().log(BeansGraphPlugin.createErrorStatus(BeansGraphPlugin.getResourceString("Plugin.internal_error"), exception));
    }

    public static IStatus createErrorStatus(String message) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }
}

