/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanReference;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditorInput;
import org.springframework.ide.eclipse.beans.ui.graph.figures.BeanFigure;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.beans.ui.graph.model.ConstructorArgument;
import org.springframework.ide.eclipse.beans.ui.graph.model.Property;
import org.springframework.ide.eclipse.beans.ui.graph.model.Reference;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class Graph
implements IAdaptable {
    private static final int MAX_ORPHAN_ROW_WIDTH = 600;
    private static final Insets DEFAULT_PADDING = new Insets(16);
    private static final String ERROR_TITLE = "Graph.error.title";
    private GraphEditorInput input;
    private DirectedGraph graph;

    public Graph(GraphEditorInput input) {
        this.input = input;
        this.initGraph();
    }

    private void initGraph() {
        this.graph = new DirectedGraph();
        Iterator beans = this.getBeans().iterator();
        while (beans.hasNext()) {
            Bean bean = (Bean)((Object)beans.next());
            this.graph.nodes.add((Object)bean);
            Iterator beanRefs = BeansModelUtils.getBeanReferences((IModelElement)bean.getBean(), (IModelElement)this.input.getContext(), (boolean)false).iterator();
            while (beanRefs.hasNext()) {
                BeanReference beanRef = (BeanReference)beanRefs.next();
                Bean targetBean = this.getBean(beanRef.getTarget().getElementName());
                if (targetBean == null || targetBean == bean || !(beanRef.getSource() instanceof IBean)) continue;
                this.graph.edges.add((Object)new Reference(beanRef.getType(), bean, targetBean));
            }
            ConstructorArgument[] cargs = bean.getConstructorArguments();
            int i = 0;
            while (i < cargs.length) {
                ConstructorArgument carg = cargs[i];
                Iterator cargRefs = BeansModelUtils.getBeanReferences((IModelElement)carg.getBeanConstructorArgument(), (IModelElement)this.input.getContext(), (boolean)false).iterator();
                while (cargRefs.hasNext()) {
                    BeanReference beanRef = (BeanReference)cargRefs.next();
                    Bean targetBean = this.getBean(beanRef.getTarget().getElementName());
                    if (targetBean == null || targetBean == bean) continue;
                    this.graph.edges.add((Object)new Reference(beanRef.getType(), bean, targetBean, carg));
                }
                ++i;
            }
            Property[] properties = bean.getProperties();
            int i2 = 0;
            while (i2 < properties.length) {
                Property property = properties[i2];
                Iterator propRefs = BeansModelUtils.getBeanReferences((IModelElement)property.getBeanProperty(), (IModelElement)this.input.getContext(), (boolean)false).iterator();
                while (propRefs.hasNext()) {
                    BeanReference beanRef = (BeanReference)propRefs.next();
                    Bean targetBean = this.getBean(beanRef.getTarget().getElementName());
                    if (targetBean == null || targetBean == bean) continue;
                    this.graph.edges.add((Object)new Reference(beanRef.getType(), bean, targetBean, property));
                }
                ++i2;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        return this.input.getAdapter(adapter);
    }

    protected Collection getBeans() {
        return this.input.getBeans().values();
    }

    protected Bean getBean(String name) {
        return (Bean)((Object)this.input.getBeans().get(name));
    }

    public List getNodes() {
        return this.graph.nodes;
    }

    public void layout(Font font) {
        Iterator beans = this.graph.nodes.iterator();
        while (beans.hasNext()) {
            Bean bean = (Bean)((Object)beans.next());
            BeanFigure dummy = new BeanFigure(bean);
            dummy.setFont(font);
            Dimension size = dummy.getPreferredSize();
            bean.width = size.width;
            bean.height = size.height;
            bean.preferredHeight = size.height;
        }
        Bean root = new Bean();
        this.graph.nodes.add((Object)root);
        EdgeList rootEdges = new EdgeList();
        ArrayList<Bean> orphanBeans = new ArrayList<Bean>();
        beans = this.getBeans().iterator();
        while (beans.hasNext()) {
            Bean bean = (Bean)((Object)beans.next());
            if (bean.incoming.isEmpty() && bean.outgoing.isEmpty()) {
                orphanBeans.add(bean);
                this.graph.nodes.remove((Object)bean);
                continue;
            }
            Reference reference = new Reference(root, bean);
            reference.weight = 0;
            rootEdges.add((Object)reference);
            this.graph.edges.add((Object)reference);
        }
        try {
            Edge e;
            new DirectedGraphLayout().visit(this.graph);
            int i = 0;
            while (i < this.graph.edges.size()) {
                e = this.graph.edges.getEdge(i);
                if (e.isFeedback) {
                    e.invert();
                }
                ++i;
            }
            i = 0;
            while (i < rootEdges.size()) {
                e = rootEdges.getEdge(i);
                e.source.outgoing.remove((Object)e);
                e.target.incoming.remove((Object)e);
                this.graph.edges.remove((Object)e);
                ++i;
            }
            this.graph.nodes.remove((Object)root);
            int maxY = 0;
            int maxX = 0;
            int ranks = this.graph.ranks.size();
            if (ranks > 1) {
                int deltaY = this.graph.ranks.getRank((int)1).getNode((int)0).y;
                Iterator nodes = this.graph.nodes.iterator();
                while (nodes.hasNext()) {
                    Bean node = (Bean)((Object)nodes.next());
                    node.y -= deltaY;
                    if (node.y + node.height > maxY) {
                        maxY = node.y + node.height;
                    }
                    if (node.x + node.width <= maxX) continue;
                    maxX = node.x + node.width;
                }
                Iterator edges = this.graph.edges.iterator();
                while (edges.hasNext()) {
                    Edge edge = (Edge)edges.next();
                    if (edge.vNodes == null) continue;
                    Iterator points = edge.vNodes.iterator();
                    while (points.hasNext()) {
                        Node node = (Node)points.next();
                        node.y -= deltaY;
                    }
                }
            }
            int x = 0;
            int y = maxY;
            if (maxY > 0) {
                y += DEFAULT_PADDING.getHeight();
            }
            if (maxX < 600) {
                maxX = 600;
            }
            maxY = 0;
            beans = orphanBeans.iterator();
            while (beans.hasNext()) {
                Bean bean = (Bean)((Object)beans.next());
                if (x + bean.width > maxX) {
                    x = 0;
                    bean.x = 0;
                    bean.y = y += maxY + DEFAULT_PADDING.getHeight();
                    maxY = bean.height;
                } else {
                    bean.y = y;
                    bean.x = x;
                    if (bean.height > maxY) {
                        maxY = bean.height;
                    }
                }
                x += bean.width + DEFAULT_PADDING.getWidth();
                this.graph.nodes.add((Object)bean);
            }
        }
        catch (RuntimeException e) {
            this.graph = new DirectedGraph();
            this.input.setHasError(true);
            MessageDialog.openError((Shell)BeansGraphPlugin.getActiveWorkbenchWindow().getShell(), (String)BeansGraphPlugin.getResourceString(ERROR_TITLE), (String)e.getMessage());
        }
    }
}

