/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SpringUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.ui";
    private static final String RESOURCE_NAME = "org.springframework.ide.eclipse.ui.messages";
    private static SpringUIPlugin plugin;
    private ResourceBundle resourceBundle;

    public SpringUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException e) {
            SpringUIPlugin.log(e);
            this.resourceBundle = null;
        }
    }

    public static SpringUIPlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return SpringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        return SpringUIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        return SpringUIPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static String getResourceString(String key) {
        String bundleString;
        ResourceBundle bundle = SpringUIPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                SpringUIPlugin.log(e);
                bundleString = "!" + key + "!";
            }
        } else {
            bundleString = "!" + key + "!";
        }
        return bundleString;
    }

    public static String getFormattedMessage(String key, String arg) {
        return SpringUIPlugin.getFormattedMessage(key, new String[]{arg});
    }

    public static String getFormattedMessage(String key, String[] args) {
        return MessageFormat.format(SpringUIPlugin.getResourceString(key), args);
    }

    public static boolean isDebug(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void log(IStatus status) {
        SpringUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = SpringUIPlugin.createErrorStatus(message, exception);
        SpringUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        SpringUIPlugin.getDefault().getLog().log(SpringUIPlugin.createErrorStatus(SpringUIPlugin.getResourceString("Plugin.internal_error"), exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }
}

