/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.project;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class SpringProjectNature
implements IProjectNature {
    public static final String DEBUG_OPTION = "org.springframework.ide.eclipse.core/project/nature/debug";
    public static boolean DEBUG = SpringCore.isDebug("org.springframework.ide.eclipse.core/project/nature/debug");
    private IProject project;

    public void setProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public void configure() throws CoreException {
        IProject project;
        IProjectDescription desc;
        ICommand builderCommand;
        if (DEBUG) {
            System.out.println("configuring Spring project nature");
        }
        if ((builderCommand = this.getBuilderCommand(desc = (project = this.getProject()).getDescription(), "org.springframework.ide.eclipse.core.springbuilder")) == null) {
            ICommand command = desc.newCommand();
            command.setBuilderName("org.springframework.ide.eclipse.core.springbuilder");
            this.setBuilderCommand(desc, command);
            project.setDescription(desc, null);
        }
    }

    public void deconfigure() throws CoreException {
        if (DEBUG) {
            System.out.println("deconfiguring Spring project nature");
        }
        IProject project = this.getProject();
        SpringCoreUtils.removeProjectBuilder(project, "org.springframework.ide.eclipse.core.springbuilder");
    }

    private ICommand getBuilderCommand(IProjectDescription description, String builderID) throws CoreException {
        ICommand command = null;
        ICommand[] commands = description.getBuildSpec();
        int i = commands.length - 1;
        while (i >= 0) {
            if (commands[i].getBuilderName().equals(builderID)) {
                command = commands[i];
                break;
            }
            --i;
        }
        return command;
    }

    private void setBuilderCommand(IProjectDescription description, ICommand command) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldBuilderCommand = this.getBuilderCommand(description, command.getBuilderName());
        if (oldBuilderCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = command;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldBuilderCommand) {
                    oldCommands[i] = command;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        this.getProject().setDescription(description, null);
    }
}

