/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Collection;
import java.util.Iterator;

public abstract class CollectionUtils {
    public static boolean hasUniqueObject(Collection coll) {
        if (coll.isEmpty()) {
            return false;
        }
        Object candidate = null;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            if (candidate == null) {
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static Object findValueOfType(Collection coll, Class type) throws IllegalArgumentException {
        Object value = null;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!type.isInstance(obj)) continue;
            if (value != null) {
                throw new IllegalArgumentException("More than one value of type [" + type.getName() + "] found");
            }
            value = obj;
        }
        return value;
    }

    public static Object findValueOfType(Collection coll, Class[] types) throws IllegalArgumentException {
        for (int i = 0; i < types.length; ++i) {
            Object value = CollectionUtils.findValueOfType(coll, types[i]);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

