/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /cvstc/transcode/libioaux/framecode.c,v 1.7 2004/10/17 23:01:08 jacob Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)


#define yywrap() 1
#define YY_SKIP_YYWRAP
typedef char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef yyconst struct yy_trans_info *yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 9
#define YY_END_OF_BUFFER 10
struct yy_trans_info
	{
	short yy_verify;
	short yy_nxt;
	};
static yyconst struct yy_trans_info yy_transition[936] =
    {
 {   0,   0 }, {   0, 808 }, {   0,   2 }, {   0, 806 }, {   1, 260 },
 {   2, 260 }, {   3, 260 }, {   4, 260 }, {   5, 260 }, {   6, 260 },
 {   7, 260 }, {   8, 260 }, {   9, 262 }, {  10, 264 }, {  11, 260 },
 {  12, 260 }, {  13, 260 }, {  14, 260 }, {  15, 260 }, {  16, 260 },
 {  17, 260 }, {  18, 260 }, {  19, 260 }, {  20, 260 }, {  21, 260 },
 {  22, 260 }, {  23, 260 }, {  24, 260 }, {  25, 260 }, {  26, 260 },
 {  27, 260 }, {  28, 260 }, {  29, 260 }, {  30, 260 }, {  31, 260 },
 {  32, 262 }, {  33, 260 }, {  34, 260 }, {  35, 260 }, {  36, 260 },
 {  37, 260 }, {  38, 260 }, {  39, 260 }, {  40, 260 }, {  41, 260 },
 {  42, 260 }, {  43, 260 }, {  44, 260 }, {  45, 266 }, {  46, 268 },

 {  47, 278 }, {  48, 290 }, {  49, 290 }, {  50, 290 }, {  51, 290 },
 {  52, 290 }, {  53, 290 }, {  54, 290 }, {  55, 290 }, {  56, 290 },
 {  57, 290 }, {  58, 303 }, {  59, 260 }, {  60, 260 }, {  61, 260 },
 {  62, 260 }, {  63, 260 }, {  64, 260 }, {  65, 260 }, {  66, 260 },
 {  67, 260 }, {  68, 260 }, {  69, 260 }, {  70, 260 }, {  71, 260 },
 {  72, 260 }, {  73, 260 }, {  74, 260 }, {  75, 260 }, {  76, 260 },
 {  77, 260 }, {  78, 260 }, {  79, 260 }, {  80, 260 }, {  81, 260 },
 {  82, 260 }, {  83, 260 }, {  84, 260 }, {  85, 260 }, {  86, 260 },
 {  87, 260 }, {  88, 260 }, {  89, 260 }, {  90, 260 }, {  91, 260 },
 {  92, 260 }, {  93, 260 }, {  94, 260 }, {  95, 260 }, {  96, 260 },

 {  97, 260 }, {  98, 260 }, {  99, 260 }, { 100, 260 }, { 101, 260 },
 { 102, 260 }, { 103, 260 }, { 104, 260 }, { 105, 260 }, { 106, 260 },
 { 107, 260 }, { 108, 260 }, { 109, 260 }, { 110, 260 }, { 111, 260 },
 { 112, 260 }, { 113, 260 }, { 114, 260 }, { 115, 260 }, { 116, 260 },
 { 117, 260 }, { 118, 260 }, { 119, 260 }, { 120, 260 }, { 121, 260 },
 { 122, 260 }, { 123, 260 }, { 124, 260 }, { 125, 260 }, { 126, 260 },
 { 127, 260 }, { 128, 260 }, {   0,   2 }, {   0, 676 }, {   1, 130 },
 {   2, 130 }, {   3, 130 }, {   4, 130 }, {   5, 130 }, {   6, 130 },
 {   7, 130 }, {   8, 130 }, {   9, 132 }, {  10, 134 }, {  11, 130 },
 {  12, 130 }, {  13, 130 }, {  14, 130 }, {  15, 130 }, {  16, 130 },

 {  17, 130 }, {  18, 130 }, {  19, 130 }, {  20, 130 }, {  21, 130 },
 {  22, 130 }, {  23, 130 }, {  24, 130 }, {  25, 130 }, {  26, 130 },
 {  27, 130 }, {  28, 130 }, {  29, 130 }, {  30, 130 }, {  31, 130 },
 {  32, 132 }, {  33, 130 }, {  34, 130 }, {  35, 130 }, {  36, 130 },
 {  37, 130 }, {  38, 130 }, {  39, 130 }, {  40, 130 }, {  41, 130 },
 {  42, 130 }, {  43, 130 }, {  44, 130 }, {  45, 136 }, {  46, 138 },
 {  47, 148 }, {  48, 160 }, {  49, 160 }, {  50, 160 }, {  51, 160 },
 {  52, 160 }, {  53, 160 }, {  54, 160 }, {  55, 160 }, {  56, 160 },
 {  57, 160 }, {  58, 173 }, {  59, 130 }, {  60, 130 }, {  61, 130 },
 {  62, 130 }, {  63, 130 }, {  64, 130 }, {  65, 130 }, {  66, 130 },

 {  67, 130 }, {  68, 130 }, {  69, 130 }, {  70, 130 }, {  71, 130 },
 {  72, 130 }, {  73, 130 }, {  74, 130 }, {  75, 130 }, {  76, 130 },
 {  77, 130 }, {  78, 130 }, {  79, 130 }, {  80, 130 }, {  81, 130 },
 {  82, 130 }, {  83, 130 }, {  84, 130 }, {  85, 130 }, {  86, 130 },
 {  87, 130 }, {  88, 130 }, {  89, 130 }, {  90, 130 }, {  91, 130 },
 {  92, 130 }, {  93, 130 }, {  94, 130 }, {  95, 130 }, {  96, 130 },
 {  97, 130 }, {  98, 130 }, {  99, 130 }, { 100, 130 }, { 101, 130 },
 { 102, 130 }, { 103, 130 }, { 104, 130 }, { 105, 130 }, { 106, 130 },
 { 107, 130 }, { 108, 130 }, { 109, 130 }, { 110, 130 }, { 111, 130 },
 { 112, 130 }, { 113, 130 }, { 114, 130 }, { 115, 130 }, { 116, 130 },

 { 117, 130 }, { 118, 130 }, { 119, 130 }, { 120, 130 }, { 121, 130 },
 { 122, 130 }, { 123, 130 }, { 124, 130 }, { 125, 130 }, { 126, 130 },
 { 127, 130 }, { 128, 130 }, {   0,   8 }, {   0, 546 }, {   0,   1 },
 {   0, 544 }, {   0,   1 }, {   0, 542 }, {   0,   7 }, {   0, 540 },
 {   0,   2 }, {   0, 538 }, {   0,   0 }, {   0,   0 }, {   9,  14 },
 {  10,  14 }, {   9,  12 }, {  10,  12 }, {   0,   1 }, {   0, 530 },
 {   0,   3 }, {   0, 528 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   2 }, {   0, 516 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  32,  14 }, {   0,   0 }, {  32,  12 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   4 }, {   0, 503 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  32,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   2 }, {   0, 492 }, {   0,   0 }, {  48,  46 },
 {  49,  46 }, {  50,  46 }, {  51,  46 }, {  52,  46 }, {  53,  46 },
 {  54,  46 }, {  55,  46 }, {  56,  46 }, {  57,  46 }, {  48,  95 },
 {  49,  95 }, {  50,  95 }, {  51,  95 }, {  52,  95 }, {  53,  95 },
 {  54,  95 }, {  55,  95 }, {  56,  95 }, {  57,  95 }, {  46,  93 },
 {   0,   0 }, {  48, 105 }, {  49, 105 }, {  50, 105 }, {  51, 105 },
 {  52, 105 }, {  53, 105 }, {  54, 105 }, {  55, 105 }, {  56, 105 },

 {  57, 105 }, {  58, 118 }, {  46,  80 }, {   0,   0 }, {  48, 165 },
 {  49, 165 }, {  50, 165 }, {  51, 165 }, {  52, 165 }, {  53, 165 },
 {  54, 165 }, {  55, 165 }, {  56, 165 }, {  57, 165 }, {  58, 178 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   3 }, {   0, 433 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   4 }, {   0, 423 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   2 }, {   0, 411 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   5 }, {   0, 398 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  48, 108 },
 {  49, 108 }, {  50, 108 }, {  51, 108 }, {  52, 108 }, {  53, 108 },
 {  54, 108 }, {  55, 108 }, {  56, 108 }, {  57, 108 }, {  46, -12 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },

 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,  13 }, {  46,  93 }, {   0,   0 }, {  48, 105 },
 {  49, 105 }, {  50, 105 }, {  51, 105 }, {  52, 105 }, {  53, 105 },
 {  54, 105 }, {  55, 105 }, {  56, 105 }, {  57, 105 }, {  58, 165 },
 {   0,   4 }, {   0, 338 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   5 }, {   0, 325 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   4 }, {   0, 315 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   5 }, {   0, 305 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   5 }, {   0, 293 }, {  46, -85 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,  13 },
 {  46,  20 }, {   0,   0 }, {  48, 104 }, {  49, 104 }, {  50, 104 },
 {  51, 104 }, {  52, 104 }, {  53, 104 }, {  54, 104 }, {  55, 104 },
 {  56, 104 }, {  57, 104 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },

 {  56,   0 }, {  57,   0 }, {  48,  94 }, {  49,  94 }, {  50,  94 },
 {  51,  94 }, {  52,  94 }, {  53,  94 }, {  54,  94 }, {  55,  94 },
 {  56,  94 }, {  57,  94 }, {  46, -12 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,  60 },
 {   0,   6 }, {   0, 233 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   5 }, {   0, 221 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   5 }, {   0, 211 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   6 }, {   0, 201 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   6 },
 {   0, 189 }, {   0,   0 }, {  46,  32 }, {   0,   0 }, {  48,  44 },
 {  49,  44 }, {  50,  44 }, {  51,  44 }, {  52,  44 }, {  53,  44 },
 {  54,  44 }, {  55,  44 }, {  56,  44 }, {  57,  44 }, {  46, -84 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },

 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  48,  71 }, {  49,  71 }, {  50,  71 }, {  51,  71 },
 {  52,  71 }, {  53,  71 }, {  54,  71 }, {  55,  71 }, {  56,  71 },
 {  57,  71 }, {  46, -12 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   6 }, {   0, 130 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 129,  10 }, {   1,   0 },
    };

static yyconst struct yy_trans_info *yy_start_state_list[3] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[133],
    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#define INITIAL 0
/*
 * framecode.l
 * framecode token scanner
 * Copyright (c) 2002 Chris C. Hoover
 * cchoover@charter.net
 *
 * Note: Please do NOT modify framecode.c directly, make changes to framecode.l
 * instead and regenerate framecode.c with
 *   flex -oframecode.c -L -CF framecode.l
 */

#include "framecode.h"

#define YY_DECL int yylex YY_PROTO((struct fc_time *fc_list, int *fc_to, int fc_verb))


int
parse_fc_time_string( char * string, double fps, char *separator, 
                      int fc_verb, struct fc_time **fc_list)
{
  struct fc_time * time;
  int fc_to = 0;
  char * hold;

  yy_scan_string( "" );
  hold = strtok( string, separator);

  while( hold != NULL ) {
    yy_scan_string( hold );

    if( ( time = new_fc_time( ) ) == NULL )
      return -1;

    time->sh    = 0;
    time->sm    = 0;
    time->ss    = 0;
    time->sf    = 0;
    time->stf   = 0;
    time->eh    = 0;
    time->em    = 0;
    time->es    = 0;
    time->ef    = 0;
    time->etf   = 0;
    time->stepf = 1;
    time->vob_offset = 0;
    time->next  = NULL;

    time->fps = fps;

    if( *fc_list == NULL )
      *fc_list = time;

    else if( append_fc_time( *fc_list, time ) == -1 )
      return -1;

    if( yylex( *fc_list, &fc_to, fc_verb ) < 0 ) {
      printf( "[%s:%d]syntax error\n", __FILE__, __LINE__ );
      return -1;
    }

    hold = strtok( NULL, separator);
  }

  return 0;
}

int fc_frame_in_time( struct fc_time * list, unsigned int frame ) 
{
    while (list) {
	if (list->stf <= frame && frame < list->etf)
	    return list->stepf;
	else 
	    list = list->next;
    }

    return 0;

}

void
fc_set_start_time( struct fc_time * time, unsigned int frames )
{
  struct fc_time * next;

  if( time != NULL ) {
    time->sh = 0;
    time->sm = 0;
    time->ss = 0;
    time->sf = frames;
    time->stf = 0;
    time->stepf = 1;
    next = time->next;
    time->next = NULL;
    fc_time_normalize( time, 0 );
    time->next = next;
  }
}

void
fc_time_normalize( struct fc_time * list, int fc_verb )
{
  unsigned int th, tm, ts, tf;
  double t;

  while( list != NULL ) {
    // avoid fpu error
    if( list->fps == 0.0 )
      list->fps = 1.0;
    /*
     * start time
     */
    if( list->sf >= list->fps ) {
      list->ss += list->sf / list->fps;
      t = list->fps * (int)( list->sf / list->fps );
      list->sf -= (int)(t+.5);
    }

    if( list->ss >= 60  ) {
      list->sm += list->ss / 60;
      t = 60.0 * (int)(list->ss / 60);
      list->ss -= (int)(t+.5);
    }

    if( list->sm >= 60  ) {
      list->sh += list->sm / 60;
      t = 60.0 * (int)(list->sm / 60);
      list->sm -= (int)(t+.5);
    }

    t = list->sh * 3600.0 * list->fps + 
                list->sm *   60.0 * list->fps + 
		            list->ss * list->fps        + 
			          list->sf;
    list->stf = (int)(t+.5);
    /*
     * end time
     */
    if( list->ef >= list->fps ) {
      list->es += list->ef / list->fps;
      t = list->fps * (int)( list->ef / list->fps );
      list->ef -= (int)(t+.5);
    }

    if( list->es >= 60  ) {
      list->em += list->es / 60;
      t = 60.0 * (int)(list->es / 60);
      list->es -= (int)(t+.5);
    }

    if( list->em >= 60  ) {
      list->eh += list->em / 60;
      t = 60.0 * (int)(list->em / 60);
      list->em -= (int)(t+.5);
    }

    t = list->eh * 3600.0 * list->fps + 
                list->em *   60.0 * list->fps + 
		            list->es * list->fps        + 
			          list->ef;
    list->etf = (int)(t+.5);
                
    /*
     * swap values if required
     */
    if( list->stf > list->etf ) {
      th = list->sh;
      tm = list->sm;
      ts = list->ss;
      tf = list->sf;
      list->sh = list->eh;
      list->sm = list->em;
      list->ss = list->es;
      list->sf = list->ef;
      list->eh = th;
      list->em = tm;
      list->es = ts;
      list->ef = tf;
      tf = list->stf;
      list->stf = list->etf;
      list->etf = tf;

      if( fc_verb )
        printf( "reverse\n" );
    }

    list = list->next;
  }
}

struct fc_time *
new_fc_time( )
{
  struct fc_time * time = NULL;

  if( ( time = (struct fc_time *)malloc( sizeof( struct fc_time ) ) ) == NULL ) {
    printf( "[%s:%d] malloc failure\n", __FILE__, __LINE__ );
    return NULL;
  }

  return time;
}

void
free_fc_time( struct fc_time * time )
{
  struct fc_time * temp;

  while( time != NULL ) {
    temp = time->next;
    free( time );
    time = temp;
  }
}

struct fc_time *
tail_fc_time( struct fc_time * tlist )
{
  struct fc_time * temp = tlist;

  while( temp != NULL && temp->next != NULL )
    temp = temp->next;

  return temp;
}

int
append_fc_time( struct fc_time * list, struct fc_time * time )
{
  struct fc_time * temp;
  int result = -1;

  if( list != NULL && ( temp = tail_fc_time( list ) ) != NULL ) {
    temp->next = time;
    result = 0;
  }

  return result;
}


/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#define YY_NO_UNPUT

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;




	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yy_start];
yy_match:
		{
		register yyconst struct yy_trans_info *yy_trans_info;

		register YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[(unsigned int) yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
YY_RULE_SETUP
/* eat up whitespace */
	YY_BREAK
case 2:
YY_RULE_SETUP
{

  if( *yytext == '.' )
    yytext++;

  if( fc_verb )
    printf( "%d frames ", atoi( yytext ) );

  if( *fc_to ) {
    tail_fc_time( fc_list )->ef = (unsigned)atoi( yytext );
  } 
  else {
    tail_fc_time( fc_list )->sf = (unsigned)atoi( yytext );
  }
}
	YY_BREAK
case 3:
YY_RULE_SETUP
{

  if( *yytext == '/' )
    yytext++;

    if( fc_verb )
      printf( "stepwidth %d ", atoi( yytext ) );

    tail_fc_time( fc_list )->stepf = (unsigned)atoi( yytext );
}
	YY_BREAK
case 4:
YY_RULE_SETUP
{

  if( *yytext == ':' )
    yytext++;

  if( index( yytext, '.' ) == NULL ) {
    if( fc_verb )
      printf( "%d seconds ", atoi( yytext ) );

    if( *fc_to )
 	    tail_fc_time( fc_list )->es = (unsigned)atoi( yytext );

    else
 	    tail_fc_time( fc_list )->ss = (unsigned)atoi( yytext );
  }

  else {
    if( fc_verb )
      printf( "%d seconds and %d frames ", atoi( yytext ), atoi( index( yytext, '.' ) + 1 ) );

    if( *fc_to ) {
 	    tail_fc_time( fc_list )->es = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->ef = (unsigned)atoi( index( yytext, '.' ) + 1 );
    }
    else {
 	    tail_fc_time( fc_list )->ss = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->sf = (unsigned)atoi( index( yytext, '.' ) + 1 );
    }
  }
}
	YY_BREAK
case 5:
YY_RULE_SETUP
{

  if( *yytext == ':' )
    yytext++;

  if( index( yytext, '.' ) == NULL ) {
    if( fc_verb )
      printf( "%d minutes and %d seconds ", atoi( yytext ), atoi( index( yytext, ':' ) + 1 ) );

    if( *fc_to ) {
 	    tail_fc_time( fc_list )->em = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->es = (unsigned)atoi( index( yytext, ':' ) + 1 );
    }

    else {
 	    tail_fc_time( fc_list )->sm = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->ss = (unsigned)atoi( index( yytext, ':' ) + 1 );
    }
  }

  else {
    if( fc_verb )
      printf( "%d minutes, %d seconds and %d frames ", atoi( yytext ), atoi( index( yytext, ':' ) + 1 ), atoi( index( yytext, '.' ) + 1 ) );

    if( *fc_to ) {
 	    tail_fc_time( fc_list )->em = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->es = (unsigned)atoi( index( yytext, ':' ) + 1 );
      tail_fc_time( fc_list )->ef = (unsigned)atoi( index( yytext, '.' ) + 1 );
    }
    else {
 	    tail_fc_time( fc_list )->sm = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->ss = (unsigned)atoi( index( yytext, ':' ) + 1 );
      tail_fc_time( fc_list )->sf = (unsigned)atoi( index( yytext, '.' ) + 1 );
    }
  }
}
	YY_BREAK
case 6:
YY_RULE_SETUP
{

  if( index( yytext, '.' ) == NULL ) {
    if( fc_verb )
      printf( "%d hours, %d minutes and %d seconds ", atoi( yytext ), atoi( index( yytext, ':' ) + 1 ), atoi( rindex( yytext, ':' ) + 1 ) );

    if( *fc_to ) {
 	    tail_fc_time( fc_list )->eh = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->em = (unsigned)atoi( index( yytext, ':' ) + 1 );
      tail_fc_time( fc_list )->es = (unsigned)atoi( rindex( yytext, ':' ) + 1 );
    }
    else {
 	    tail_fc_time( fc_list )->sh = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->sm = (unsigned)atoi( index( yytext, ':' ) + 1 );
      tail_fc_time( fc_list )->ss = (unsigned)atoi( rindex( yytext, ':' ) + 1 );
    }
  }

  else {
    if( fc_verb )
      printf( "%d hours, %d minutes, %d seconds and %d frames ", atoi( yytext ), atoi( index( yytext, ':' ) + 1 ), atoi( rindex( yytext, ':' ) + 1 ), atoi( index( yytext, '.' ) + 1 ) );

    if( *fc_to ) {
 	    tail_fc_time( fc_list )->eh = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->em = (unsigned)atoi( index( yytext, ':' ) + 1 );
      tail_fc_time( fc_list )->es = (unsigned)atoi( rindex( yytext, ':' ) + 1 );
      tail_fc_time( fc_list )->ef = (unsigned)atoi( index( yytext, '.' ) + 1 );
    }
    else {
 	    tail_fc_time( fc_list )->sh = (unsigned)atoi( yytext );
 	    tail_fc_time( fc_list )->sm = (unsigned)atoi( index( yytext, ':' ) + 1 );
      tail_fc_time( fc_list )->ss = (unsigned)atoi( rindex( yytext, ':' ) + 1 );
      tail_fc_time( fc_list )->sf = (unsigned)atoi( index( yytext, '.' ) + 1 );
    }
  }
}
	YY_BREAK
case 7:
YY_RULE_SETUP
{

  if( *fc_to == 1 ) {
    if( fc_verb )
      printf( "\n[%s:%d] too to\n", __FILE__, __LINE__ );
    return -1;
  }

  *fc_to = 1;

  if( fc_verb )
    printf( "to " ); 
}
	YY_BREAK
case 8:
YY_RULE_SETUP
{

  if( fc_verb )
    printf( "\n[%s:%d] Unrecognized character: %s\n", __FILE__, __LINE__, yytext );

  return -1;
}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
{

  fc_time_normalize( tail_fc_time( fc_list ), fc_verb );
  *fc_to = 0;

  if( fc_verb )
    printf( "\n" );

  yyterminate();
}
	YY_BREAK
case 9:
YY_RULE_SETUP
ECHO;
	YY_BREAK

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start_state_list[yy_start];

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 128)].yy_nxt;
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;

	register int yy_c = 128;
	register yyconst struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;


	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif


