#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "interface.h"

#include "treedata.h"

char *shortname(s)
char *s;
{
	char *sn;
	if((sn=(char *)rindex(s, '/'))==NULL)
		sn=s;
	else
		sn++;
	return(sn);
}

typed_shortname(s, t, buf)
char *s;
file_type t;
char *buf;
{
	strcpy(buf, shortname(s));
	switch(t)
	{
		case PICT:
			strcat(buf, ".PICT");
			break;
		case PostScript:
			strcat(buf, ".ps");
			break;
		case Prolog:
			strcat(buf, ".pl");
			break;
		case Newick:
			strcat(buf, ".newick");
			break;
		case List:
			strcat(buf, ".list");
			break;
		case Treetool:
		case NoFileType:
		default:
			break;
	}
}

longname(s, buf)
char *s;
char *buf;
{
	if(*s=='/')
		strcpy(buf, s);
	else
	{
		if(getwd(buf)!=NULL)
		{
			strcat(buf, "/");
			strcat(buf, s);
		}
		else
			strcpy(buf, "");
	}
}

int near_branch(b, x, y, p)
treebranch b;
int x, y;
double *p;
{
	double ax, ay, bx, by, cx, cy;
	double la, lb, lc, lbona;
	nodetypedata ud;
	nodetypedata dd;
	treetypedata td;
	double ux, uy, dx, dy;

	if(b->up==NULL)
		return(0);

	ud=ndta(b->up)->td;
	dd=ndta(b->down)->td;
	td=tdta(tree_get_tree(b))->td;
	ux=nodex(ud, td);
	uy=nodey(ud, td);
	dx=nodex(dd, td);
	dy=nodey(dd, td);
	switch(td->bt)
	{
		case FlowerBranch:
			ax=dx-ux;
			ay=dy-uy;
			bx=x-ux;
			by=y-uy;
			la=hypot(ax, ay);
			lb=hypot(bx, by);

			lbona=(ax*bx+ay*by)/la;
			*p=lbona/la;
			lc=lb*lb-lbona*lbona;
			if(lc<=BPICKDISTANCE*BPICKDISTANCE && *p>=0.0 && *p<=1.0)
				return(1);
			else
			{
				if(*p<0.0)
					*p=0.0;
				if(*p>1.0)
					*p=1.0;
				return(0);
			}
		case Midway:
		case RoomForGroup:
		case OnScreen:
			lc=y-dy;
			if(lc<0.0)
				lc=-lc;
			la=dx-ux;
			lb=x-ux;
			*p=lb/la;
			if(lc<=BPICKDISTANCE && *p>=0.0 && *p<=1.0)
				return(1);
			else
			{
				if(*p<0.0)
					*p=0.0;
				if(*p>1.0)
					*p=1.0;
				return(0);
			}
		default:
			return(0);
	}
}

void move_node_on_screen(n)
treenode n;
{
	nodetypedata nd;
	treetypedata td;
	int x, y;

	nd=ndta(n)->td;
	td=tdta(tree_get_tree(n))->td;
	x=nodex(nd, td);
	y=nodey(nd, td);
	tcanvas_move_point_on_screen(globals->c, x, y);
}

int move_on_screen(s, replace)
char *s;
int replace;
{
	treenode n;

	n=(treenode)first_selected_node();
	n=(treenode)search_all_trees_for_node(s, n);
	if(n==NULL)
	{
		tterr("Node not found", BeepMessage);
		return(0);
	}
	add_to_selection(n, NodeSel, !replace, 0.0);
	move_node_on_screen(n);
	return(1);
}

int move_all_on_screen(s, replace)
char *s;
int replace;
{
	treenode n, first;

	n=(treenode)first_selected_node();
	first=(treenode)search_all_trees_for_node(s, n);
	if(first==NULL)
	{
		tterr("Node not found", BeepMessage);
		return(0);
	}
	add_to_selection(first, NodeSel, !replace, 0.0);
	n=first;
	do {
		n=(treenode)search_all_trees_for_node(s, n);
		if(n!=first)
			add_to_selection(n, NodeSel, 1, 0.0);
	} while(n!=first);
			
	move_node_on_screen(n);
	return(1);
}

char *get_environment_value(s)
char *s;
{
	int i;
	int len;
	char *e, *c;

	len=strlen(s);

	for(i=0;globals->envp[i]!=NULL;i++)
	{
		c=s;
		e=globals->envp[i];
		while(*c!='\0' && *e!='\0')
			if(*c!=*e)
				break;
			else
			{
				c++;
				e++;
			}
		if(*c=='\0')
			/* may be match */
			if(*e=='=')
				return(++e);
	}
	return(NULL);
}
