/*
	image.c - generate XImage
	Author:	 Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

				 All Rights Reserved

*/

#include "xslideshow.h"

#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

extern void reduceColorNum P_((int, int));
extern void myevent P_(());
extern void myusleep P_((dword));
extern void goodbyekiss P_(());

static Pixel systemPixels[256];
/*
* Free window resources
*/
void FreeXImage()
{
	if(theImage){								/* theImage is created by XCreateImage() */
		if(theImage->data){						/* Use XFree. Not use XDestroyImage      */
			if((byte *)theImage->data != gim.subImageList->image) {
				XtFree((char *)(theImage->data));	/* Free image pixmap data */
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: FreeXImage() theImage->data\n");
				XtFree((char *)(gim.subImageList->image));		/* Free image pixmap data */
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: FreeXImage() gim.image\n");
			}
			else {
				XtFree((char *)(theImage->data));	/* Free image pixmap data */
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"xslideshow: FreeXImage() theImage->data\n");
			}
			gim.subImageList->image = (byte *)NULL;
		}
		XFree(theImage);						/* Free XImage structure                 */
		theImage = NULL;
	}
}

/*
* Allocate TrueColor.
*/
Boolean allocTrueColor()
{
Status result;
int i,j;
int r=0,g=0,b=0,xof,yof;
XGCValues gcv;
GC gc;
dword maxColorNum;
dword r_bits=0, g_bits=0, b_bits=0;
dword r_shift=0, g_shift=0, b_shift=0;
dword r_mask, g_mask, b_mask;
dword r_pmask, g_pmask, b_pmask;
dword r_pbits, g_pbits, b_pbits;
word wdata,*sptr;

	if(theDepth <= 16){
		r_pmask = r_mask = gim.visual.red_mask;
		g_pmask = g_mask = gim.visual.green_mask;
		b_pmask = b_mask = gim.visual.blue_mask;
		maxColorNum = 1 << theDepth;
	}
	else {  /* Use max 5x6x5 (65536) color for TrueColor 24 bit image */
		r_pmask = r_mask = R_MASK565;
		g_pmask = g_mask = G_MASK565;
		b_pmask = b_mask = B_MASK565;
		maxColorNum = MAX_COLOR_24_565;
	}

	do { if(r_mask & 1) break; r_mask >>= 1; r_bits++;}while(r_mask); r_pbits=r_mask;
	do { if(r_mask & 0x8000) break; r_mask <<= 1; r_shift++;}while(r_mask);
	do { if(g_mask & 1) break; g_mask >>= 1; g_bits++;}while(g_mask); g_pbits=g_mask;
	do { if(g_mask & 0x8000) break; g_mask <<= 1; g_shift++;}while(g_mask);
	do { if(b_mask & 1) break; b_mask >>= 1; b_bits++;}while(b_mask); b_pbits=b_mask;
	do { if(b_mask & 0x8000) break; b_mask <<= 1; b_shift++;}while(b_mask);

	xof = (windowWidth  - (256 + 256 / 2 )) / 2;
	yof = (windowHeight - (256 + 256 / 2 )) / 2;

	sptr = (word *)gim.subImageList->image;
	for(j = 0; j < gim.subImageList->height; j++) {
		for(i = 0; i < gim.subImageList->width; i++) {
			wdata = *sptr++;
			if(gim.pTrueColorIdx[wdata])
				continue;

			xcolors[0].red	 = (((wdata & r_pmask) << (r_shift - r_bits)) >> 8) * 257;
			xcolors[0].green = (((wdata & g_pmask) << (g_shift - g_bits)) >> 8) * 257;
			xcolors[0].blue  = (((wdata & b_pmask) << (b_shift - b_bits)) >> 8) * 257;
			xcolors[0].flags = DoRed | DoGreen | DoBlue;

			/* Allocating Shared Read-only Colors */
			result = XAllocColor(theDisp, theCmap, &xcolors[0]);
			if(result == 0) {
				if(app_data.verbose)
					fprintf(stderr,"xslideshow: Can't allocate color. force 8 bit mode.\n");
				return(False);
			}

			gim.pTrueColor[wdata] = xcolors[0].pixel;
			gim.pTrueColorIdx[wdata] = 1;

			if(app_data.verbose){
				b = ((wdata & b_pmask) >> b_bits) * 256 / b_pbits;	/* X axis */
				g = ((wdata & g_pmask) >> g_bits) * 256 / g_pbits;	/* Y axis */
				r = ((wdata & r_pmask) >> r_bits) * 128 / r_pbits;	/* Z axis */

				gcv.function = GXcopy;
				gcv.foreground = gim.pTrueColor[wdata];
				gc = XCreateGC(theDisp,theWindow,GCForeground | GCFunction,&gcv);
				XDrawPoint(theDisp, theWindow, gc, b + r + xof, g + r + yof);
				XFreeGC(theDisp,gc);
			}
		}
		myevent();
	}

	return(True);
}
/*
* Allocate more than 256 color for TrueColor Display if perfect is defined.
*/
Boolean initTrueColor()
{
dword maxColorNum;
dword r_mask, g_mask, b_mask;
dword r_pmask, g_pmask, b_pmask;
#if False
int i;
Status result;
word wdata;
dword r_bits=0, g_bits=0, b_bits=0;
dword r_shift=0, g_shift=0, b_shift=0;
dword r_pbits, g_pbits, b_pbits;
int r=0,g=0,b=0,xof,yof;
XGCValues gcv;
GC gc;
#endif

	if(theDepth <= 16){
		r_pmask = r_mask = gim.visual.red_mask;
		g_pmask = g_mask = gim.visual.green_mask;
		b_pmask = b_mask = gim.visual.blue_mask;
		maxColorNum = 1 << theDepth;
	}
	else {  /* Use max 5x6x5 (65536) color for TrueColor 24 bit image */
		r_pmask = r_mask = R_MASK565;
		g_pmask = g_mask = G_MASK565;
		b_pmask = b_mask = B_MASK565;
		maxColorNum = MAX_COLOR_24_565;
	}

	if(app_data.verbose && app_data.debug){
		fprintf(stderr,"maxColorNum = %d\n",(int)maxColorNum);
	}

	gim.pTrueColorIdx = (short *)XtCalloc(maxColorNum, sizeof(short));
	if(gim.pTrueColorIdx == (short *)NULL) {
		fprintf(stderr,"xslideshow: memory allocation error\n");
		goodbyekiss();
	}

	gim.pTrueColor = (dword *)XtMalloc(sizeof(dword) * maxColorNum);
	if(gim.pTrueColor == (dword *)NULL) {
		fprintf(stderr,"xslideshow: memory allocation error\n");
		goodbyekiss();
	}

	/* Return here !!! */
	return(True);

#if False
	do { if(r_mask & 1) break; r_mask >>= 1; r_bits++;}while(r_mask); r_pbits=r_mask;
	do { if(r_mask & 0x8000) break; r_mask <<= 1; r_shift++;}while(r_mask);
	do { if(g_mask & 1) break; g_mask >>= 1; g_bits++;}while(g_mask); g_pbits=g_mask;
	do { if(g_mask & 0x8000) break; g_mask <<= 1; g_shift++;}while(g_mask);
	do { if(b_mask & 1) break; b_mask >>= 1; b_bits++;}while(b_mask); b_pbits=b_mask;
	do { if(b_mask & 0x8000) break; b_mask <<= 1; b_shift++;}while(b_mask);

	xof = (windowWidth  - (256 + 256 / 2 )) / 2;
	yof = (windowHeight - (256 + 256 / 2 )) / 2;

	for(i=0, wdata=0; i<(int)maxColorNum; i++,wdata++){
		xcolors[0].red	 = (((wdata & r_pmask) << (r_shift - r_bits)) >> 8) * 257;
		xcolors[0].green = (((wdata & g_pmask) << (g_shift - g_bits)) >> 8) * 257;
		xcolors[0].blue  = (((wdata & b_pmask) << (b_shift - b_bits)) >> 8) * 257;
		xcolors[0].flags = DoRed | DoGreen | DoBlue;

		/* Allocating Shared Read-only Colors */
		result = XAllocColor(theDisp, theCmap, &xcolors[0]);
		if(result == 0) {
			if(app_data.verbose)
				fprintf(stderr,"xslideshow: Can't allocate color. force 8 bit mode.\n");
			return(False);
		}
		gim.pTrueColor[i] = xcolors[0].pixel;
		gim.pTrueColorIdx[i] = 1;

		b = ((wdata & b_pmask) >> b_bits) * 256 / b_pbits;	/* X axis */
		g = ((wdata & g_pmask) >> g_bits) * 256 / g_pbits;	/* Y axis */
		r = ((wdata & r_pmask) >> r_bits) * 128 / r_pbits;	/* Z axis */

		gcv.function = GXcopy;
		gcv.foreground = gim.pTrueColor[i];
		gc = XCreateGC(theDisp,theWindow,GCForeground | GCFunction,&gcv);
		XDrawPoint(theDisp, theWindow, gc, b + r + xof, g + r + yof);
		XFreeGC(theDisp,gc);

		myevent();
	}

	return(True);
#endif
}


/*
* This function must be called when TrueColor and depth > 8
* I don't know if there is TrueColor and depth <= 8 machine.
*/
ErrStatus CreateTrueColorImage()
{
Status result;
int i,j, psize;
byte *sptr,*dptr, *tmpptr;
word *wdptr;
dword *ulDptr, pixel;
word *usDptr, wpixel;

	if(gim.subImageList->bits_per_pixel == 8){ 

		/* Eatch pixel is an index to the 256 colormap */
		/* Create the TrueColor 256 colormap table     */

		for(i = 0; i < gim.subImageList->mapsize; i++){
			xcolors[i].red	 = gim.subImageList->red[i]   * 257;
			xcolors[i].green = gim.subImageList->green[i] * 257;
			xcolors[i].blue  = gim.subImageList->blue[i]  * 257;
			xcolors[i].flags = DoRed | DoGreen | DoBlue;

			/* Allocating Shared Read-only Colors */
			result = XAllocColor(theDisp, theCmap, &xcolors[i]);
			if(result == 0) {
				if(app_data.verbose)
					fprintf(stderr,"Can't allocate color\n");
				return(ERR_IMAGE);
			}

			myevent();
		}

	}
	else{
		(void)allocTrueColor();
	}

	bcol = dbcol; /* default black pixel */
	wcol = dwcol; /* default white pixel */

	if(gim.pmf.bits_per_pixel > 16)
		psize =  sizeof(dword);
	else if(gim.pmf.bits_per_pixel > 8)
		psize =  sizeof(word);
	else /* never reached here */
		psize =  sizeof(byte);

	/* make the TrueColor image */
	sptr = gim.subImageList->image;
	dptr = (byte *)XtMalloc(gim.subImageList->width * gim.subImageList->height * psize);
	if(dptr == (byte *)NULL){
		fprintf(stderr,"xslideshow: memory allocation error\n");
		goodbyekiss();
	}
	tmpptr = dptr;


	if(ImageByteOrder(theDisp) == MSBFirst) {

		/* BIG Endean
			dword ul = 0x01234567;
			bit 31----23----15---- 7---- 0
				   01    23    45    67
				   red  green  blue
		*/

		if(gim.subImageList->bits_per_pixel == 8){

			/* Eatch pixel is an index to the 256 colormap */
			if(gim.pmf.bits_per_pixel > 16) {
				ulDptr = (dword *)dptr;
				for(j = 0; j < gim.subImageList->height; j++) {
					for(i = 0; i < gim.subImageList->width; i++, sptr++) {
						*ulDptr++ = xcolors[*sptr].pixel;
					}
					myevent();
				}
			}
			else {
				usDptr = (word *)dptr;
				for(j = 0; j < gim.subImageList->height; j++) {
					for(i = 0; i < gim.subImageList->width; i++, sptr++) {
						*usDptr++ = (word)(xcolors[*sptr].pixel);
					}
					myevent();
				}
			}
		}

		else {

			/* Eatch pixel is an index to the direct colormap */
			if(gim.pmf.bits_per_pixel > 16) {
				ulDptr = (dword *)dptr;
				wdptr = (word *)sptr;
				for(j = 0; j < gim.subImageList->height; j++) {
					for(i = 0; i < gim.subImageList->width; i++) {
						*ulDptr++ = gim.pTrueColor[*wdptr++];
					}
					myevent();
				}
			}
			else {
				usDptr = (word *)dptr;
				wdptr = (word *)sptr;
				for(j = 0; j < gim.subImageList->height; j++) {
					for(i = 0; i < gim.subImageList->width; i++) {
						*usDptr++ = (word)(gim.pTrueColor[*wdptr++]);
					}
					myevent();
				}
			}
		}

	}

	else { /* if(ImageByteOrder(theDisp) == LSBFirst) { */
		/* Little Endean
			dword ul = 0x01234567;
			bit 31----23----15---- 7---- 0
				   67    45    23    01
				         blue green  red
		*/

		if(gim.subImageList->bits_per_pixel == 8){

			/* Eatch pixel is an index to the 256 colormap */
			if(gim.pmf.bits_per_pixel > 16) {
				for(j = 0; j < gim.subImageList->height; j++) {
					for(i = 0; i < gim.subImageList->width; i++, sptr++) {
						pixel = xcolors[*sptr].pixel;
						*dptr++ = (byte)((pixel)       & 0xff);	/* 01 red   */
						*dptr++ = (byte)((pixel >> 8)  & 0xff);	/* 23 green */
						*dptr++ = (byte)((pixel >> 16) & 0xff);	/* 45 blue  */
						*dptr++ = (byte)((pixel >> 24) & 0xff);	/* 67       */
					}
					myevent();
				}
			}
			else {
				for(j = 0; j < gim.subImageList->height; j++) {
					for(i = 0; i < gim.subImageList->width; i++, sptr++) {
						wpixel = (word)(xcolors[*sptr].pixel);
						*dptr++ = (byte)((wpixel)       & 0xff); /* 01 */
						*dptr++ = (byte)((wpixel >> 8)  & 0xff); /* 23 */
					}
					myevent();
				}
			}
		}

		else {

			/* Eatch pixel is an index to the direct colormap */
			wdptr = (word *)sptr;
			if(gim.pmf.bits_per_pixel > 16) {
				for(j = 0; j < gim.subImageList->height; j++) {
					for(i = 0; i < gim.subImageList->width; i++) {
						pixel = gim.pTrueColor[*wdptr++];
						*dptr++ = (byte)((pixel)       & 0xff);	/* 01 red   */
						*dptr++ = (byte)((pixel >> 8)  & 0xff);	/* 23 green */
						*dptr++ = (byte)((pixel >> 16) & 0xff);	/* 45 blue  */
						*dptr++ = (byte)((pixel >> 24) & 0xff);	/* 67       */
					}
					myevent();
				}
			}
			else {
				for(j = 0; j < gim.subImageList->height; j++) {
					for(i = 0; i < gim.subImageList->width; i++) {
						wpixel = (word)(gim.pTrueColor[*wdptr++]);
						*dptr++ = (byte)((wpixel)       & 0xff); /* 01 */
						*dptr++ = (byte)((wpixel >>  8) & 0xff); /* 23 */
					}
					myevent();
				}
			}
		}

	}

	XtFree((byte *)gim.subImageList->image);	/* Free old image */
	gim.subImageList->image = tmpptr; 

	/* Create the XImage */
	theImage = XCreateImage( theDisp,theVisual,
						DefaultDepth(theDisp,theScreenNumber),
						ZPixmap,0,
						(char *)gim.subImageList->image,
						(dword)gim.subImageList->width,
						(dword)gim.subImageList->height,
						gim.pmf.scanline_pad,
						(int)gim.subImageList->width * psize	);

	myevent();

	if(theImage)
		return(ERR_NO_ERR);
	else
		return(ERR_IMAGE);

}

/*
* Create XImage file.
*/
ErrStatus CreateXImage()
{
int i,j,imageUsingColorNum;
byte *sptr,*dptr;
Colormap sysCmap;

	if(app_data.color > 256) app_data.color = 256;

	/* Creates the TrueColor Image */
	if(theVisual->class == TrueColor){
		if(gim.subImageList->bits_per_pixel == 24){
			if(app_data.perfect)
				reduceColorNum(16, 65536);	/* 24bit->16bit max 65536 color image */
			else
				reduceColorNum(8, app_data.color); /* 24bit->8bit 256 color image */
		}
		else
			reduceColorNum(8, app_data.color); /* 24bit->8bit 256 color image */
		return( CreateTrueColorImage() );
	}

	/* Creates the PseudoColor Image */
	else {

		/* Frees previous picture's resources if they have */
		if(allocatedColorNum){		/* Frees allocated color cells for image using */
			XFreeColors(	theDisp,theCmap,
							pixels,
							allocatedColorNum,
							0L	);
			allocatedColorNum=0;	
		}

		if(allocatedSysColorNum) {	/* Frees allocated color cells for system using */
									/* (private colormap only)                      */
			XFreeColors(	theDisp,theCmap,
							&pixels[gim.visual.map_entries - allocatedSysColorNum],
							allocatedSysColorNum,
							0L	);
			allocatedSysColorNum = 0;
		}


		/* Allocates read/write color cells */
		for(	allocatedColorNum = 0;
				allocatedColorNum < theVisual->map_entries;
				allocatedColorNum++	){

			if( ! XAllocColorCells(	theDisp,
									theCmap,
									False,
									NULL,
									0,
									&(pixels[allocatedColorNum]),
									1)	)
				break;

			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"%d ",(int)pixels[allocatedColorNum]);

			myevent();

		}
		if(app_data.verbose && app_data.debug) fprintf(stderr,"\n");


		/* Who want to see such a poor color image ? */
		if(allocatedColorNum<2 || app_data.color<2) {
			if(allocatedColorNum > 0){
				XFreeColors(	theDisp,theCmap,
								pixels,
								allocatedColorNum,
								0L	);
				allocatedColorNum=0;	
			}
			return(ERR_COLOR);
		}

		if(app_data.verbose && app_data.debug)
			fprintf(stderr,"allocatedColorNum = %d\n",allocatedColorNum);



		/* Set the usable color numbers for image using */
		imageUsingColorNum = (app_data.color < allocatedColorNum) ?
									app_data.color : allocatedColorNum;

		/* Guarantees the system's white pixel and black pixel at least */
		if(imageUsingColorNum > (gim.visual.map_entries - 2) ) {
			imageUsingColorNum = gim.visual.map_entries - 2;
		}

		/* Reduces the color numbers */
		reduceColorNum(8,imageUsingColorNum);

		/* Set the real color numbers for image using */
		imageUsingColorNum = gim.subImageList->mapsize;


		/* Creates the private colormap */
		if(app_data.privateCmap){

			/* Some X server has less than 256 map entries */
			gim.visual.map_entries = allocatedColorNum ; /* Set real map entries */

			/* Set allocated color numbers for image using */
			allocatedColorNum = imageUsingColorNum;

			/* Set allocated color numbers for system using */
			allocatedSysColorNum = gim.visual.map_entries - imageUsingColorNum;

			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"xslideshow: image color num = %d, system color num = %d\n",
								imageUsingColorNum,allocatedSysColorNum);


			/* Saves the system using pixels */
			for(i = 0; i < allocatedSysColorNum; i++){
				systemPixels[i] = pixels[i];
			}


			/* Shift the image using color cells to the top of the pixel array.  */
			/*                                                                   */
			/* The image uses the pixel which number is 0 to imageUsingColorNum. */
			/* The system uses the pixel which number is imageUsingColorNum+1 to */
			/* imageUsingColorNum+allocatedSysColorNum.                          */

			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"image using pixels\n");
			for(i = 0; i < imageUsingColorNum; i++){
				pixels[i] = pixels[allocatedSysColorNum + i];
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"%d ",(int)pixels[i]);
			}
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"\n");

			/* Set the system using pixel value */
			for(i = 0; i < allocatedSysColorNum; i++)
				xcolors[imageUsingColorNum + i].pixel = systemPixels[i];

			/* Gets the system using color info */
			sysCmap = DefaultColormap(theDisp, DefaultScreen(theDisp));
			XQueryColors(	theDisp,sysCmap,
							&xcolors[imageUsingColorNum],
							allocatedSysColorNum	);

			/* Set the system using colors */
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"system using pixels\n");
			for(i = 0; i < allocatedSysColorNum; i++){
				pixels[imageUsingColorNum + i] = xcolors[imageUsingColorNum + i].pixel;
				if(app_data.verbose && app_data.debug)
					fprintf(stderr,"%d ",(int)pixels[imageUsingColorNum + i]);
			}
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"\n");

			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"imageUsingColorNum = %d\n",imageUsingColorNum);
		}

		/* default colormap */
		else {
			if(app_data.verbose && app_data.debug)
				fprintf(stderr,"imageUsingColorNum = %d\n",imageUsingColorNum);

			/* Frees needless color cells */
			if(imageUsingColorNum < allocatedColorNum){
				XFreeColors(	theDisp,theCmap,
								&pixels[imageUsingColorNum],
								allocatedColorNum - imageUsingColorNum,
								0L	);
				allocatedColorNum = imageUsingColorNum;
			}
		}


		/* Remakes the image to suit the colormap */
		sptr = dptr = gim.subImageList->image;
		for(j = 0; j < gim.subImageList->height; j++) {
			for(i = 0; i < gim.subImageList->width; i++, sptr++, dptr++) {
				*dptr = (byte) pixels[*sptr];
			}
			myevent();
		}

		/* Creates the XColors */
		for(i = 0; i < gim.subImageList->mapsize; i++){
			xcolors[i].red	 = gim.subImageList->red[i]   * 257;
			xcolors[i].green = gim.subImageList->green[i] * 257;
			xcolors[i].blue  = gim.subImageList->blue[i]  * 257;
			xcolors[i].flags = DoRed | DoGreen | DoBlue;
			xcolors[i].pixel = pixels[i];
		}
		bcol = dbcol;   /* use default black pixel */
		wcol = dwcol;   /* use default white pixel */


		/* Creates the XImage */
		theImage = XCreateImage(	theDisp,theVisual,
									DefaultDepth(theDisp,theScreenNumber),
									ZPixmap,0,
									(char *)gim.subImageList->image,
									(dword)gim.subImageList->width,
									(dword)gim.subImageList->height,
									gim.pmf.scanline_pad,
									(int)gim.subImageList->width	);

		myevent();

		if(theImage)
			return(ERR_NO_ERR);
		else
			return(ERR_IMAGE);
	}

}

/*
* Change the read/write colormap cell corresponding to the
* specified pixel value to the hardware color.
*/
#if defined(__STDC__) || defined(__cplusplus)
void StoreColors(XColor *theColors, int msz)
#else
void StoreColors(theColors, msz)
XColor *theColors;
int msz;
#endif
{
	if(theVisual->class == PseudoColor){
		XStoreColors(theDisp,theCmap,theColors,msz);
		XSync(theDisp, False);
	}
}

/*
* Fill out colormap by a specified color
*/
#if defined(__STDC__) || defined(__cplusplus)
void SetColors(word color, int msz)
#else
void SetColors(color, msz)
word color;
int msz;
#endif
{
int i,j;

	if(theVisual->class == PseudoColor){
		j = msz;
		for(i = 0; i < j; i++){
			fcolors[i].red   = color;
			fcolors[i].green = color;
			fcolors[i].blue  = color;
			fcolors[i].flags = DoRed|DoGreen|DoBlue;
			fcolors[i].pixel = pixels[i];
		}
		StoreColors(fcolors,msz);
		myevent();
	}
}

/*
* Set colors.
*/
void PreDisplay()
{
	if(theVisual->class == PseudoColor){

		/* Blaken the display window */
		SetColors(0x00000000, gim.subImageList->mapsize);

		if((app_data.root || app_data.override)
			&& app_data.privateCmap) 
			XInstallColormap(theDisp,theCmap);
		else
			XSetWindowColormap(theDisp,theWindow,theCmap);

		XSetWindowBackground(theDisp,theWindow,bcol);
		XClearWindow(theDisp,theWindow);

		/* Set system using colors if exist. */
		if(allocatedSysColorNum)
			StoreColors(&xcolors[gim.subImageList->mapsize], allocatedSysColorNum);

	}
	else {
		XSetWindowBackground(theDisp,theWindow,bcol);
		XClearWindow(theDisp,theWindow);
	}
}

void PreDisplay2()
{
	if(theVisual->class == PseudoColor){

		if((app_data.root || app_data.override)
			&& app_data.privateCmap) 
			XInstallColormap(theDisp,theCmap);
		else
			XSetWindowColormap(theDisp,theWindow,theCmap);

		/* Set system using colors if exist. */
		if(allocatedSysColorNum)
			StoreColors(&xcolors[gim.subImageList->mapsize], allocatedSysColorNum);

	}
}


/*
* Unset colors.
*/
void PostDisplay()
{
	if(theVisual->class == PseudoColor){
		if((app_data.root || app_data.override) 
			&& app_data.privateCmap) {
			XUninstallColormap(theDisp,theCmap);
			myusleep(0); /* Flush */
		}
	}
}

