/*
	move.c - animate move

	Author:	Susumu Shiohara (shiohara@tpp.epson.co.jp)

		Copyright 1993-1997 by Susumu Shiohara

			All Rights Reserved

*/

#include "xslideshow.h"
#include "animproto.h"

extern void myevent();

static Window imageWindow=(Window)0;

static void createImage()
{
int	x,y,w,h;

	x = (movep ? -gim.subImageList->width : windowWidth);
	y = (windowHeight - gim.subImageList->height) / 2;
	w = gim.subImageList->width;
	h = gim.subImageList->height;
	ShowImageWindow(&imageWindow, x, y, w, h);
}

static void moveImage()	/* Moving picture */
{
int	x,y,w,h;

	x = (movep ? -gim.subImageList->width : windowWidth);
	y = (windowHeight - gim.subImageList->height) / 2;
	w = gim.subImageList->width;
	h = gim.subImageList->height;

	if(movep){

		for(; x < windowWidth; x += app_data.moveSteps){
			XMoveWindow(theDisp,imageWindow,x,y);
			myusleep(app_data.moveTicks);
			if(gotSomeAction == True)
				break;
		}

	}
	else{

		for(; x > -gim.subImageList->width; x -= app_data.moveSteps){
			XMoveWindow(theDisp,imageWindow,x,y);
			myusleep(app_data.moveTicks);
			if(gotSomeAction == True)
				break;
		}

	}

	movep = !movep;
}

#if defined(__STDC__) || defined(__cplusplus)
ActionStatus xmoveshow(char *fname)
#else
ActionStatus xmoveshow(fname)
char *fname;
#endif
{
	PreDisplay();

	if(app_data.showFileName)
		createFileNameWindow(fname);

	createImage ();

	StoreColors(xcolors,gim.subImageList->mapsize);

	if(app_data.showFileName)
		raiseFileNameWindow();

	moveImage ();

	removeImageWindow(&imageWindow);

	return(mynowait());
}

#if defined(__STDC__) || defined(__cplusplus)
void postxmoveshow(char *fname)
#else
void postxmoveshow(fname)
char *fname;
#endif
{
	if(app_data.showFileName)
		removeFileNameWindow();
}

