# Get some version info
stub=linux-restricted-modules

release := $(shell sed -n '1s/^.*(\(.*\)-.*).*$$/\1/p' debian/changelog)
revisions := $(shell sed -n 's/^lpia-$(stub)\ .*($(release)-\(.*\)).*$$/\1/p' debian/changelog | tac)
revision ?= $(word $(words $(revisions)),$(revisions))
prev_revisions := $(filter-out $(revision),0.0 $(revisions))
prev_revision := $(word $(words $(prev_revisions)),$(prev_revisions))

# This is an internally used mechanism for the daily kernel builds. It
# creates packages who's ABI is suffixed with a minimal representation of
# the current git HEAD sha. If .git/HEAD is not present, then it uses the
# uuidgen program,
#
# AUTOBUILD can also be used by anyone wanting to build a custom kernel
# image, or rebuild the entire set of Ubuntu packages using custom patches
# or configs.
AUTOBUILD ?=

ifneq ($(NOKERNLOG),)
ubuntu_log_opts += --no-kern-log
endif
ifneq ($(PRINTSHAS),)
ubuntu_log_opts += --print-shas
endif

abinum		:= $(shell echo $(revision) | sed -e 's/\..*//')$(abisuffix)
prev_abinum	:= $(shell echo $(prev_revision) | sed -e 's/\..*//')$(abisuffix)
debnum          := -$(abinum)

arch		:= $(shell dpkg-architecture -qDEB_HOST_ARCH)
confdir		:= $(CURDIR)/debian/config/$(arch)
builddir	:= $(CURDIR)/debian/build
stampdir	:= $(CURDIR)/debian/stamps
udebdir		:= $(CURDIR)/debian/d-i-$(arch)

#
# Set this variable to 'true' in the arch makefile in order to
# avoid building udebs for the debian installer. see lpia.mk as
# an example of an architecture specific override.
#
disable_d_i    = no

# Support parallel=<n> in DEB_BUILD_OPTIONS
COMMA=,
ifneq (,$(filter parallel=%,$(subst $(COMMA), ,$(DEB_BUILD_OPTIONS))))
  CONCURRENCY_LEVEL := $(subst parallel=,,$(filter parallel=%,$(subst $(COMMA), ,$(DEB_BUILD_OPTIONS))))
endif

ifeq ($(CONCURRENCY_LEVEL),)
  # Check the environment
  CONCURRENCY_LEVEL := $(shell echo $$CONCURRENCY_LEVEL)
  # No? Check if this is on a buildd
  ifeq ($(CONCURRENCY_LEVEL),)
    ifneq ($(wildcard /CurrentlyBuilding),)
      CONCURRENCY_LEVEL := $(shell expr `getconf _NPROCESSORS_ONLN` \* 2)
    endif
  endif
  # Oh hell, give 'em one
  ifeq ($(CONCURRENCY_LEVEL),)
    CONCURRENCY_LEVEL := 1
  endif
endif

conc_level      = -j$(CONCURRENCY_LEVEL)

# Override KDIR if you want to use a non-standard kernel location.
# You really should use a kernel of the same version as is in changelog or complete
# horkage will ensue. KDIR is typically used on a buildd where you don't have
# privileges to install kernel headers, e.g., test builds after an ABI bump.
#
# You should also note that whatever kernel you point at must have at least
# had 'make silentoldconfig prepare scripts' run. Furthermore, you have to
# do it for each flavour. For example:
#
#	cd ~/ubuntu-intrepid
#	cat debian/config/i386/config debian/config/i386/config.generic > .config
#	make silentoldconfig prepare scripts
#
#	cd ~/ubuntu-intrepid-lrm
#	fakeroot debian/rules binary-debs flavours=generic KDIR=~/ubuntu-hardy
#

KDIR		= /lib/modules/$(release)-$(abinum)-$(target_flavour)/build

# target_flavour is filled in for each step
kmake = make -C $(KDIR) ARCH=$(build_arch_t) M=$(builddir)/build-$(target_flavour) \
	UBUNTU_FLAVOUR=$(target_flavour)

# Checks if a var is overriden by the custom rules. Called with var and
# flavour as arguments.
custom_override = \
 $(shell if [ -n "$($(1)_$(2))" ]; then echo "$($(1)_$(2))"; else echo "$($(1))"; fi)
