// Cyphesis Online RPG Server and AI Engine
// Copyright (C) 2005 Alistair Riddoch
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

// $Id: StatisticsProperty.h,v 1.7 2006-12-12 19:52:39 alriddoch Exp $

#ifndef RULESETS_STATISTICS_PROPERTY_H
#define RULESETS_STATISTICS_PROPERTY_H

#include "common/Property.h"

class Statistics;

/// \brief Class to handle Entity statistics
/// \ingroup PropertyClasses
class StatisticsProperty : public PropertyBase {
  protected:
    /// \brief Reference to variable holding the value of this Property
    Statistics & m_data;
  public:
    explicit StatisticsProperty(Statistics & data, unsigned int flags);

    /// \brief Accessor for the variable holding the value of this Property
    Statistics & data() const { return m_data; }

    virtual bool get(Atlas::Message::Element &) const;
    virtual void set(const Atlas::Message::Element &);
};

#endif // RULESETS_STATISTICS_PROPERTY_H
