/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "commands.h"
#include "populate_root_servers_tab.h"
#include "allocate.h"

extern char CHROOT_PATH_BUF[1024];

extern int activated;

#define TEMP_DIG_FILE "/var/log/gbindadmin_dig"


void update_root_servers(struct w *widgets)
{
    FILE *fp;
    char *buffy, *conf;
    long file_size;    
    int num_lines = 0;
    gchar *info, *command, *root_hints;

    command = g_strdup_printf("%s > %s", DIG_BINARY, TEMP_DIG_FILE);
    if( ! run_command(command) )
      printf("Dig failed: could not get root server listing.\n");

    g_free(command);

    if((fp=fopen(TEMP_DIG_FILE, "r"))==NULL)
    {
	printf("Cannot open temporary dig file: %s", TEMP_DIG_FILE);	
	return;
    }

    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    buffy = allocate(file_size+1);
    conf = allocate(file_size+1);
    
    while(fgets(buffy, file_size, fp)!=NULL)
    {
	strcat(conf, buffy);
	num_lines++;
    }
    fclose(fp);
    free(buffy);

    /* Remove the temp file if it exists */
    if( file_exists(TEMP_DIG_FILE) )
    {
	command = g_strdup_printf("rm -f %s", TEMP_DIG_FILE);
	run_command(command);
	g_free(command);
    }
    
    if( num_lines < 20 )
    {
	info = g_strdup_printf(_("Received less then 20 lines of root server information. Make sure that the resolvers tab has working nameservers listed.\n"));
	show_info(info);
	g_free(info);

	free(conf);
	return;
    }

    root_hints = g_strdup_printf("%s/etc/root.hints", CHROOT_PATH_BUF);        

    if((fp=fopen(root_hints, "w+"))==NULL)
    {
	info = g_strdup_printf(_("Can not write root.hints here:\n%s\n"), root_hints);
	show_info(info);
	g_free(info);

	free(conf);
	g_free(root_hints);
	return;
    }
    fputs(conf, fp);
    fclose(fp);

    free(conf);
    g_free(root_hints);

    populate_root_servers_tab(widgets);
}
