/* -*- Mode: C; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/*
    Gpredict: Real-time satellite tracking and orbit prediction program

    Copyright (C)  2001-2007  Alexandru Csete, OZ9AEC.

    Authors: Alexandru Csete <csete@users.sourceforge.net>

    Comments, questions and bugreports should be submitted via
    http://sourceforge.net/projects/groundstation/
    More details can be found at the project home page:

            http://groundstation.sourceforge.net/
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, visit http://www.fsf.org/
*/


/** \brief Coumn definitions for QTH list. */
typedef enum {
	QTH_LIST_COL_NAME = 0,   /*!< Name of the QTH. */
	QTH_LIST_COL_LOC,        /*!< Location, eg. "Copenhagen, Denmark". */
	QTH_LIST_COL_DESC,       /*!< Optional description. */
	QTH_LIST_COL_LAT,        /*!< Latitude in dec. deg. North. */
	QTH_LIST_COL_LON,        /*!< Longitude in dec. deg. East. */
	QTH_LIST_COL_ALT,        /*!< Altitude in meters. */
	QTH_LIST_COL_QRA,        /*!< QRA locator. */
	QTH_LIST_COL_WX,         /*!< 4 letter weather station. */
	QTH_LIST_COL_DEF,        /*!< Is this QTH the default one? */
	QTH_LIST_COL_NUM         /*!< The number of fields. */
} qth_list_col_t;

