#include <k3dsdk/path.h>

#include <iostream>
#include <sstream>
#include <stdexcept>

int main(int argc, char* argv[])
{
	try
	{
		if(argc != 4)
			throw std::runtime_error("Usage: relative_path [ABSOLUTE PATH] [REFERENCE PATH] [EXPECTED RESULT]");

		const k3d::filesystem::path absolute_path = k3d::filesystem::native_path(k3d::ustring::from_utf8(argv[1]));
		const k3d::filesystem::path reference_path = k3d::filesystem::native_path(k3d::ustring::from_utf8(argv[2]));
		const std::string expected_result = argv[3];

//		std::cerr << "path: " << absolute_path.string() << std::endl;
//		std::cerr << "path: " << absolute_path.native_string() << std::endl;
//		std::cerr << "root path: " << absolute_path.root_path().string() << std::endl;
//		std::cerr << "root name: " << absolute_path.root_name() << std::endl;

		std::ostringstream buffer;
		buffer << k3d::filesystem::make_relative_path(absolute_path, reference_path).native_utf8_string().raw();

		if(buffer.str() != expected_result)
			throw std::runtime_error("expected [" + expected_result + "] got [" + buffer.str() + "]");
	}
	catch(std::exception& e)
	{
		std::cerr << e.what() << std::endl;
		return 1;
	}

	return 0;
}

