/***************************************************************************
                          kallery_def.h  -  description
                             -------------------
    begin                : Mon Oct 22 2001
    copyright            : (C) 2001 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KALLERY_DEF_H
#define KALLERY_DEF_H

#include <qstring.h>
#include <qstringlist.h>
#include <qcolor.h>
#include <qtextstream.h>


/** @short
 * Strutcture describing the options to generate the gallery.
*/
struct OptionType
{
  /** Thumbnail settings */
  enum ThumbSettings
  {
    NoThumbnails = 0, ///< do not use thumbnails
    GenerateThumbnails, ///< generate thumbnails
    LoadThumbnails ///< use a set of images as thumbnails
  };

  /** Description settings */
  enum DescSettings
  {
    NoDescriptions = 0, ///< do not use descriptions
    LoadImageInfo, ///<load the descriptions from the info part of the images (if available)        
    LoadDescriptions, ///< load the descriptions from a text filename
    EnterDescriptions, ///< enter now the descriptions
  };
  
  /** Imagge information loading settings */
  enum ImageInfoSettings
  {
    ImageInfoFileName = 1, ///<include the file name in the description
    ImageInfoFileSize = 2, ///<include the file size in the description
    ImageInfoDimensions = 4, ///<include the image dimensions in the description
    ImageInfoComment = 8, ///<include the image comment in the description
    ImageInfoShootingDate = 16, ///<include the image creation in the description
    ImageInfoExposure =32 ///<include the exposure information in the description
  };

  /** Convertion settings */
  enum ConvertMode
  {
    NoCopyConvert = 0, ///< do not copy or convert the images, use from their original location
    CopyOnly, ///< copy the images to the destination without converting
    Convert, ///< convert the images and copy to the destination
    UseExisting ///< assume the images are already in the destination folder
  };
  
  /** @short
   * Structure for image descriptions 
  */
  struct Description
  {
    QString fileSize; ///< holds the size of the image file in bytes
    QString comment; ///< the image comment
    QString shootingDate; ///< when was the image created
    QString dimension; ///< the dimensions in pixels
    QString exposureInfo; ///< camera, shutter time, aperture information
    
    /** Combine the important informations in one string */
    QString full() {
      QString s;
      if (!comment.isEmpty())
       s = comment + "<br>";
      if (!shootingDate.isEmpty())
       s += shootingDate + "<br>";
      if (!dimension.isEmpty())
       s += dimension + "<br>";
      if (!exposureInfo.isEmpty())
       s += exposureInfo;
      return s;
    }
  };
  
  QString galleryTitle;
  QString galleryFile;
  QStringList imageList;
  QStringList thumbList;
  QValueList<Description> descList;
  QString descFile;
  QString imageDestDir;
  QString thumbDestDir;
  bool relativePaths;
  ThumbSettings thumbSetting; ///< thumbnail settings
  DescSettings descSetting; ///< description settings
  uint infoSetting; 

  ConvertMode convertImages; ///< convertion settings
  bool resize;
  bool keepRatio;
  bool onlyLarger;
  uint thumbWidth,thumbHeight;
  uint fullWidth,fullHeight;
  QString fullFormat;
  QString thumbFormat;
  uint quality;
  bool insertCopyright;
  QString copyright;

  int columnNum;
  bool useHtmlImages;
  //These option are valid only if UseHtmlImages is true
  bool textButtons;     ///<if false, then use pictures for buttons
  QString nextStr;      ///<Valid if TextButtons == true
  QString prevStr;      ///<Valid if TextButtons == true
  QString backStr;      ///<Valid if TextButtons == true
  QString nextPic;      ///<Name of the Next picture. Valid if TextButtons == false
  QString prevPic;      ///<Name of the Previous picture. Valid if TextButtons == false
  QString backPic;      ///<Name of the Back picture. Valid if TextButtons == false
  QColor imageBackColor;
  QColor imageTextColor;
  QColor imageVisitedColor;
  // End of options, when UseHtmlImages is true
  QColor backColor;
  QColor tableColor;
  QColor textColor;
  QColor visitedColor;
  QString galleryCSSFile;
  QString beforeHtmlFile;
  QString afterHtmlFile;
  QString imageCSSFile;

  // Template options
  QString galleryTemplate;        ///<The description of the current gallery template. This is saved
  QString fullsizeTemplate;       ///<The description of the current fullsize template. This is saved
  QString fullsizeTemplateFile;   ///<The path and name to the template file used for html generation for each image
  QString galleryTemplateFile;    ///<The path and name of the gallery template file
  QString language;
  QString encoding;
  bool  useFrames;

  QString projectFileName;        ///<The name of the original project
  QString fileName;               ///<The name of the current file
  bool printToStdOut;             ///< Print the created file list to stdout or not.
};

#endif //KALLERY_DEF_H
