/***************************************************************************
    copyright            : (C) 2001, 2006 by Mantia Andras
    email                : amantia@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own includes
#include "thumbssourcepage.h"
#include "kalleryglobals.h"

#include "kalleryfunctions.h"

//KDE includes
#include <kapplication.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kpushbutton.h>

//Qt includes
#include <qlabel.h>
#include <qradiobutton.h>

ThumbsSourcePage::ThumbsSourcePage(QWidget *parent, const char *name)
    :KThumbSourcePage(parent, name)
{
  LogoPixmap->setPixmap(QPixmap(KalleryGlobals::ref()->baseDir() + "images/kallery.png", 0, QPixmap::Auto));
  AddBtn->setIconSet(BarIconSet("edit_add"));
  DeleteBtn->setIconSet(BarIconSet("edit_remove"));
  connect(AddBtn, SIGNAL(clicked()), this, SLOT(slotLoadThumbnails()));
  connect(DeleteBtn, SIGNAL(clicked()), this, SLOT(slotRemoveThumbnail()));
}

void ThumbsSourcePage::slotLoadThumbnails()
{
  if (LoadThumbBtn->isChecked())
  {
    KalleryGlobals::ref()->options.thumbList +=  KFileDialog::getOpenFileNames(0, KalleryGlobals::ref()->imageFilter(),this,i18n("Select thumbnail files"));

    ImageListBox->clear();
    ImageListBox->insertStringList(KalleryGlobals::ref()->options.thumbList,-1);
    ImageListBox->setSelected(0,true);
    ImageNumTxt->setText( i18n(" %1 items.").arg(KalleryGlobals::ref()->options.thumbList.count()));
  }
}

void ThumbsSourcePage::slotRemoveThumbnail()
{
  KalleryFunctions::ref()->deleteFromList(ImageListBox,KalleryGlobals::ref()->options.thumbList, ImageNumTxt, 0L);
}

void ThumbsSourcePage::invokeHelp()
{
   kapp->invokeHelp("thumbnails-page", "kallery");
}

bool ThumbsSourcePage::processPage()
{
  if (NoThumbBtn->isChecked()) KalleryGlobals::ref()->options.thumbSetting = OptionType::NoThumbnails;
  if (GenerateThumbBtn->isChecked()) KalleryGlobals::ref()->options.thumbSetting = OptionType::GenerateThumbnails;
  if (LoadThumbBtn->isChecked()) KalleryGlobals::ref()->options.thumbSetting = OptionType::LoadThumbnails;

  if ( (KalleryGlobals::ref()->options.thumbSetting == OptionType::LoadThumbnails) && (KalleryGlobals::ref()->options.thumbList.count() != KalleryGlobals::ref()->options.imageList.count()) )
  {
    KMessageBox::error(this,i18n("The number of thumbnail files is not equal with the number of image files!\n\n %1 thumbnails, but\n %2 image files were selected.") \
                                                  .arg(KalleryGlobals::ref()->options.thumbList.count()).arg(KalleryGlobals::ref()->options.imageList.count()),i18n("Number mismatch error"),true);
    return false;
  }


  return true;
}


void ThumbsSourcePage::setupPage()
{
  GenerateThumbBtn->setChecked(KalleryGlobals::ref()->options.thumbSetting == OptionType::GenerateThumbnails);
  LoadThumbBtn->setChecked(KalleryGlobals::ref()->options.thumbSetting == OptionType::LoadThumbnails);
  NoThumbBtn->setChecked(KalleryGlobals::ref()->options.thumbSetting == OptionType::NoThumbnails);
  ImageListBox->clear();
  ImageListBox->insertStringList(KalleryGlobals::ref()->options.thumbList,-1);
  ImageNumTxt->setText(i18n("%1 items.").arg(KalleryGlobals::ref()->options.thumbList.count()));
  ImageListBox->setSelected(0,true);
}

#include "thumbssourcepage.moc"
