/*
    ldapdiff
    Copyright (C) 2000-2002 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <lber.h>
#include <ldap.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "ldapdiff.h"

#include <iconv.h>

static iconv_t cd = (iconv_t)-1;

void ldificonvopen()
{
 if(cd != (iconv_t)-1){
  return;
 }

 if((cd = iconv_open(ldifgetgconf(CONFLDAPCHARSET),ldifgetgconf(CONFLDIFCHARSET))) == (iconv_t)-1){
  fprintf(stderr,"iconv_open failed file:%s line:%d\n",__FILE__,__LINE__);
  exit(-1);
 }
}

int ldificonv(char **in, char **out)
{
 size_t    inbytesleft;
 size_t    outbytesleft;

 if(cd == (iconv_t)-1){
  return -1;
 }

 inbytesleft  = strlen(*in);
 outbytesleft = strlen(*in) * 2;
 if(iconv(cd,in,&inbytesleft,out,&outbytesleft) == (size_t)-1){
  fprintf(stderr,"iconv failed file:%s line:%d\n",__FILE__,__LINE__);
  return -1;
 }
 return 0;
}

void ldificonvclose()
{
 if(cd == (iconv_t)-1){
  return;
 }
 if(iconv_close(cd) == -1){
  fprintf(stderr,"iconv_close failed file:%s line:%d\n",__FILE__,__LINE__);
  exit(-1);
 }
 cd = (iconv_t)-1;
}
