/*
 * Copyright (C) 2004--2008  Enrico Zini <enrico@enricozini.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tests/test-utils.h>
#include <buffy/config/config.h>
#include <buffy/mailfolder/mailbox.h>

using namespace std;

namespace tut {
using namespace buffy::config;
using namespace wibble::tests;

struct buffy_config_shar {
	Config conf;
	buffy_config_shar() : conf("nonexisting-config.txt") {
	}
	~buffy_config_shar() {
		unlink("test-config-saved.txt");
	}
};
TESTGRP(buffy_config);

// Check an application value
template<> template<>
void to::test<1>()
{
	ensure_equals(conf.application("foo").get("bar"), "");
	conf.application("foo").addDefault("bar", "baz");
	ensure_equals(conf.application("foo").get("bar"), "baz");
	conf.application("foo").set("bar", "cippo");
	ensure_equals(conf.application("foo").get("bar"), "cippo");
}

// Check an application value with path
template<> template<>
void to::test<2>()
{
	ensure_equals(conf.application("foo").get("bar/baz"), "");
	conf.application("foo").addDefault("bar/baz", "lippo");
	ensure_equals(conf.application("foo").get("bar/baz"), "lippo");
	conf.application("foo").set("bar/baz", "lippo1");
	ensure_equals(conf.application("foo").get("bar/baz"), "lippo1");
}

// Check mail programs
template<> template<>
void to::test<3>()
{
	vector<MailProgramNode> programs = conf.mailPrograms().get();
	ensure_equals(programs.size(), 2u);

	ensure_equals(conf.mailPrograms().selected().name(), "Mutt");

	conf.mailProgram("Other").setSelected();
	ensure_equals(conf.mailPrograms().selected().name(), "Other");
	ensure_equals(conf.mailProgram("Mutt").selected(), false);
}

// Check that squares, used as special values internally, parse correctly
template<> template<>
void to::test<4>()
{
	ensure_equals(conf.application("foo]").get("bar"), "");
	conf.application("foo]").set("bar", "cippo2");
	ensure_equals(conf.application("foo]").get("bar"), "cippo2");
}

// Check loading an existing configuration
template<> template<>
void to::test<5> ()
{
	Config conf0("test-config.txt");

	ensure(!conf0.view().read());
	ensure(!conf0.view().empty());
	ensure(conf0.view().important());
	ensure_equals(conf0.general().interval(), 600);

	vector<string> locations = conf0.locations().get();
	ensure_equals(locations.size(), 4u);

#if 0
	/*
	   gen_ensure(locations.find("/var/mail/enrico") != locations.end());
	   gen_ensure(locations.find("/home/enrico/Maildir") != locations.end());
	   gen_ensure(locations.find("/home/enrico/Mail") != locations.end());
	   gen_ensure(locations.find("/home/enrico/mail") != locations.end());
	*/
#endif

	vector<MailProgramNode> programs = conf0.mailPrograms().get();
	ensure_equals(programs.size(), 2u);

	ensure_equals(conf0.mailPrograms().selected().name(), "Mutt");
}

// Check persistance when saving and reloading an existing configuration
template<> template<>
void to::test<6> ()
{
	Config conf0;
	stringstream str;
	str << getpid();
	string testString(str.str());
	buffy::MailFolder testFolder(new buffy::mailfolder::Mailbox("mbox/empty.mbox"));

	// Set a few nonstandard values, then save them
	vector<string> locations;
	locations.clear();
	locations.push_back("foo");
	locations.push_back("bar");
	locations.push_back("baz");
	conf0.locations().set(locations);
	conf0.application("test").set("pid", testString);
	conf0.folder(testFolder).setForceView(true);
	conf0.folder(testFolder).setForceHide(false);
	conf0.save("test-config-saved.txt");

	// Load the config file that we just saved
	Config conf1("test-config-saved.txt");
	ensure_equals(conf1.application("test").get("pid"), testString);
	ensure_equals(conf1.folder(testFolder).forceview(), true);
	ensure_equals(conf1.folder(testFolder).forcehide(), false);
	ensure_equals(conf1.locations().get().size(), 3u);
}

}

// vim:set ts=4 sw=4:
