/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#include "s-view.h"

#include "cc-test-view.h"

START_TEST(test_view_transformations_direct)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME:
	 * Implement a test that makes sure that the transformation functions
	 * get called if implemented.
	 */
}
END_TEST

START_TEST(test_view_transformations_indirect)
{
	/* prepare */
	CcView* view = cc_test_view_new ();
	// FIXME: set transformation matrix

	/* check */
	// FIXME: check transformations
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* cleanup */
	g_object_unref (view);
}
END_TEST

START_TEST(test_view_transformations_priority)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);

	/* FIXME:
	 * Implement a test that makes sure that the tranformation matrix is
	 * the preferred API. (Implement a sample class for this test.)
	 */
}
END_TEST

TCase*
tcase_view_transformations (void)
{
	TCase* self = tcase_create ("Transformations");
	tcase_add_test (self, test_view_transformations_direct);
	tcase_add_test (self, test_view_transformations_indirect);
	tcase_add_test (self, test_view_transformations_priority);
	return self;
}

