#!/bin/sh

set -e

DESTDIR=`readlink -f ${DESTDIR:-../tarballs}`
MODULE=CGI-Application-Plugin-DevPopup
PACKAGE=libcgi-application-plugin-devpopup-perl
VERSION=1.06
QUERY_VERS=1.03
PARAMS_VERS=1.01
FD=--force-download
NS=--no-symlink
RE=--rename
DD="--destdir ${DESTDIR}"
RS=--report-status
DC=-"-watch debian/components"
US=--upstream-version

if [ $1 ]
then
    echo update;
    rm -f ${DESTDIR}/${MODULE}*.tar.gz
    uscan ${FD} ${RE} ${DD} && true;
    uscan ${DC}/p/watch ${FD} ${NS} ${DD} ${US} ${PARAMS_VERS} && true;
    uscan ${DC}/q/watch --repack ${FD} ${NS} ${DD} ${US} ${QUERY_VERS} && true;
    cd ${DESTDIR}
    QUERY=`ls CGI-Application-Plugin-DevPopup-Query*.tar.gz`
    mv ${QUERY} ${PACKAGE}_${VERSION}.orig-q.tar.gz
    PARAMS=`ls CGI-Application-Plugin-DevPopup-Params*.tar.gz`
    mv ${PARAMS} ${PACKAGE}_${VERSION}.orig-p.tar.gz
else
    echo report;
    uscan ${RS} && true;
    uscan ${DC}/p/watch ${RS} ${DD} ${US} ${PARAMS_VERS} && true;
    uscan ${DC}/q/watch ${RS} ${DD} ${US} ${QUERY_VERS} && true;
fi
