#
# MainPage.rb
#

class MainPage < CKComponent
	COOKIE = 'cookie_counter'
	
	def init
		@count = 0
		_read_cookie
		_add_cookie
	end
	
	private
	
	def _read_cookie
		@cookie = request.cookie COOKIE

		unless @cookie
			@cookie = CKCookie.new( COOKIE, 0 )
		end

		@count = @cookie.value.to_i
	end
	
	def _add_cookie
		@count += 1
		@cookie.value = @count

		response.add_cookie @cookie
	end

	public

	def cookie
		@cookie.inspect
	end
	
	def count
		@count
	end
end


