/* launcher-vala.c generated by valac 0.11.7, the Vala compiler
 * generated from launcher-vala.vala, do not modify */

/*
 * Copyright (C) 2010 Simon Wenner <simon@wenner.ch>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <champlain/champlain.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_LAUNCHER (launcher_get_type ())
#define LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAUNCHER, Launcher))
#define LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAUNCHER, LauncherClass))
#define IS_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAUNCHER))
#define IS_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAUNCHER))
#define LAUNCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAUNCHER, LauncherClass))

typedef struct _Launcher Launcher;
typedef struct _LauncherClass LauncherClass;
typedef struct _LauncherPrivate LauncherPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DEMO_LAYER (demo_layer_get_type ())
#define DEMO_LAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEMO_LAYER, DemoLayer))
#define DEMO_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEMO_LAYER, DemoLayerClass))
#define IS_DEMO_LAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEMO_LAYER))
#define IS_DEMO_LAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEMO_LAYER))
#define DEMO_LAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEMO_LAYER, DemoLayerClass))

typedef struct _DemoLayer DemoLayer;
typedef struct _DemoLayerClass DemoLayerClass;

struct _Launcher {
	GObject parent_instance;
	LauncherPrivate * priv;
};

struct _LauncherClass {
	GObjectClass parent_class;
};

struct _LauncherPrivate {
	ChamplainView* view;
	ClutterStage* stage;
};


static gpointer launcher_parent_class = NULL;

GType launcher_get_type (void) G_GNUC_CONST;
#define LAUNCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LAUNCHER, LauncherPrivate))
enum  {
	LAUNCHER_DUMMY_PROPERTY
};
#define LAUNCHER_PADDING 10
Launcher* launcher_new (void);
Launcher* launcher_construct (GType object_type);
ClutterActor* launcher_make_button (Launcher* self, const gchar* text);
static gboolean _lambda0_ (ClutterButtonEvent* event, Launcher* self);
static gboolean __lambda0__clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean _lambda1_ (ClutterButtonEvent* event, Launcher* self);
static gboolean __lambda1__clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
DemoLayer* demo_layer_new (void);
DemoLayer* demo_layer_construct (GType object_type);
GType demo_layer_get_type (void) G_GNUC_CONST;
static gboolean launcher_button_release_cb (Launcher* self, ClutterButtonEvent* event);
static gboolean _launcher_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
void launcher_show (Launcher* self);
gint launcher_main (gchar** args, int args_length1);
static void launcher_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda0_ (ClutterButtonEvent* event, Launcher* self) {
	gboolean result = FALSE;
	champlain_view_zoom_in (self->priv->view);
	result = TRUE;
	return result;
}


static gboolean __lambda0__clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = _lambda0_ (event, self);
	return result;
}


static gboolean _lambda1_ (ClutterButtonEvent* event, Launcher* self) {
	gboolean result = FALSE;
	champlain_view_zoom_out (self->priv->view);
	result = TRUE;
	return result;
}


static gboolean __lambda1__clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = _lambda1_ (event, self);
	return result;
}


static gboolean _launcher_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = launcher_button_release_cb (self, event);
	return result;
}


Launcher* launcher_construct (GType object_type) {
	Launcher * self = NULL;
	gfloat width = 0.0F;
	gfloat total_width;
	ClutterStage* _tmp0_ = NULL;
	ClutterStage* _tmp1_;
	ChamplainView* _tmp2_ = NULL;
	ClutterGroup* _tmp3_ = NULL;
	ClutterGroup* buttons;
	ClutterActor* _tmp4_ = NULL;
	ClutterActor* button;
	gfloat _tmp5_;
	ClutterActor* _tmp6_ = NULL;
	gfloat _tmp7_;
	DemoLayer* _tmp8_ = NULL;
	DemoLayer* layer;
	self = (Launcher*) g_object_new (object_type, NULL);
	total_width = (gfloat) 0;
	_tmp0_ = clutter_stage_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->stage);
	self->priv->stage = _tmp1_;
	clutter_stage_set_title (self->priv->stage, "Champlain Vala Example");
	clutter_actor_set_size ((ClutterActor*) self->priv->stage, (gfloat) 800, (gfloat) 600);
	_tmp2_ = (ChamplainView*) champlain_view_new ();
	_g_object_unref0 (self->priv->view);
	self->priv->view = g_object_ref_sink (_tmp2_);
	clutter_actor_set_size ((ClutterActor*) self->priv->view, (gfloat) 800, (gfloat) 600);
	clutter_container_add_actor ((ClutterContainer*) self->priv->stage, (ClutterActor*) self->priv->view);
	_tmp3_ = (ClutterGroup*) clutter_group_new ();
	buttons = g_object_ref_sink (_tmp3_);
	clutter_actor_set_position ((ClutterActor*) buttons, (gfloat) LAUNCHER_PADDING, (gfloat) LAUNCHER_PADDING);
	_tmp4_ = launcher_make_button (self, "Zoom in");
	button = _tmp4_;
	clutter_container_add_actor ((ClutterContainer*) buttons, button);
	clutter_actor_set_reactive (button, TRUE);
	clutter_actor_get_size (button, &_tmp5_, NULL);
	width = _tmp5_;
	total_width = total_width + (width + LAUNCHER_PADDING);
	g_signal_connect_object (button, "button-release-event", (GCallback) __lambda0__clutter_actor_button_release_event, self, 0);
	_tmp6_ = launcher_make_button (self, "Zoom out");
	_g_object_unref0 (button);
	button = _tmp6_;
	clutter_container_add_actor ((ClutterContainer*) buttons, button);
	clutter_actor_set_reactive (button, TRUE);
	clutter_actor_set_position (button, total_width, (gfloat) 0);
	clutter_actor_get_size (button, &_tmp7_, NULL);
	width = _tmp7_;
	total_width = total_width + (width + LAUNCHER_PADDING);
	g_signal_connect_object (button, "button-release-event", (GCallback) __lambda1__clutter_actor_button_release_event, self, 0);
	clutter_container_add_actor ((ClutterContainer*) self->priv->stage, (ClutterActor*) buttons);
	_tmp8_ = demo_layer_new ();
	layer = g_object_ref_sink (_tmp8_);
	champlain_view_add_layer (self->priv->view, (ChamplainLayer*) layer);
	clutter_actor_set_reactive ((ClutterActor*) self->priv->view, TRUE);
	g_signal_connect_object ((ClutterActor*) self->priv->view, "button-release-event", (GCallback) _launcher_button_release_cb_clutter_actor_button_release_event, self, 0);
	champlain_view_set_zoom_level (self->priv->view, (guint) 7);
	champlain_view_set_kinetic_mode (self->priv->view, TRUE);
	champlain_view_center_on (self->priv->view, 45.466, -73.75);
	_g_object_unref0 (layer);
	_g_object_unref0 (button);
	_g_object_unref0 (buttons);
	return self;
}


Launcher* launcher_new (void) {
	return launcher_construct (TYPE_LAUNCHER);
}


void launcher_show (Launcher* self) {
	g_return_if_fail (self != NULL);
	clutter_actor_show ((ClutterActor*) self->priv->stage);
}


static gboolean launcher_button_release_cb (Launcher* self, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	gdouble lat = 0.0;
	gdouble lon = 0.0;
	gboolean _tmp0_ = FALSE;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).button != 1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (*event).click_count > 1;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = champlain_view_y_to_latitude (self->priv->view, (gdouble) (*event).y);
	lat = _tmp1_;
	_tmp2_ = champlain_view_x_to_longitude (self->priv->view, (gdouble) (*event).x);
	lon = _tmp2_;
	g_print ("Map clicked at %f, %f \n", lat, lon);
	result = TRUE;
	return result;
}


ClutterActor* launcher_make_button (Launcher* self, const gchar* text) {
	ClutterActor* result = NULL;
	ClutterColor _tmp0_ = {0};
	ClutterColor white;
	ClutterColor _tmp1_ = {0};
	ClutterColor black;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	ClutterGroup* _tmp2_ = NULL;
	ClutterGroup* button;
	ClutterRectangle* _tmp3_ = NULL;
	ClutterRectangle* button_bg;
	ClutterText* _tmp4_ = NULL;
	ClutterText* button_text;
	gfloat _tmp5_;
	gfloat _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_.red = (guchar) 0xff;
	_tmp0_.green = (guchar) 0xff;
	_tmp0_.blue = (guchar) 0xff;
	_tmp0_.alpha = (guchar) 0xff;
	white = _tmp0_;
	_tmp1_.red = (guchar) 0x00;
	_tmp1_.green = (guchar) 0x00;
	_tmp1_.blue = (guchar) 0x00;
	_tmp1_.alpha = (guchar) 0xff;
	black = _tmp1_;
	_tmp2_ = (ClutterGroup*) clutter_group_new ();
	button = g_object_ref_sink (_tmp2_);
	_tmp3_ = (ClutterRectangle*) clutter_rectangle_new_with_color (&white);
	button_bg = g_object_ref_sink (_tmp3_);
	clutter_container_add_actor ((ClutterContainer*) button, (ClutterActor*) button_bg);
	clutter_actor_set_opacity ((ClutterActor*) button_bg, (guint) 0xcc);
	_tmp4_ = (ClutterText*) clutter_text_new_full ("Sans 10", text, &black);
	button_text = g_object_ref_sink (_tmp4_);
	clutter_container_add_actor ((ClutterContainer*) button, (ClutterActor*) button_text);
	clutter_actor_get_size ((ClutterActor*) button_text, &_tmp5_, &_tmp6_);
	width = _tmp5_;
	height = _tmp6_;
	clutter_actor_set_size ((ClutterActor*) button_bg, width + (LAUNCHER_PADDING * 2), height + (LAUNCHER_PADDING * 2));
	clutter_actor_set_position ((ClutterActor*) button_bg, (gfloat) 0, (gfloat) 0);
	clutter_actor_set_position ((ClutterActor*) button_text, (gfloat) LAUNCHER_PADDING, (gfloat) LAUNCHER_PADDING);
	result = (ClutterActor*) button;
	_g_object_unref0 (button_text);
	_g_object_unref0 (button_bg);
	return result;
}


gint launcher_main (gchar** args, int args_length1) {
	gint result = 0;
	Launcher* _tmp0_ = NULL;
	Launcher* launcher;
	clutter_init (&args_length1, &args);
	_tmp0_ = launcher_new ();
	launcher = _tmp0_;
	launcher_show (launcher);
	clutter_main ();
	result = 0;
	_g_object_unref0 (launcher);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return launcher_main (argv, argc);
}


static void launcher_class_init (LauncherClass * klass) {
	launcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LauncherPrivate));
	G_OBJECT_CLASS (klass)->finalize = launcher_finalize;
}


static void launcher_instance_init (Launcher * self) {
	self->priv = LAUNCHER_GET_PRIVATE (self);
}


static void launcher_finalize (GObject* obj) {
	Launcher * self;
	self = LAUNCHER (obj);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->stage);
	G_OBJECT_CLASS (launcher_parent_class)->finalize (obj);
}


GType launcher_get_type (void) {
	static volatile gsize launcher_type_id__volatile = 0;
	if (g_once_init_enter (&launcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LauncherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) launcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Launcher), 0, (GInstanceInitFunc) launcher_instance_init, NULL };
		GType launcher_type_id;
		launcher_type_id = g_type_register_static (G_TYPE_OBJECT, "Launcher", &g_define_type_info, 0);
		g_once_init_leave (&launcher_type_id__volatile, launcher_type_id);
	}
	return launcher_type_id__volatile;
}



