/*--------------------------------------------------------------------------+
$Id: SmartRMISocketFactory.java 28668 2010-06-23 14:46:45Z heineman $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;

/**
 * A {@link RMISocketFactory} that adjusts flags on the sockets used. One is
 * that for the server socket the reuse flag is set, which allows fast
 * reopening. Second, an optional timeout can be set.
 * 
 * @author hummelb
 * @author $Author: heineman $
 * @version $Rev: 28668 $
 * @levd.rating GREEN Hash: 676BF40E769C33456EE7029EE0E3949A
 */
public class SmartRMISocketFactory extends RMISocketFactory {

	/** Timeout in seconds. */
	private final int timeoutSeconds;

	/** Constructor. No timeout is set. */
	public SmartRMISocketFactory() {
		this(-1);
	}

	/** Constructor */
	public SmartRMISocketFactory(int timeoutSeconds) {
		this.timeoutSeconds = timeoutSeconds;
	}

	/** {@inheritDoc} */
	@Override
	public Socket createSocket(String host, int port) throws IOException {
		Socket socket = getDefaultSocketFactory().createSocket(host, port);
		if (timeoutSeconds > 0) {
			socket.setSoTimeout(timeoutSeconds * 1000);
		}
		return socket;
	}

	/** {@inheritDoc} */
	@Override
	public ServerSocket createServerSocket(int port) throws IOException {
		ServerSocket socket = getDefaultSocketFactory()
				.createServerSocket(port);
		socket.setReuseAddress(true);
		return socket;
	}
}
