/*--------------------------------------------------------------------------+
$Id: RegularDirectoryFilterTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.filesystem;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

/**
 * Test case for {@link RegularDirectoryFilter}.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 6E73161EF892F789AAE1FB8FEE1BCD50
 */
public class RegularDirectoryFilterTest extends TestCase {

	/** Test {@link RegularDirectoryFilter}. */
	public void test() {
		File base = new File(".");

		List<File> expected = new ArrayList<File>();

		for (File file : FileSystemUtils.listFilesRecursively(base,
				new DirectoryOnlyFilter())) {
			if (!file.getName().startsWith(".")) {
				expected.add(file);
			}
		}

		List<File> actual = FileSystemUtils.listFilesRecursively(base,
				new RegularDirectoryFilter());

		assertEquals(expected, actual);

	}
}