/*--------------------------------------------------------------------------+
$Id: UnionFindTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.algo;

import junit.framework.TestCase;

/**
 * Tests for the {@link UnionFind} class. This only tests correctness, but not
 * correct implementation in terms of efficiency.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 9AD71653E9C088473BA7C0A3DC73E108
 */
public class UnionFindTest extends TestCase {

	/** Tests whether all new elements are in different classes. */
	public void testAllNewDifferent() {
		UnionFind uf = new UnionFind();
		int amount = 10;
		for (int i = 0; i < amount; ++i) {
			uf.addElement();
		}
		for (int i = 0; i < amount; ++i) {
			for (int j = i + 1; j < amount; ++j) {
				assertFalse(uf.find(i) == uf.find(j));
			}
		}
	}

	/** Tests whether merging all elements works as expected. */
	public void testMergeAll() {
		UnionFind uf = new UnionFind();
		int amount = 10;
		for (int i = 0; i < amount; ++i) {
			uf.addElement();
		}
		for (int i = 0; i < amount; ++i) {
			for (int j = i + 1; j < amount; ++j) {
				uf.union(i, j);
			}
		}
		for (int i = 0; i < amount; ++i) {
			for (int j = i + 1; j < amount; ++j) {
				assertEquals(uf.find(i), uf.find(j));
			}
		}
	}

}