/*
 * libexplain - Explain errno values returned by libc functions
 * Copyright (C) 2009 Peter Miller
 * Written by Peter Miller <pmiller@opensource.org.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <libexplain/ac/sys/ioctl.h>
#include <libexplain/ac/sys/stat.h>

#include <libexplain/buffer/int.h>
#include <libexplain/iocontrol/fionread.h>


static void
print_data(const explain_iocontrol_t *p, explain_string_buffer_t *sb,
    int errnum, int fildes, int request, const void *data)
{
    (void)p;
    (void)errnum;
    (void)fildes;
    (void)request;
    explain_buffer_int_star(sb, data);
}


static int
disambiguate(int fildes, int request, const void *data)
{
    struct stat     st;

    /* success = 0, failure = -1 */
    (void)request;
    (void)data;
    if (fstat(fildes, &st) < 0)
        return 0; /* "everything else" */
    switch (st.st_mode & S_IFMT)
    {
    case S_IFSOCK:
    case S_IFCHR:
        return -1;

    default:
        return 0;
    }
}


/*
 * We have conflicts:
 * SIOCINQ -- sockets only
 * TIOCINQ -- terminals only
 * FIONREAD -- everything else
 */
const explain_iocontrol_t explain_iocontrol_fionread =
{
    "FIONREAD", /* name */
    FIONREAD, /* value */
    disambiguate,
    0, /* print_name */
    print_data,
    0, /* print_explanation */
    0, /* print_data_returned */
    __FILE__,
    __LINE__,
};
